/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.CountResult;
import net.sourceforge.squirrel_sql.client.session.IWhereClausePartUtil;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IWhereClausePart;

public class WhereClausePartUtil
implements IWhereClausePartUtil {
    @Override
    public String createWhereClause(List<IWhereClausePart> whereClauseParts) {
        StringBuilder sb = new StringBuilder("");
        for (IWhereClausePart whereClausePart : whereClauseParts) {
            if (!whereClausePart.shouldBeUsed()) continue;
            whereClausePart.appendToClause(sb);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    @Override
    public int setParameters(PreparedStatement pstmt, List<IWhereClausePart> whereClauseParts, int firstPosition, CountResult countResult) throws SQLException {
        int position = firstPosition;
        for (IWhereClausePart whereClausePart : whereClauseParts) {
            if (!whereClausePart.shouldBeUsed() || !whereClausePart.isParameterUsed()) continue;
            if (null != countResult) {
                countResult.addWhereClausePart(whereClausePart.getWhereClause(), whereClausePart.getParamValue());
            }
            whereClausePart.setParameter(pstmt, position);
            ++position;
        }
        return position++;
    }

    @Override
    public boolean hasUsableWhereClause(List<IWhereClausePart> whereClauseParts) {
        if (whereClauseParts == null || whereClauseParts.isEmpty()) {
            return false;
        }
        for (IWhereClausePart whereClausePart : whereClauseParts) {
            if (!whereClausePart.shouldBeUsed()) continue;
            return true;
        }
        return false;
    }
}

