/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.dockablewindows;

import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.fife.ui.dockablewindows.DockableWindow;
import org.fife.ui.dockablewindows.DockableWindowPanel;

public class Actions {
    private Actions() {
    }

    public static JPopupMenu createRedockPopupMenu(DockableWindowPanel dwindPanel) {
        JPopupMenu popup = new JPopupMenu();
        JMenu dockedLocMenu = new JMenu(DockableWindow.getString("Dock.Location"));
        dockedLocMenu.add(new JMenuItem(new RedockAction(dwindPanel, 1, "Dock.Left")));
        dockedLocMenu.add(new JMenuItem(new RedockAction(dwindPanel, 3, "Dock.Right")));
        dockedLocMenu.add(new JMenuItem(new RedockAction(dwindPanel, 2, "Dock.Bottom")));
        dockedLocMenu.add(new JMenuItem(new RedockAction(dwindPanel, 0, "Dock.Top")));
        dockedLocMenu.add(new JMenuItem(new RedockAction(dwindPanel, 4, "Dock.Floating")));
        popup.add(dockedLocMenu);
        popup.addSeparator();
        popup.add(new JMenuItem(new CloseAction(dwindPanel)));
        return popup;
    }

    public static class RedockAction
    extends DockableActionBase {
        private int location;

        public RedockAction(DockableWindowPanel dwindPanel, int location, String nameKey) {
            super(dwindPanel);
            this.putValue("Name", DockableWindow.getString(nameKey));
            this.location = location;
        }

        public void actionPerformed(ActionEvent e) {
            Container source = (Container)e.getSource();
            JComponent invoker = this.getOriginalInvoker(source);
            DockableWindow dwind = (DockableWindow)invoker.getClientProperty("DockableWindow");
            dwind.setPosition(this.location);
        }
    }

    private static abstract class DockableActionBase
    extends AbstractAction {
        protected DockableWindowPanel dwindPanel;

        public DockableActionBase(DockableWindowPanel dwindPanel) {
            this.dwindPanel = dwindPanel;
        }

        protected JComponent getOriginalInvoker(Container source) {
            JPopupMenu popup = (JPopupMenu)source.getParent();
            JComponent invoker = (JComponent)popup.getInvoker();
            while (invoker instanceof JMenu) {
                popup = (JPopupMenu)((JMenu)invoker).getParent();
                invoker = (JComponent)popup.getInvoker();
            }
            return invoker;
        }
    }

    public static class CloseAction
    extends DockableActionBase {
        public CloseAction(DockableWindowPanel dwindPanel) {
            super(dwindPanel);
            this.putValue("Name", DockableWindow.getString("PopupMenu.Close"));
        }

        public void actionPerformed(ActionEvent e) {
            Container source = (Container)e.getSource();
            JComponent invoker = this.getOriginalInvoker(source);
            DockableWindow dwind = (DockableWindow)invoker.getClientProperty("DockableWindow");
            this.dwindPanel.removeDockableWindow(dwind);
            dwind.setActive(false);
        }
    }
}

