/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import net.sourceforge.napkinlaf.util.NapkinUtil;

public class NapkinRepaintManager
extends RepaintManager {
    private final RepaintManager manager;

    private NapkinRepaintManager(RepaintManager manager) {
        this.manager = manager;
    }

    public static NapkinRepaintManager wrap(RepaintManager manager) {
        if (manager instanceof NapkinRepaintManager) {
            return (NapkinRepaintManager)manager;
        }
        return new NapkinRepaintManager(manager);
    }

    public static RepaintManager unwrap(RepaintManager manager) {
        return manager instanceof NapkinRepaintManager ? ((NapkinRepaintManager)manager).manager : manager;
    }

    private void repaintNapkinParent(JComponent component) {
        this.repaintNapkinParent(component, component.getVisibleRect());
    }

    private void repaintNapkinParent(JComponent component, Rectangle region) {
        Container container = component;
        Rectangle bounds = new Rectangle();
        while (container != null && !NapkinUtil.isNapkinInstalled(container)) {
            ((Component)container).getBounds(bounds);
            container = container.getParent();
            region.x += bounds.x;
            region.y += bounds.y;
        }
        if (container != component && NapkinUtil.isNapkinInstalled(container)) {
            this.manager.addDirtyRegion((JComponent)container, region.x, region.y, region.width, region.height);
        }
    }

    public void markCompletelyDirty(JComponent aComponent) {
        this.repaintNapkinParent(aComponent);
        this.manager.markCompletelyDirty(aComponent);
    }

    public void addInvalidComponent(JComponent invalidComponent) {
        this.repaintNapkinParent(invalidComponent);
        this.manager.addInvalidComponent(invalidComponent);
    }

    public void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
        this.repaintNapkinParent(c, new Rectangle(x, y, w, h));
        this.manager.addDirtyRegion(c, x, y, w, h);
    }

    public Image getOffscreenBuffer(Component c, int proposedWidth, int proposedHeight) {
        return this.manager.getOffscreenBuffer(c, proposedWidth, proposedHeight);
    }

    public Image getVolatileOffscreenBuffer(Component c, int proposedWidth, int proposedHeight) {
        return this.manager.getVolatileOffscreenBuffer(c, proposedWidth, proposedHeight);
    }

    public void setDoubleBufferMaximumSize(Dimension d) {
        this.manager.setDoubleBufferMaximumSize(d);
    }

    public void setDoubleBufferingEnabled(boolean aFlag) {
        this.manager.setDoubleBufferingEnabled(aFlag);
    }

    public Rectangle getDirtyRegion(JComponent aComponent) {
        return this.manager.getDirtyRegion(aComponent);
    }

    public boolean isCompletelyDirty(JComponent aComponent) {
        return this.manager.isCompletelyDirty(aComponent);
    }

    public void markCompletelyClean(JComponent aComponent) {
        this.manager.markCompletelyClean(aComponent);
    }

    public void removeInvalidComponent(JComponent component) {
        this.manager.removeInvalidComponent(component);
    }

    public void validateInvalidComponents() {
        this.manager.validateInvalidComponents();
    }

    public Dimension getDoubleBufferMaximumSize() {
        return this.manager.getDoubleBufferMaximumSize();
    }

    public boolean isDoubleBufferingEnabled() {
        return this.manager.isDoubleBufferingEnabled();
    }

    public void paintDirtyRegions() {
        this.manager.paintDirtyRegions();
    }

    public String toString() {
        return "NapkinRepaintManager {" + this.manager.toString() + "}";
    }

    public boolean equals(Object obj) {
        return obj instanceof NapkinRepaintManager && this.manager.equals(((NapkinRepaintManager)obj).manager);
    }

    public int hashCode() {
        return NapkinRepaintManager.class.hashCode() ^ this.manager.hashCode();
    }
}

