/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.cgoban;

import com.gokgs.client.KCBundle;
import com.gokgs.client.swing.KgsPlaf;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.igoweb.cgoban.MainWindow;
import org.igoweb.go.swing.GamePanel;
import org.igoweb.go.swing.sgf.YoshikawaEstimator;
import org.igoweb.igoweb.Config;
import org.igoweb.igoweb.client.swing.GuiClient;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.MemoryMonitor;
import org.igoweb.util.swing.Defs;
import org.igoweb.util.swing.JnlpIo;
import org.igoweb.util.swing.MsgOut;
import org.igoweb.util.swing.Prefs;

public class CGoban
implements Runnable,
EventListener,
Thread.UncaughtExceptionHandler {
    private ArrayList<String> editFile = new ArrayList();
    private boolean connect = false;
    private static Locale origLocale = Locale.getDefault();
    private MainWindow mainWindow;

    public static void main(String[] args) {
        CGoban cgoban = new CGoban(args);
        try {
            Thread.setDefaultUncaughtExceptionHandler(cgoban);
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        GuiClient.internalError(e);
    }

    private CGoban(String[] args) {
        Preferences tmpPrefs;
        String localeWanted = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-locale")) continue;
            localeWanted = args[i + 1];
            this.setLocale(localeWanted);
        }
        if (localeWanted == null) {
            Defs.setBundle(new KCBundle("org.igoweb.cgoban.res.Res", Locale.getDefault(), false));
        }
        if ((tmpPrefs = JnlpIo.getPreferences()) == null) {
            Prefs.load(this.getClass());
        } else {
            Prefs.setImpl(tmpPrefs);
        }
        if (Config.get("prefsSubdir") != null) {
            Prefs.useSubdirectory(Config.get("prefsSubdir"));
        }
        if (Prefs.getString("n0&FI uj", "").equals(Config.get("webHost"))) {
            Prefs.putString("n0&FI uj", Config.get("defaultHost"));
        }
        Prefs.addListener("w49,rOM\"", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                CGoban.this.setLocale((String)event.getNewValue());
            }
        });
        if (localeWanted == null && (localeWanted = Prefs.getString("w49,rOM\"", null)) != null) {
            this.setLocale(localeWanted);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-edit") || args[i].equals("-open")) {
                this.editFile.add(args[++i]);
                continue;
            }
            if (args[i].equals("-connect")) {
                this.connect = true;
                continue;
            }
            if (args[i].equals("-locale")) {
                Prefs.putString("w49,rOM\"", args[++i]);
                continue;
            }
            if (args[i].equals("-config")) {
                ++i;
                continue;
            }
            if (args[i].equals("-memcheck")) {
                new MemoryMonitor(10000);
                continue;
            }
            if (args[i].charAt(0) != '-') {
                this.editFile.add(args[i]);
                continue;
            }
            try {
                UIManager.setLookAndFeel(new KgsPlaf());
            }
            catch (UnsupportedLookAndFeelException excep) {
                throw new RuntimeException(excep.toString());
            }
            UIManager.getLookAndFeelDefaults().put("ClassLoader", this.getClass().getClassLoader());
            new MsgOut(Defs.getString(-382651071), Defs.getString(-382651070), 1);
            return;
        }
        try {
            UIManager.setLookAndFeel(new KgsPlaf());
        }
        catch (UnsupportedLookAndFeelException excep) {
            throw new RuntimeException(excep.toString());
        }
        Defs.setSoundEnabled(Prefs.getBoolean("?x,`>/$bI_", true));
        UIManager.getLookAndFeelDefaults().put("ClassLoader", this.getClass().getClassLoader());
        if (JnlpIo.isAvailable()) {
            JnlpIo.installStartupListener(this);
        }
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void run() {
        GamePanel.estimator = new YoshikawaEstimator();
        this.mainWindow = new MainWindow();
        for (String fileName : this.editFile) {
            File file = new File(fileName);
            if (!file.isAbsolute()) {
                file = new File((String)System.getProperties().get("user.dir"), file.toString());
            }
            MainWindow.makeSgfGameWindow(file, null, null);
        }
        this.editFile = null;
        if (this.connect) {
            this.mainWindow.clientButtonPressed();
        }
    }

    private void setLocale(String localeName) {
        if (localeName == null) {
            this.setLocale((Locale)null);
        } else {
            int barLoc = localeName.indexOf("_");
            this.setLocale(barLoc >= 0 ? new Locale(localeName.substring(0, barLoc), localeName.substring(barLoc + 1)) : new Locale(localeName, null));
        }
    }

    private void setLocale(Locale locale) {
        if (locale == null) {
            locale = origLocale;
        }
        if (!Locale.getDefault().equals(locale)) {
            Locale.setDefault(locale);
        }
        Defs.setBundle(new KCBundle("org.igoweb.cgoban.res.Res", locale, false));
    }

    @Override
    public void handleEvent(Event event) {
        final String[] args = (String[])event.arg;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CGoban.this.newInstantiation(args);
            }
        });
    }

    private void newInstantiation(String[] args) {
        if (args.length == 2 && args[0].equals("-open")) {
            MainWindow.makeSgfGameWindow(new File(args[1]), null, null);
        } else {
            if (!this.mainWindow.isVisible()) {
                this.mainWindow = new MainWindow();
            }
            this.mainWindow.toFront();
        }
    }
}

