/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tinylaf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.metal.MetalSliderUI;
import net.sf.tinylaf.Theme;
import net.sf.tinylaf.util.ColorRoutines;

public class TinySliderUI
extends MetalSliderUI {
    private static final BasicStroke focusStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f, 1.0f}, 0.0f);
    private static final Dimension sliderVertSize = new Dimension(22, 11);
    private static final Dimension sliderHorzSize = new Dimension(11, 22);
    protected boolean isRollover = false;
    protected boolean wasRollover = false;
    protected boolean isDragging = false;
    protected BasicSliderUI.TrackListener trackListener;

    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new MyTrackListener();
    }

    protected Dimension getThumbSize() {
        if (this.slider.getOrientation() == 1) {
            return sliderVertSize;
        }
        return sliderHorzSize;
    }

    protected int getTrackWidth() {
        return 4;
    }

    public void paintThumb(Graphics g) {
        if (!this.slider.isEnabled()) {
            g.setColor(Theme.sliderThumbDisabledColor.getColor());
            this.drawXpThumbDisabled(g);
            return;
        }
        if (this.isDragging) {
            g.setColor(Theme.sliderThumbPressedColor.getColor());
        } else if (this.isRollover && Theme.sliderRolloverEnabled.getValue()) {
            g.setColor(Theme.sliderThumbColor.getColor());
        } else {
            g.setColor(Theme.sliderThumbColor.getColor());
        }
        this.drawXpThumb(g);
    }

    private void drawXpThumb(Graphics g) {
        int x1 = this.thumbRect.x;
        int y1 = this.thumbRect.y;
        int x2 = x1 + this.thumbRect.width - 1;
        int y2 = y1 + this.thumbRect.height - 1;
        Color c = g.getColor();
        if (this.slider.getPaintTicks()) {
            if (this.slider.getOrientation() == 0) {
                g.fillRect(x1 + 1, y1 + 4, this.thumbRect.width - 4, this.thumbRect.height - 8);
                g.drawLine(x1 + 5, y2 - 3, x1 + 5, y2 - 3);
                g.setColor(ColorRoutines.darken(c, 10));
                g.drawLine(x2 - 2, y1 + 4, x2 - 2, y2 - 6);
                g.setColor(ColorRoutines.darken(c, 20));
                g.drawLine(x2 - 1, y1 + 4, x2 - 1, y2 - 7);
                ColorUIResource bc = Theme.sliderBorderColor.getColor();
                g.setColor(bc);
                g.drawLine(x1 + 1, y1, x2 - 1, y1);
                g.drawLine(x1, y1 + 1, x1, y2 - 5);
                g.drawLine(x1 + 1, y2 - 4, x1 + 1, y2 - 4);
                g.drawLine(x1 + 2, y2 - 3, x1 + 2, y2 - 3);
                g.drawLine(x1 + 3, y2 - 2, x1 + 3, y2 - 2);
                g.drawLine(x1 + 4, y2 - 1, x1 + 4, y2 - 1);
                g.setColor(Theme.sliderDarkColor.getColor());
                g.drawLine(x2, y1 + 1, x2, y2 - 5);
                g.drawLine(x2 - 1, y2 - 4, x2 - 1, y2 - 4);
                g.drawLine(x2 - 2, y2 - 3, x2 - 2, y2 - 3);
                g.drawLine(x2 - 3, y2 - 2, x2 - 3, y2 - 2);
                g.drawLine(x2 - 4, y2 - 1, x2 - 4, y2 - 1);
                g.drawLine(x2 - 5, y2, x2 - 5, y2);
                ColorUIResource col = null;
                col = !this.isDragging && this.isRollover && Theme.sliderRolloverEnabled.getValue() ? Theme.sliderThumbRolloverColor.getColor() : Theme.sliderLightColor.getColor();
                Color c2 = ColorRoutines.getAdjustedColor(col, 67, 39);
                g.setColor(c2);
                g.drawLine(x1 + 1, y1 + 1, x2 - 1, y1 + 1);
                g.drawLine(x1 + 1, y2 - 6, x1 + 1, y2 - 6);
                g.drawLine(x1 + 2, y2 - 5, x1 + 2, y2 - 5);
                g.drawLine(x1 + 3, y2 - 4, x1 + 3, y2 - 4);
                g.setColor(ColorRoutines.getAverage(bc, c2));
                g.drawLine(x1 + 1, y2 - 5, x1 + 1, y2 - 5);
                g.drawLine(x1 + 2, y2 - 4, x1 + 2, y2 - 4);
                g.drawLine(x1 + 3, y2 - 3, x1 + 3, y2 - 3);
                Color c3 = ColorRoutines.getAverage(col, c2);
                g.setColor(c3);
                g.drawLine(x1 + 1, y1 + 2, x2 - 1, y1 + 2);
                g.drawLine(x1 + 4, y2 - 3, x1 + 4, y2 - 3);
                g.drawLine(x1 + 5, y2 - 2, x1 + 5, y2 - 2);
                g.drawLine(x1 + 6, y2 - 3, x1 + 6, y2 - 3);
                g.setColor(ColorRoutines.getAverage(bc, c3));
                g.drawLine(x1 + 4, y2 - 2, x1 + 4, y2 - 2);
                g.drawLine(x1 + 5, y2 - 1, x1 + 5, y2 - 1);
                g.drawLine(x1 + 6, y2 - 2, x1 + 6, y2 - 2);
                g.setColor(col);
                g.drawLine(x1 + 1, y1 + 3, x2 - 1, y1 + 3);
                g.drawLine(x1 + 9, y2 - 6, x1 + 9, y2 - 6);
                g.drawLine(x1 + 8, y2 - 5, x1 + 8, y2 - 5);
                g.drawLine(x1 + 7, y2 - 4, x1 + 7, y2 - 4);
                g.setColor(ColorRoutines.getAverage(bc, col));
                g.drawLine(x1 + 9, y2 - 5, x1 + 9, y2 - 5);
                g.drawLine(x1 + 8, y2 - 4, x1 + 8, y2 - 4);
                g.drawLine(x1 + 7, y2 - 3, x1 + 7, y2 - 3);
            } else {
                g.fillRect(x1 + 4, y1 + 1, this.thumbRect.width - 8, this.thumbRect.height - 4);
                g.drawLine(x2 - 3, y1 + 5, x2 - 3, y1 + 5);
                g.setColor(ColorRoutines.darken(c, 10));
                g.drawLine(x1 + 4, y2 - 2, x2 - 6, y2 - 2);
                g.setColor(ColorRoutines.darken(c, 20));
                g.drawLine(x1 + 4, y2 - 1, x2 - 7, y2 - 1);
                ColorUIResource bc = Theme.sliderBorderColor.getColor();
                g.setColor(bc);
                g.drawLine(x1, y1 + 1, x1, y2 - 1);
                g.drawLine(x1 + 1, y1, x2 - 5, y1);
                g.drawLine(x2 - 4, y1 + 1, x2 - 4, y1 + 1);
                g.drawLine(x2 - 3, y1 + 2, x2 - 3, y1 + 2);
                g.drawLine(x2 - 2, y1 + 3, x2 - 2, y1 + 3);
                g.drawLine(x2 - 1, y1 + 4, x2 - 1, y1 + 4);
                g.setColor(Theme.sliderDarkColor.getColor());
                g.drawLine(x1 + 1, y2, x2 - 5, y2);
                g.drawLine(x2 - 4, y2 - 1, x2 - 4, y2 - 1);
                g.drawLine(x2 - 3, y2 - 2, x2 - 3, y2 - 2);
                g.drawLine(x2 - 2, y2 - 3, x2 - 2, y2 - 3);
                g.drawLine(x2 - 1, y2 - 4, x2 - 1, y2 - 4);
                g.drawLine(x2, y2 - 5, x2, y2 - 5);
                ColorUIResource col = null;
                col = !this.isDragging && this.isRollover && Theme.sliderRolloverEnabled.getValue() ? Theme.sliderThumbRolloverColor.getColor() : Theme.sliderLightColor.getColor();
                Color c2 = ColorRoutines.getAdjustedColor(col, 67, 39);
                g.setColor(c2);
                g.drawLine(x1 + 1, y1 + 1, x1 + 1, y2 - 1);
                g.drawLine(x2 - 6, y1 + 1, x2 - 6, y1 + 1);
                g.drawLine(x2 - 5, y1 + 2, x2 - 5, y1 + 2);
                g.drawLine(x2 - 4, y1 + 3, x2 - 4, y1 + 3);
                g.setColor(ColorRoutines.getAverage(bc, c2));
                g.drawLine(x2 - 5, y1 + 1, x2 - 5, y1 + 1);
                g.drawLine(x2 - 4, y1 + 2, x2 - 4, y1 + 2);
                g.drawLine(x2 - 3, y1 + 3, x2 - 3, y1 + 3);
                Color c3 = ColorRoutines.getAverage(col, c2);
                g.setColor(c3);
                g.drawLine(x1 + 2, y1 + 1, x1 + 2, y2 - 1);
                g.drawLine(x2 - 3, y1 + 4, x2 - 3, y1 + 4);
                g.drawLine(x2 - 2, y1 + 5, x2 - 2, y1 + 5);
                g.drawLine(x2 - 3, y1 + 6, x2 - 3, y1 + 6);
                g.setColor(ColorRoutines.getAverage(bc, c3));
                g.drawLine(x2 - 2, y1 + 4, x2 - 2, y1 + 4);
                g.drawLine(x2 - 1, y1 + 5, x2 - 1, y1 + 5);
                g.drawLine(x2 - 2, y1 + 6, x2 - 2, y1 + 6);
                g.setColor(col);
                g.drawLine(x1 + 3, y1 + 1, x1 + 3, y2 - 1);
                g.drawLine(x2 - 6, y1 + 9, x2 - 6, y1 + 9);
                g.drawLine(x2 - 5, y1 + 8, x2 - 5, y1 + 8);
                g.drawLine(x2 - 4, y1 + 7, x2 - 4, y1 + 7);
                g.setColor(ColorRoutines.getAverage(bc, col));
                g.drawLine(x2 - 5, y1 + 9, x2 - 5, y1 + 9);
                g.drawLine(x2 - 4, y1 + 8, x2 - 4, y1 + 8);
                g.drawLine(x2 - 3, y1 + 7, x2 - 3, y1 + 7);
            }
        } else if (this.slider.getOrientation() == 0) {
            g.fillRect(x1 + 1, y1 + 1, this.thumbRect.width - 4, this.thumbRect.height - 4);
            g.setColor(ColorRoutines.darken(c, 10));
            g.drawLine(x2 - 2, y1 + 3, x2 - 2, y2 - 3);
            g.setColor(ColorRoutines.darken(c, 20));
            g.drawLine(x2 - 1, y1 + 3, x2 - 1, y2 - 3);
            g.setColor(Theme.sliderBorderColor.getColor());
            g.drawLine(x1, y1 + 1, x1, y2 - 1);
            g.drawLine(x1 + 1, y1, x2 - 1, y1);
            g.setColor(Theme.sliderDarkColor.getColor());
            g.drawLine(x1 + 1, y2, x2 - 1, y2);
            g.drawLine(x2, y1 + 1, x2, y2 - 1);
            ColorUIResource col = null;
            col = !this.isDragging && this.isRollover && Theme.sliderRolloverEnabled.getValue() ? Theme.sliderThumbRolloverColor.getColor() : Theme.sliderLightColor.getColor();
            Color c2 = ColorRoutines.getAdjustedColor(col, 67, 39);
            g.setColor(c2);
            g.drawLine(x1 + 1, y1 + 1, x2 - 1, y1 + 1);
            g.setColor(ColorRoutines.getAverage(col, c2));
            g.drawLine(x1 + 1, y1 + 2, x2 - 1, y1 + 2);
            g.drawLine(x1 + 1, y2 - 2, x2 - 1, y2 - 2);
            g.setColor(col);
            g.drawLine(x1 + 1, y2 - 1, x2 - 1, y2 - 1);
        } else {
            g.fillRect(x1 + 1, y1 + 1, this.thumbRect.width - 4, this.thumbRect.height - 4);
            g.setColor(ColorRoutines.darken(c, 10));
            g.drawLine(x1 + 3, y2 - 2, x2 - 3, y2 - 2);
            g.setColor(ColorRoutines.darken(c, 20));
            g.drawLine(x1 + 3, y2 - 1, x2 - 3, y2 - 1);
            g.setColor(Theme.sliderBorderColor.getColor());
            g.drawLine(x1 + 1, y1, x2 - 1, y1);
            g.drawLine(x1, y1 + 1, x1, y2 - 1);
            g.setColor(Theme.sliderDarkColor.getColor());
            g.drawLine(x2, y1 + 1, x2, y2 - 1);
            g.drawLine(x1 + 1, y2, x2 - 1, y2);
            ColorUIResource col = null;
            col = !this.isDragging && this.isRollover && Theme.sliderRolloverEnabled.getValue() ? Theme.sliderThumbRolloverColor.getColor() : Theme.sliderLightColor.getColor();
            Color c2 = ColorRoutines.getAdjustedColor(col, 67, 39);
            g.setColor(c2);
            g.drawLine(x1 + 1, y1 + 1, x1 + 1, y2 - 1);
            g.setColor(ColorRoutines.getAverage(col, c2));
            g.drawLine(x1 + 2, y1 + 1, x1 + 2, y2 - 1);
            g.drawLine(x2 - 2, y1 + 1, x2 - 2, y2 - 1);
            g.setColor(col);
            g.drawLine(x2 - 1, y1 + 1, x2 - 1, y2 - 1);
        }
    }

    private void drawXpThumbDisabled(Graphics g) {
        int x1 = this.thumbRect.x;
        int y1 = this.thumbRect.y;
        int x2 = x1 + this.thumbRect.width - 1;
        int y2 = y1 + this.thumbRect.height - 1;
        Color c = g.getColor();
        Color c1 = ColorRoutines.getAdjustedColor(c, 0, -3);
        Color c2 = ColorRoutines.getAdjustedColor(c, 0, -7);
        ColorUIResource bc = Theme.sliderBorderDisabledColor.getColor();
        Color bc1 = ColorRoutines.getAdjustedColor(bc, -19, -1);
        Color bc2 = ColorRoutines.getAdjustedColor(bc, 0, -3);
        Color bc3 = ColorRoutines.getAdjustedColor(bc, 0, -10);
        Color bc4 = ColorRoutines.getAdjustedColor(bc, 3, -12);
        Color bc5 = ColorRoutines.getAdjustedColor(bc, 0, -13);
        if (this.slider.getPaintTicks()) {
            if (this.slider.getOrientation() == 0) {
                g.fillRect(x1 + 1, y1 + 3, 7, 13);
                g.drawLine(x1 + 2, y2 - 5, x1 + 6, y2 - 5);
                g.drawLine(x1 + 3, y2 - 4, x1 + 5, y2 - 4);
                g.drawLine(x1 + 4, y2 - 3, x1 + 4, y2 - 3);
                g.setColor(c1);
                g.drawLine(x2 - 2, y1 + 3, x2 - 2, y2 - 3);
                g.drawLine(x2 - 3, y2 - 5, x2 - 3, y2 - 5);
                g.drawLine(x2 - 4, y2 - 4, x2 - 4, y2 - 4);
                g.drawLine(x2 - 5, y2 - 3, x2 - 5, y2 - 3);
                g.drawLine(x2 - 5, y2 - 2, x2 - 5, y2 - 2);
                g.setColor(c2);
                g.drawLine(x2 - 1, y1 + 3, x2 - 1, y2 - 6);
                g.drawLine(x2 - 2, y2 - 5, x2 - 2, y2 - 5);
                g.drawLine(x2 - 3, y2 - 4, x2 - 3, y2 - 4);
                g.drawLine(x2 - 4, y2 - 3, x2 - 4, y2 - 3);
                g.setColor(bc);
                g.drawLine(x1 + 1, y1, x2 - 1, y1);
                g.drawLine(x1, y1 + 1, x1, y2 - 5);
                g.setColor(bc1);
                g.drawLine(x1 + 1, y1 + 1, x2, y1 + 1);
                g.setColor(bc2);
                g.drawLine(x1 + 1, y1 + 2, x2, y1 + 2);
                g.drawLine(x1 + 1, y2 - 4, x1 + 1, y2 - 4);
                g.drawLine(x1 + 2, y2 - 3, x1 + 2, y2 - 3);
                g.drawLine(x1 + 3, y2 - 2, x1 + 3, y2 - 2);
                g.drawLine(x1 + 4, y2 - 1, x1 + 4, y2 - 1);
                g.setColor(bc3);
                g.drawLine(x1 + 1, y2 - 5, x1 + 1, y2 - 5);
                g.drawLine(x1 + 2, y2 - 4, x1 + 2, y2 - 4);
                g.drawLine(x1 + 3, y2 - 3, x1 + 3, y2 - 3);
                g.drawLine(x1 + 4, y2 - 2, x1 + 4, y2 - 2);
                g.drawLine(x1 + 5, y2 - 1, x1 + 5, y2);
                g.setColor(bc4);
                g.drawLine(x2, y1 + 3, x2, y2 - 5);
                g.drawLine(x2 - 1, y2 - 4, x2 - 1, y2 - 4);
                g.drawLine(x2 - 2, y2 - 3, x2 - 2, y2 - 3);
                g.drawLine(x2 - 3, y2 - 2, x2 - 3, y2 - 2);
                g.drawLine(x2 - 4, y2 - 1, x2 - 4, y2 - 1);
                g.drawLine(x2 - 5, y2, x2 - 5, y2);
                g.setColor(bc5);
                g.drawLine(x2 - 1, y2 - 5, x2 - 1, y2 - 5);
                g.drawLine(x2 - 2, y2 - 4, x2 - 2, y2 - 4);
                g.drawLine(x2 - 3, y2 - 3, x2 - 3, y2 - 3);
                g.drawLine(x2 - 4, y2 - 2, x2 - 4, y2 - 2);
            } else {
                g.fillRect(x1 + 3, y1 + 1, 13, 7);
                g.drawLine(x2 - 5, y1 + 2, x2 - 5, y1 + 6);
                g.drawLine(x2 - 4, y1 + 3, x2 - 4, y1 + 5);
                g.drawLine(x2 - 3, y1 + 4, x2 - 3, y1 + 4);
                g.setColor(c1);
                g.drawLine(x1 + 3, y2 - 2, x2 - 6, y2 - 2);
                g.drawLine(x2 - 5, y2 - 3, x2 - 5, y2 - 3);
                g.drawLine(x2 - 4, y2 - 4, x2 - 4, y2 - 4);
                g.drawLine(x2 - 3, y2 - 5, x2 - 3, y2 - 5);
                g.setColor(c2);
                g.drawLine(x1 + 3, y2 - 1, x2 - 6, y2 - 1);
                g.drawLine(x2 - 5, y2 - 2, x2 - 5, y2 - 2);
                g.drawLine(x2 - 4, y2 - 3, x2 - 4, y2 - 3);
                g.drawLine(x2 - 3, y2 - 4, x2 - 3, y2 - 4);
                g.drawLine(x2 - 2, y2 - 5, x2 - 2, y2 - 5);
                g.setColor(bc);
                g.drawLine(x1, y1 + 1, x1, y2 - 1);
                g.drawLine(x1 + 1, y1, x2 - 5, y1);
                g.setColor(bc1);
                g.drawLine(x1 + 1, y1, x1 + 1, y2);
                g.setColor(bc2);
                g.drawLine(x1 + 2, y1, x1 + 2, y2);
                g.drawLine(x2 - 5, y1 + 1, x2 - 4, y1 + 1);
                g.drawLine(x2 - 4, y1 + 2, x2 - 3, y1 + 2);
                g.drawLine(x2 - 3, y1 + 3, x2 - 2, y1 + 3);
                g.drawLine(x2 - 2, y1 + 4, x2 - 1, y1 + 4);
                g.setColor(bc3);
                g.drawLine(x2 - 1, y1 + 5, x2, y1 + 5);
                g.setColor(bc4);
                g.drawLine(x1 + 3, y2, x2 - 5, y2);
                g.setColor(bc5);
                g.drawLine(x2 - 5, y2 - 1, x2 - 4, y2 - 1);
                g.drawLine(x2 - 4, y2 - 2, x2 - 3, y2 - 2);
                g.drawLine(x2 - 3, y2 - 3, x2 - 2, y2 - 3);
                g.drawLine(x2 - 2, y2 - 4, x2 - 1, y2 - 4);
            }
        } else if (this.slider.getOrientation() == 0) {
            g.fillRect(x1 + 1, y1 + 3, 7, 16);
            g.setColor(c1);
            g.drawLine(x2 - 2, y1 + 3, x2 - 2, y2 - 3);
            g.setColor(c2);
            g.drawLine(x2 - 1, y1 + 3, x2 - 1, y2 - 3);
            g.setColor(bc);
            g.drawLine(x1, y1 + 1, x1, y2 - 3);
            g.drawLine(x1 + 1, y1, x2 - 1, y1);
            g.setColor(bc1);
            g.drawLine(x1, y1 + 1, x2, y1 + 1);
            g.setColor(bc2);
            g.drawLine(x1, y1 + 2, x2, y1 + 2);
            g.setColor(bc3);
            g.drawLine(x1, y2 - 2, x2, y2 - 2);
            g.setColor(bc5);
            g.drawLine(x1, y2 - 1, x2, y2 - 1);
            g.setColor(bc4);
            g.drawLine(x1 + 1, y2, x2 - 1, y2);
            g.drawLine(x2, y1 + 3, x2, y2 - 3);
        } else {
            g.fillRect(x1 + 3, y1 + 1, this.thumbRect.width - 6, this.thumbRect.height - 4);
            g.setColor(c1);
            g.drawLine(x1 + 3, y2 - 2, x2 - 3, y2 - 2);
            g.setColor(c2);
            g.drawLine(x1 + 3, y2 - 1, x2 - 3, y2 - 1);
            g.setColor(bc);
            g.drawLine(x1, y1 + 1, x1, y2 - 1);
            g.drawLine(x1 + 1, y1, x2 - 1, y1);
            g.setColor(bc1);
            g.drawLine(x1 + 1, y1, x1 + 1, y2);
            g.setColor(bc2);
            g.drawLine(x1 + 2, y1, x1 + 2, y2);
            g.setColor(bc3);
            g.drawLine(x2 - 2, y1, x2 - 2, y2);
            g.setColor(bc5);
            g.drawLine(x2 - 1, y1, x2 - 1, y2);
            g.setColor(bc4);
            g.drawLine(x2, y1 + 1, x2, y2 - 1);
            g.drawLine(x1 + 3, y2, x2 - 3, y2);
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new TinySliderUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    protected int getThumbOverhang() {
        if (this.slider.getOrientation() == 1) {
            return (int)(this.getThumbSize().getWidth() - (double)this.getTrackWidth()) / 2;
        }
        return (int)(this.getThumbSize().getHeight() - (double)this.getTrackWidth()) / 2;
    }

    public void paintTrack(Graphics g) {
        this.drawXpTrack(g);
    }

    public void paintFocus(Graphics g) {
        if (!Theme.sliderFocusEnabled.getValue()) {
            return;
        }
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Stroke memStroke = g2d.getStroke();
        g2d.setStroke(focusStroke);
        g2d.setColor(Theme.sliderFocusColor.getColor());
        g2d.drawRect(0, 0, this.slider.getWidth() - 1, this.slider.getHeight() - 1);
        g2d.setStroke(memStroke);
    }

    private void drawXpTrack(Graphics g) {
        int x1 = this.trackRect.x;
        int x2 = x1 + this.trackRect.width;
        int y1 = this.trackRect.y;
        int y2 = y1 + this.trackRect.height;
        if (this.slider.getOrientation() == 0) {
            int y = y1 + (this.trackRect.height - 4) / 2;
            g.setColor(Theme.sliderTrackColor.getColor());
            g.drawLine(x1 + 1, y + 2, x2 - 2, y + 2);
            g.setColor(Theme.sliderTrackDarkColor.getColor());
            g.drawLine(x1 + 1, y + 1, x2 - 2, y + 1);
            g.drawLine(x2 - 1, y + 1, x2 - 1, y + 2);
            g.setColor(ColorRoutines.darken(Theme.sliderTrackDarkColor.getColor(), 10));
            g.drawLine(x1, y, x1, y);
            g.drawLine(x1, y + 3, x1, y + 3);
            g.setColor(Theme.sliderTrackLightColor.getColor());
            g.drawLine(x1 + 1, y + 3, x2 - 1, y + 3);
            g.drawLine(x2, y + 1, x2, y + 3);
            g.setColor(Theme.sliderTrackBorderColor.getColor());
            g.drawLine(x1 + 1, y, x2, y);
            g.setColor(ColorRoutines.lighten(Theme.sliderTrackBorderColor.getColor(), 20));
            g.drawLine(x1, y + 1, x1, y + 2);
        } else {
            int x = x1 + (this.trackRect.width - 4) / 2;
            g.setColor(Theme.sliderTrackBorderColor.getColor());
            g.drawLine(x, y1 + 1, x, y2 - 1);
            g.setColor(ColorRoutines.lighten(Theme.sliderTrackBorderColor.getColor(), 20));
            g.drawLine(x + 1, y1, x + 1, y1);
            g.drawLine(x + 1, y2, x + 1, y2);
            g.setColor(Theme.sliderTrackDarkColor.getColor());
            g.drawLine(x + 1, y1 + 1, x + 1, y2 - 1);
            g.setColor(ColorRoutines.darken(Theme.sliderTrackDarkColor.getColor(), 10));
            g.drawLine(x, y1, x, y1);
            g.drawLine(x, y2, x, y2);
            g.setColor(Theme.sliderTrackLightColor.getColor());
            g.drawLine(x + 3, y1, x + 3, y2);
            g.drawLine(x + 2, y1, x + 2, y1);
            g.drawLine(x + 2, y2, x + 2, y2);
            g.setColor(Theme.sliderTrackColor.getColor());
            g.drawLine(x + 2, y1 + 1, x + 2, y2 - 1);
        }
    }

    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.setColor(this.slider.isEnabled() ? Theme.sliderTickColor.getColor() : Theme.sliderTickDisabledColor.getColor());
        g.drawLine(x, 0, x, tickBounds.height / 2 - 1);
    }

    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.setColor(this.slider.isEnabled() ? Theme.sliderTickColor.getColor() : Theme.sliderTickDisabledColor.getColor());
        g.drawLine(x, 0, x, tickBounds.height - 2);
    }

    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.setColor(this.slider.isEnabled() ? Theme.sliderTickColor.getColor() : Theme.sliderTickDisabledColor.getColor());
        g.drawLine(0, y, tickBounds.width / 2 - 1, y);
    }

    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.setColor(this.slider.isEnabled() ? Theme.sliderTickColor.getColor() : Theme.sliderTickDisabledColor.getColor());
        g.drawLine(0, y, tickBounds.width - 2, y);
    }

    class MyTrackListener
    extends BasicSliderUI.TrackListener {
        MyTrackListener() {
            super(TinySliderUI.this);
        }

        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            TinySliderUI.this.isDragging = false;
            TinySliderUI.this.slider.repaint();
        }

        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (TinySliderUI.this.thumbRect.contains(e.getX(), e.getY())) {
                TinySliderUI.this.isDragging = true;
            }
            TinySliderUI.this.slider.repaint();
        }

        public void mouseEntered(MouseEvent e) {
            TinySliderUI.this.isRollover = false;
            TinySliderUI.this.wasRollover = false;
            if (TinySliderUI.this.thumbRect.contains(e.getX(), e.getY())) {
                TinySliderUI.this.isRollover = true;
            }
        }

        public void mouseExited(MouseEvent e) {
            TinySliderUI.this.isRollover = false;
            if (TinySliderUI.this.isRollover != TinySliderUI.this.wasRollover) {
                TinySliderUI.this.slider.repaint();
                TinySliderUI.this.wasRollover = TinySliderUI.this.isRollover;
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (TinySliderUI.this.thumbRect.contains(e.getX(), e.getY())) {
                TinySliderUI.this.isRollover = true;
            }
            super.mouseDragged(e);
        }

        public void mouseMoved(MouseEvent e) {
            if (TinySliderUI.this.thumbRect.contains(e.getX(), e.getY())) {
                TinySliderUI.this.isRollover = true;
                if (TinySliderUI.this.isRollover != TinySliderUI.this.wasRollover) {
                    TinySliderUI.this.slider.repaint();
                    TinySliderUI.this.wasRollover = TinySliderUI.this.isRollover;
                }
            } else {
                TinySliderUI.this.isRollover = false;
                if (TinySliderUI.this.isRollover != TinySliderUI.this.wasRollover) {
                    TinySliderUI.this.slider.repaint();
                    TinySliderUI.this.wasRollover = TinySliderUI.this.isRollover;
                }
            }
        }
    }
}

