/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.SwingConstants;
import javax.swing.border.Border;

public class BevelDividerBorder
implements Border,
SwingConstants {
    private int location;
    private int slack;
    private Color light;
    private Color dark;
    private Insets insets;

    public BevelDividerBorder(int location) {
        this(location, 0);
    }

    public BevelDividerBorder(int location, int slack) {
        this(location, slack, null, null);
    }

    public BevelDividerBorder(int location, int slack, Color light, Color dark) {
        if (location < 1 || location > 4) {
            location = 3;
        }
        this.location = location;
        this.slack = slack;
        this.light = light;
        this.dark = dark;
        this.insets = new Insets(0, 0, 0, 0);
        switch (location) {
            case 1: {
                this.insets.top = 2;
                break;
            }
            case 2: {
                this.insets.left = 2;
                break;
            }
            case 3: {
                this.insets.bottom = 2;
                break;
            }
            case 4: {
                this.insets.right = 2;
            }
        }
    }

    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int yinc;
        int xinc;
        int y2;
        int x2;
        int y1;
        int x1;
        if (width <= 2 * this.slack) {
            return;
        }
        switch (this.location) {
            case 1: {
                x1 = x + this.slack;
                y1 = y;
                x2 = x + width - this.slack - 2;
                y2 = y;
                xinc = 0;
                yinc = 1;
                break;
            }
            case 2: {
                x1 = x;
                y1 = y + this.slack;
                x2 = x;
                y2 = y + height - this.slack - 2;
                xinc = 1;
                yinc = 0;
                break;
            }
            case 3: {
                x1 = x + this.slack;
                y1 = y + height - 2;
                x2 = x + width - this.slack - 2;
                y2 = y1;
                xinc = 0;
                yinc = 1;
                break;
            }
            default: {
                x1 = x + width - 2;
                y1 = y + this.slack;
                x2 = x1;
                y2 = y + height - this.slack - 2;
                xinc = 1;
                yinc = 0;
            }
        }
        g.setColor(this.dark == null ? c.getBackground().darker() : this.dark);
        g.drawLine(x1, y1, x2, y2);
        g.setColor(this.light == null ? c.getBackground().brighter() : this.light);
        g.drawLine(x1 + xinc, y1 + yinc, x2 + xinc, y2 + yinc);
    }
}

