/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.parser.kernel.completions;

import net.sourceforge.squirrel_sql.client.session.parser.kernel.ParserLogger;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.SQLCompletion;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.SQLSchema;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.completions.SQLStatement;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.completions.SQLStatementContext;

public class SQLColumn
extends SQLCompletion {
    private String name;
    private String qualifier;
    private boolean isRepeatable = true;
    private SQLStatementContext parent;
    private int namePos = -1;

    public SQLColumn(SQLStatementContext parent, int start) {
        super(start);
        this.parent = parent;
    }

    public SQLColumn(SQLStatementContext parent, int start, int end) {
        super(start);
        this.parent = parent;
        this.setEndPosition(end);
    }

    public SQLColumn(SQLStatementContext parent) {
        this.parent = parent;
    }

    public void setQualifier(String alias, int pos) {
        this.qualifier = alias;
        this.namePos = pos + alias.length() + 1;
        this.setEndPosition(this.namePos);
        ParserLogger.log("setAlias: s=" + this.startPosition + " e=" + this.endPosition);
    }

    public void setQualifier(String alias) {
        this.qualifier = alias;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setColumn(String name, int pos) {
        this.name = name;
        this.namePos = pos;
        this.setEndPosition(pos + name.length() - 1);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasTable(int position) {
        return this.qualifier == null && this.parent.getStatement().getTable() != null || this.qualifier != null && position >= this.namePos && position <= this.endPosition && this.parent.getStatement().getTableForAlias(this.qualifier) != null;
    }

    public SQLStatement getStatement() {
        return this.parent.getStatement();
    }

    public String getText() {
        String text;
        String string = text = this.qualifier != null ? this.qualifier + "." + this.name : this.name;
        if (this.hasTextPosition()) {
            int oldDataPos = this.endPosition - this.startPosition;
            return text.substring(oldDataPos, text.length());
        }
        return text;
    }

    @Override
    protected boolean isConcrete() {
        return this.name != null;
    }

    @Override
    public String getText(int position) {
        return this.getText(position, this.name);
    }

    @Override
    public String getText(int position, String option) {
        if (position == this.endPosition) {
            return option;
        }
        if (this.mustReplace(position) || this.isOther(position)) {
            return this.qualifier != null ? this.qualifier + "." + option : option;
        }
        String text = this.qualifier != null ? this.qualifier + "." + option : option;
        int oldDataPos = this.endPosition - position;
        return text.substring(oldDataPos, text.length());
    }

    private boolean isOther(int position) {
        return this.endPosition == 99999 || position < this.startPosition || position > this.endPosition;
    }

    public String[] getCompletions(int position) {
        SQLSchema.Table table = null;
        if (this.qualifier != null) {
            table = this.getStatement().getTableForAlias(this.qualifier);
            if (table == null) {
                table = this.getStatement().getTable(null, null, this.qualifier);
            }
        } else {
            table = this.getStatement().getTable();
        }
        if (table != null) {
            String col = null;
            if (this.name != null && position > this.namePos) {
                col = position <= this.endPosition ? this.name.substring(0, position - this.namePos) : this.name;
            }
            String[] result = table.getColumns(col);
            return col != null && result.length == 1 && result[0].length() == col.length() ? EMPTY_RESULT : result;
        }
        return EMPTY_RESULT;
    }

    public void setRepeatable(boolean repeatable) {
        this.isRepeatable = repeatable;
    }

    @Override
    public boolean isRepeatable() {
        return this.isRepeatable;
    }

    @Override
    public boolean mustReplace(int position) {
        return this.name != null && position >= this.startPosition && position <= this.endPosition;
    }
}

