/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.plugins.conflict.ConflictManager;

public class IvyNodeEviction {
    private IvyNode node;
    private Map selectedDeps = new HashMap();
    private Map pendingConflicts = new HashMap();
    private Map evictedDeps = new HashMap();
    private Map evictedRevs = new HashMap();
    private Map evicted = new HashMap();

    public IvyNodeEviction(IvyNode ivyNode) {
        if (ivyNode == null) {
            throw new NullPointerException("node must not be null");
        }
        this.node = ivyNode;
    }

    public Set getResolvedNodes(ModuleId moduleId, String string) {
        Collection collection = (Collection)this.selectedDeps.get(new ModuleIdConf(moduleId, string));
        HashSet<IvyNode> hashSet = new HashSet<IvyNode>();
        if (collection != null) {
            for (IvyNode ivyNode : collection) {
                hashSet.add(ivyNode.getRealNode());
            }
        }
        return hashSet;
    }

    public Collection getResolvedRevisions(ModuleId moduleId, String string) {
        Collection collection = (Collection)this.selectedDeps.get(new ModuleIdConf(moduleId, string));
        if (collection == null) {
            return new HashSet();
        }
        HashSet<ModuleRevisionId> hashSet = new HashSet<ModuleRevisionId>();
        for (IvyNode ivyNode : collection) {
            ModuleRevisionId moduleRevisionId = ivyNode.getResolvedId();
            hashSet.add(ivyNode.getId());
            hashSet.add(moduleRevisionId);
            if (moduleRevisionId.getExtraAttributes().isEmpty()) continue;
            hashSet.add(ModuleRevisionId.newInstance(moduleRevisionId.getOrganisation(), moduleRevisionId.getName(), moduleRevisionId.getBranch(), moduleRevisionId.getRevision()));
        }
        return hashSet;
    }

    public void setResolvedNodes(ModuleId moduleId, String string, Collection collection) {
        ModuleIdConf moduleIdConf = new ModuleIdConf(moduleId, string);
        this.selectedDeps.put(moduleIdConf, new HashSet(collection));
    }

    public Collection getEvictedNodes(ModuleId moduleId, String string) {
        Collection collection = (Collection)this.evictedDeps.get(new ModuleIdConf(moduleId, string));
        HashSet<IvyNode> hashSet = new HashSet<IvyNode>();
        if (collection != null) {
            for (IvyNode ivyNode : collection) {
                hashSet.add(ivyNode.getRealNode());
            }
        }
        return hashSet;
    }

    public Collection getEvictedRevisions(ModuleId moduleId, String string) {
        Collection collection = (Collection)this.evictedRevs.get(new ModuleIdConf(moduleId, string));
        if (collection == null) {
            return new HashSet();
        }
        return new HashSet(collection);
    }

    public void setEvictedNodes(ModuleId moduleId, String string, Collection collection) {
        ModuleIdConf moduleIdConf = new ModuleIdConf(moduleId, string);
        this.evictedDeps.put(moduleIdConf, new HashSet(collection));
        HashSet<ModuleRevisionId> hashSet = new HashSet<ModuleRevisionId>();
        for (IvyNode ivyNode : collection) {
            hashSet.add(ivyNode.getId());
            hashSet.add(ivyNode.getResolvedId());
        }
        this.evictedRevs.put(moduleIdConf, hashSet);
    }

    public boolean isEvicted(String string) {
        ModuleId moduleId;
        this.cleanEvicted();
        if (this.node.isRoot()) {
            return false;
        }
        EvictionData evictionData = this.getEvictedData(string);
        if (evictionData == null) {
            return false;
        }
        IvyNode ivyNode = this.node.getRoot();
        Collection collection = ivyNode.getResolvedRevisions(moduleId = this.node.getId().getModuleId(), string);
        return !collection.contains(this.node.getResolvedId()) || evictionData.isTransitivelyEvicted();
    }

    public boolean isCompletelyEvicted() {
        this.cleanEvicted();
        if (this.node.isRoot()) {
            return false;
        }
        String[] stringArray = this.node.getRootModuleConfigurations();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.isEvicted(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    private void cleanEvicted() {
        Iterator iterator = this.evicted.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            EvictionData evictionData = (EvictionData)this.evicted.get(string);
            Collection collection = evictionData.getSelected();
            if (collection == null) continue;
            for (IvyNode ivyNode : collection) {
                if (!ivyNode.getRealNode().equals(this.node)) continue;
                iterator.remove();
            }
        }
    }

    public void markEvicted(EvictionData evictionData) {
        this.evicted.put(evictionData.getRootModuleConf(), evictionData);
    }

    public EvictionData getEvictedData(String string) {
        this.cleanEvicted();
        return (EvictionData)this.evicted.get(string);
    }

    public String[] getEvictedConfs() {
        this.cleanEvicted();
        return this.evicted.keySet().toArray(new String[this.evicted.keySet().size()]);
    }

    public Collection getAllEvictingNodes() {
        HashSet hashSet = null;
        for (EvictionData evictionData : this.evicted.values()) {
            Collection collection = evictionData.getSelected();
            if (collection == null) continue;
            if (hashSet == null) {
                hashSet = new HashSet();
            }
            hashSet.addAll(collection);
        }
        return hashSet;
    }

    public Collection getAllEvictingNodesDetails() {
        HashSet<String> hashSet = null;
        for (EvictionData evictionData : this.evicted.values()) {
            Collection collection = evictionData.getSelected();
            if (collection == null) continue;
            if (hashSet == null) {
                hashSet = new HashSet<String>();
            }
            if (collection.size() == 1) {
                hashSet.add(collection.iterator().next() + (evictionData.getDetail() == null ? "" : " " + evictionData.getDetail()));
                continue;
            }
            if (collection.size() <= 1) continue;
            hashSet.add(collection + (evictionData.getDetail() == null ? "" : " " + evictionData.getDetail()));
        }
        return hashSet;
    }

    public Collection getAllEvictingConflictManagers() {
        HashSet<ConflictManager> hashSet = new HashSet<ConflictManager>();
        for (EvictionData evictionData : this.evicted.values()) {
            hashSet.add(evictionData.getConflictManager());
        }
        return hashSet;
    }

    public EvictionData getEvictionDataInRoot(String string, IvyNode ivyNode) {
        Set set = this.node.getRoot().getResolvedNodes(this.node.getModuleId(), string);
        for (IvyNode ivyNode2 : set) {
            if (!ivyNode2.getResolvedId().equals(this.node.getResolvedId())) continue;
            return null;
        }
        return new EvictionData(string, ivyNode, this.node.getRoot().getConflictManager(this.node.getModuleId()), set);
    }

    public Collection getPendingConflicts(String string, ModuleId moduleId) {
        Collection collection = (Collection)this.pendingConflicts.get(new ModuleIdConf(moduleId, string));
        HashSet<IvyNode> hashSet = new HashSet<IvyNode>();
        if (collection != null) {
            for (IvyNode ivyNode : collection) {
                hashSet.add(ivyNode.getRealNode());
            }
        }
        return hashSet;
    }

    public void setPendingConflicts(ModuleId moduleId, String string, Collection collection) {
        ModuleIdConf moduleIdConf = new ModuleIdConf(moduleId, string);
        this.pendingConflicts.put(moduleIdConf, new HashSet(collection));
    }

    private static final class ModuleIdConf {
        private ModuleId moduleId;
        private String conf;

        public ModuleIdConf(ModuleId moduleId, String string) {
            if (moduleId == null) {
                throw new NullPointerException("mid cannot be null");
            }
            if (string == null) {
                throw new NullPointerException("conf cannot be null");
            }
            this.moduleId = moduleId;
            this.conf = string;
        }

        public final String getConf() {
            return this.conf;
        }

        public final ModuleId getModuleId() {
            return this.moduleId;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ModuleIdConf)) {
                return false;
            }
            return this.getModuleId().equals(((ModuleIdConf)object).getModuleId()) && this.getConf().equals(((ModuleIdConf)object).getConf());
        }

        public int hashCode() {
            int n = 33;
            n += this.getModuleId().hashCode() * 17;
            return n += this.getConf().hashCode() * 17;
        }
    }

    public static class EvictionData {
        private IvyNode parent;
        private ConflictManager conflictManager;
        private Collection selected;
        private String rootModuleConf;
        private String detail;

        public EvictionData(String string, IvyNode ivyNode, ConflictManager conflictManager, Collection collection) {
            this(string, ivyNode, conflictManager, collection, null);
        }

        public EvictionData(String string, IvyNode ivyNode, ConflictManager conflictManager, Collection collection, String string2) {
            this.rootModuleConf = string;
            this.parent = ivyNode;
            this.conflictManager = conflictManager;
            this.selected = collection;
            this.detail = string2;
        }

        public String toString() {
            if (this.selected != null) {
                return this.selected + " in " + this.parent + (this.detail == null ? "" : " " + this.detail) + " (" + this.conflictManager + ") [" + this.rootModuleConf + "]";
            }
            return "transitively [" + this.rootModuleConf + "]";
        }

        public ConflictManager getConflictManager() {
            return this.conflictManager;
        }

        public IvyNode getParent() {
            return this.parent;
        }

        public Collection getSelected() {
            return this.selected;
        }

        public String getRootModuleConf() {
            return this.rootModuleConf;
        }

        public boolean isTransitivelyEvicted() {
            return this.parent == null;
        }

        public String getDetail() {
            return this.detail;
        }
    }
}

