/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Cassandra;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.CassandraIntermediateSession;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateSession;
import org.jetbrains.dekaf.util.Version;

public class CassandraIntermediateFacade
extends JdbcIntermediateFacade {
    private static final String CONNECTION_INFO_QUERY = "select release_version from system.local";

    public CassandraIntermediateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, @NotNull Driver driver, int connectionsLimit, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        super(connectionString, connectionProperties, driver, connectionsLimit, exceptionRecognizer);
    }

    public CassandraIntermediateFacade(@NotNull DataSource dataSource, int connectionsLimit, boolean ownConnections, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        super(dataSource, connectionsLimit, ownConnections, exceptionRecognizer);
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        return Cassandra.RDBMS;
    }

    @Override
    @NotNull
    protected JdbcIntermediateSession instantiateSession(@NotNull Connection connection, boolean ownConnection) {
        return new CassandraIntermediateSession(this, this.myExceptionRecognizer, connection, ownConnection);
    }

    @Override
    @Nullable
    protected ConnectionInfo obtainConnectionInfoNatively() {
        String driverVersionStr;
        String schemaName;
        String rdbmsName;
        String[] env;
        JdbcIntermediateSession session = this.openSession();
        try {
            env = session.queryOneRow(CONNECTION_INFO_QUERY, 1, String.class);
            Connection connection = session.getConnection();
            DatabaseMetaData md = connection.getMetaData();
            rdbmsName = md.getDatabaseProductName();
            schemaName = connection.getCatalog();
            if (rdbmsName == null) {
                rdbmsName = connection.getClass().getName();
            }
            driverVersionStr = md.getDriverVersion();
        }
        catch (SQLException sqle) {
            throw this.getExceptionRecognizer().recognizeException(sqle, "getting versions using JDBC metadata");
        }
        finally {
            session.close();
        }
        Version driverVersion = CassandraIntermediateFacade.extractVersion(driverVersionStr, SIMPLE_VERSION_PATTERN, 1);
        if (env != null) {
            assert (env.length == 1);
            Version serverVersion = CassandraIntermediateFacade.extractVersion(env[0], SIMPLE_VERSION_PATTERN, 1);
            return new ConnectionInfo(rdbmsName, null, schemaName, null, serverVersion, driverVersion);
        }
        return new ConnectionInfo(rdbmsName, null, schemaName, null, Version.ZERO, driverVersion);
    }
}

