/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.actions.DdlActions;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.actions.ChooseConsoleAction;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.NameChecker;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.view.ui.DbRefactoringHelper;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.MultiSelectionListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlResolveConfigurable;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.editor.SqlAnnotator;
import com.intellij.sql.inspections.SqlEditorAwareFix;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.JdbcProcedureCall;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlDropStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlGrantStatement;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.SqlRevokeStatement;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.NotImplementedError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlResolveInspection
extends SqlInspectionBase {
    private static final int MAX_COL_NAME_LENGTH = 30;

    @NotNull
    public String getDisplayName() {
        String string = SqlMessages.message("inspection.name.resolve", new Object[0]);
        if (string == null) {
            SqlResolveInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(final @NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            SqlResolveInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            SqlResolveInspection.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            SqlResolveInspection.$$$reportNull$$$0(3);
        }
        final SyntaxTraverser traverser2 = (SyntaxTraverser)SqlImplUtil.sqlTraverser().filter(Conditions.instanceOf(SqlReferenceExpression.class));
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){
            final Map<PsiFile, List<DbDataSource>> dataSources;
            {
                super(manager, dialect2, results2);
                this.dataSources = FactoryMap.create(o -> SqlImplUtil.getDataSources((PsiElement)o));
            }

            public void visitSqlReferenceExpression(@NotNull SqlReferenceExpression re) {
                if (re == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (PsiElement element2 : (SyntaxTraverser)traverser2.withRoot((Object)re)) {
                    SqlReferenceExpression o = (SqlReferenceExpression)element2;
                    if (this.shouldNotCheckElement((SqlElement)o)) {
                        return;
                    }
                    SqlReferenceElementType refType = o.getReferenceElementType();
                    ObjectKind type = refType.getTargetKind();
                    if (refType == SqlCompositeElementTypes.SQL_OPTIONAL_REFERENCE || !this.myDialect.shallResolve(o, type)) {
                        return;
                    }
                    SqlExpression qualifier = o.getQualifierExpression();
                    SqlIdentifier identifier = o.getIdentifier();
                    boolean afterIfExists = this.afterIfExistsClause(o);
                    if (qualifier instanceof SqlReferenceExpression) {
                        if (((SqlReferenceExpression)qualifier).resolve() == null) continue;
                        this.checkIdentifier(identifier, afterIfExists);
                        break;
                    }
                    this.checkIdentifier(identifier, afterIfExists);
                }
            }

            private void checkIdentifier(@Nullable SqlIdentifier identifier, boolean afterIfExists) {
                if (identifier == null || afterIfExists) {
                    return;
                }
                this.checkResolve(identifier);
            }

            private boolean afterIfExistsClause(@NotNull SqlReferenceExpression o) {
                PsiElement parent2;
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                return ((parent2 = o.getParent()) instanceof SqlDropStatement || parent2 instanceof SqlAlterStatement || parent2 instanceof SqlAlterInstruction) && FormatterUtil.hasPrecedingSiblingOfType((ASTNode)o.getNode(), (IElementType)SqlCompositeElementTypes.SQL_IF_EXISTS_CLAUSE, (IElementType[])new IElementType[0]);
            }

            public void visitSqlIdentifier(@NotNull SqlIdentifier o) {
                if (o == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                if (o.getParent() instanceof SqlRenameToClause) {
                    return;
                }
                this.checkResolve(o);
            }

            public void visitSqlParameter(SqlParameter o) {
            }

            private boolean checkResolve(@Nullable SqlIdentifier o) {
                SqlFunctionCallExpression foo;
                boolean isFunction;
                PsiElement grandPa;
                if (o == null || o.getTextLength() == 0) {
                    return false;
                }
                IElementType firstChildType = PsiUtilCore.getElementType((PsiElement)o.getFirstChild());
                if (firstChildType == SqlTokens.SQL_EXTERNAL_PARAM || firstChildType == SqlTokens.SQL_EXTERNAL_PARAM_PREFIX || firstChildType == SqlTokens.SQL_CUSTOM_PARAM_LQUOTE) {
                    return true;
                }
                if (o.getFirstChild() instanceof SqlParameter) {
                    return true;
                }
                if (o.getLastChild() instanceof SqlParameter) {
                    return true;
                }
                PsiElement parent2 = o.getParent();
                PsiElement psiElement = grandPa = parent2 == null ? null : parent2.getParent();
                if (parent2 instanceof SqlReferenceExpression && grandPa instanceof SqlDefinition && grandPa instanceof SqlAlterStatement) {
                    return this.checkAlterResolve(o, (SqlDefinition)grandPa);
                }
                PsiElement target = SqlAnnotator.getTargetElement(o);
                if (target == parent2 && "*".equals(o.getText()) && (!(parent2 instanceof SqlExpression) || SqlType.UNKNOWN == ((SqlExpression)parent2).getSqlType())) {
                    SqlStatement st = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)o, SqlStatement.class);
                    if (st instanceof SqlGrantStatement || st instanceof SqlRevokeStatement) {
                        return true;
                    }
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, "Unable to resolve * in this context", true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly, new LocalQuickFix[0]));
                    return false;
                }
                if (target != null) {
                    return true;
                }
                ObjectKind expectedType = parent2 instanceof SqlReferenceExpression ? ((SqlReferenceExpression)parent2).getReferenceElementType().getTargetKind() : SqlDbElementType.ANY;
                boolean bl = isFunction = expectedType == ObjectKind.ROUTINE;
                if (isFunction && parent2.getParent().getParent() instanceof JdbcProcedureCall) {
                    return true;
                }
                SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
                if (expectedType == ObjectKind.ARGUMENT && (foo = (SqlFunctionCallExpression)ObjectUtils.tryCast((Object)api.parents((Object)parent2).skip(3).first(), SqlFunctionCallExpression.class)) != null) {
                    if (foo.getParent() instanceof JdbcProcedureCall) {
                        return true;
                    }
                    SqlReferenceExpression name = foo.getNameElement();
                    if (name == null || name.resolve() == null) {
                        return true;
                    }
                }
                String kindName = DbPresentation.getPresentableName(expectedType, SqlImplUtil.getSqlDialectSafe((PsiElement)o).getDatabaseDialect());
                String message2 = isFunction ? SqlMessages.message("unknown.function", o.getName()) : (expectedType != SqlDbElementType.ANY ? SqlMessages.message("unable.to.resolve.symbol.0.1", kindName, o.getName()) : SqlMessages.message("unable.to.resolve.symbol.0", o.getName()));
                List<LocalQuickFix> fixes = this.createQuickFixesFor(o, parent2, expectedType);
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, message2, true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly, onTheFly ? fixes.toArray(LocalQuickFix.EMPTY_ARRAY) : LocalQuickFix.EMPTY_ARRAY));
                return false;
            }

            private boolean checkAlterResolve(SqlIdentifier o, SqlDefinition def) {
                boolean resolved;
                Object[] elements = SqlImplUtil.getRelatedElements(def);
                boolean bl = resolved = elements.length != 0;
                if (resolved) {
                    PsiElement res2 = (PsiElement)JBIterable.of((Object[])elements).filter(x -> !(x instanceof SqlAlterStatement)).first();
                    boolean bl2 = resolved = res2 != null;
                }
                if (!resolved) {
                    String message2 = SqlMessages.message("unable.to.resolve.symbol.0.1", def.getKind(), o.getName());
                    List<LocalQuickFix> fixes = this.createQuickFixesFor(o, o.getParent(), def.getKind());
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, message2, true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly, onTheFly ? fixes.toArray(LocalQuickFix.EMPTY_ARRAY) : LocalQuickFix.EMPTY_ARRAY));
                }
                return resolved;
            }

            private boolean isInsertIntoArg(@NotNull SqlIdentifier o) {
                SqlInsertDmlInstruction insert;
                if (o == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((insert = (SqlInsertDmlInstruction)PsiTreeUtil.getParentOfType((PsiElement)o, SqlInsertDmlInstruction.class, (boolean)true, (Class[])new Class[]{SqlStatement.class})) == null) {
                    return false;
                }
                SqlTableColumnsList list = insert.getColumnsList();
                if (list == null) {
                    return false;
                }
                SqlReferenceExpression reference = list.getTableReference();
                return reference != null && PsiTreeUtil.isAncestor((PsiElement)reference, (PsiElement)o, (boolean)true);
            }

            private boolean addFixesByExpectedType(@NotNull SqlIdentifier o, @Nullable PsiElement parent2, @NotNull ObjectKind expectedType, @NotNull List<LocalQuickFix> result2) {
                block15: {
                    block18: {
                        Object reference;
                        block16: {
                            PsiElement resolveResult;
                            block19: {
                                SqlExpression expression;
                                PsiElement resolve;
                                block17: {
                                    SqlExpression qualifierExpression;
                                    LeafPsiElement beginKeyword;
                                    SqlLanguageDialectEx dialect2;
                                    Dbms dbms;
                                    if (o == null) {
                                        1.$$$reportNull$$$0(4);
                                    }
                                    if (expectedType == null) {
                                        1.$$$reportNull$$$0(5);
                                    }
                                    if (result2 == null) {
                                        1.$$$reportNull$$$0(6);
                                    }
                                    if (expectedType == ObjectKind.TABLE) {
                                        Dbms dbms2;
                                        result2.add((LocalQuickFix)new AddSqlTableFix(o, false));
                                        result2.add((LocalQuickFix)new AddDbTableFix(o));
                                        if (this.isInsertIntoArg(o) && AddSqlTableFix.supportsNonVarTemporaryTables(dbms2 = SqlImplUtil.getSqlDialectSafe((PsiElement)o).getDbms())) {
                                            result2.add((LocalQuickFix)new AddSqlTableFix(o, true));
                                        }
                                        return true;
                                    }
                                    if (expectedType == ObjectKind.VARIABLE) {
                                        if (this.isInsertIntoArg(o)) {
                                            if (SqlImplUtil.getSqlDialectSafe((PsiElement)o).getDbms().isMicrosoft()) {
                                                result2.add((LocalQuickFix)new AddSqlTableFix(o, true));
                                            }
                                            return true;
                                        }
                                        String text2 = DeclareUserVariableFix.wrapVariableText(o);
                                        if (text2 != null) {
                                            result2.add((LocalQuickFix)new DeclareUserVariableFix(o, text2));
                                        }
                                        return true;
                                    }
                                    if (expectedType != ObjectKind.COLUMN) break block15;
                                    if (!(parent2 instanceof SqlReferenceExpression)) {
                                        return true;
                                    }
                                    SqlBlockStatement blockStatement = (SqlBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)parent2, SqlBlockStatement.class);
                                    if (blockStatement != null && DeclarePlVariableFix.supportsPlSql(dbms = (dialect2 = SqlImplUtil.getSqlDialectSafe((PsiElement)blockStatement)).getDbms()) && (beginKeyword = (LeafPsiElement)SqlImplUtil.sqlChildren((PsiElement)blockStatement).filter(LeafPsiElement.class).filter(e -> e.getElementType() == SqlCommonKeywords.SQL_BEGIN).first()) != null) {
                                        result2.add((LocalQuickFix)new DeclarePlVariableFix(o));
                                    }
                                    if (!((qualifierExpression = ((SqlReferenceExpression)parent2).getQualifierExpression()) instanceof SqlReferenceExpression)) break block16;
                                    reference = qualifierExpression.getReference();
                                    PsiElement psiElement = resolve = reference != null ? reference.resolve() : null;
                                    if (!(resolve instanceof DbTable) || ((DbTable)resolve).getKind() != ObjectKind.TABLE) break block17;
                                    result2.add((LocalQuickFix)new AddDbColumnFix(o, (DbTable)resolve));
                                    break block18;
                                }
                                if (!(resolve instanceof SqlAsExpression) || !((expression = ((SqlAsExpression)resolve).getExpression()) instanceof SqlReferenceExpression)) break block18;
                                PsiReference psiReference = expression.getReference();
                                PsiElement psiElement = resolveResult = psiReference != null ? psiReference.resolve() : null;
                                if (!(resolveResult instanceof DbTable) || ((DbTable)resolveResult).getKind() != ObjectKind.TABLE) break block19;
                                result2.add((LocalQuickFix)new AddDbColumnFix(o, (DbTable)resolveResult));
                                break block18;
                            }
                            if (!(resolveResult instanceof SqlCreateTableStatement)) break block18;
                            result2.add((LocalQuickFix)new AddSqlColumnFix(o, (SqlCreateTableStatement)resolveResult));
                            break block18;
                        }
                        reference = (SqlReferenceImpl)ObjectUtils.tryCast((Object)((SqlReferenceExpression)parent2).getReference(), SqlReferenceImpl.class);
                        if (reference != null) {
                            MyResolveContextProcessor processor = new MyResolveContextProcessor(((SqlReferenceImpl)reference).getReferenceName(), this.myDialect, (Iterable<DbDataSource>)this.dataSources.get(parent2.getContainingFile()), parent2);
                            if (((SqlReferenceImpl)reference).initExpectedTargetTypes(processor)) {
                                ((SqlReferenceImpl)reference).processResolveVariants(processor);
                            }
                            for (DbTable dbTable : processor.dbTables) {
                                if (dbTable.getKind() != ObjectKind.TABLE) continue;
                                result2.add((LocalQuickFix)new AddDbColumnFix(o, dbTable));
                            }
                            for (SqlCreateTableStatement sqlCreateTableStatement : processor.sqlTables) {
                                result2.add((LocalQuickFix)new AddSqlColumnFix(o, sqlCreateTableStatement));
                            }
                        }
                    }
                    return true;
                }
                return false;
            }

            @NotNull
            private List<LocalQuickFix> createQuickFixesFor(@NotNull SqlIdentifier o, @Nullable PsiElement parent2, @NotNull ObjectKind expectedType) {
                boolean addGenericFixes;
                ArrayList result2;
                if (o == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (expectedType == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (!this.addFixesByExpectedType(o, parent2, expectedType, result2 = ContainerUtil.newArrayList())) {
                    this.addIntrospectFixes(o, parent2, result2);
                }
                VirtualFile file = SqlImplUtil.getTopLevelFile(o.getContainingFile());
                boolean bl = addGenericFixes = expectedType != ObjectKind.COLUMN && file != null && !(file.getFileSystem() instanceof NonPhysicalFileSystem) && !DbSrcUtils.isDbSrcFile(file) && !DbConsoleRootType.isConsoleFile(file);
                if (addGenericFixes) {
                    result2.add(new GoToResolutionScopesFix());
                    if (onTheFly && JdbcConsoleProvider.getAttachedConsole(o.getProject(), file) == null) {
                        result2.add(new AttachConsoleFix());
                    }
                }
                ArrayList arrayList = result2;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(9);
                }
                return arrayList;
            }

            private void addIntrospectFixes(@NotNull SqlIdentifier o, @Nullable PsiElement parent2, @NotNull List<LocalQuickFix> result2) {
                String name;
                List candidates;
                SqlReferenceImpl ref;
                if (o == null) {
                    1.$$$reportNull$$$0(10);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(11);
                }
                SqlReferenceImpl sqlReferenceImpl = ref = parent2 instanceof SqlReferenceExpression ? (SqlReferenceImpl)ObjectUtils.tryCast((Object)parent2.getReference(), SqlReferenceImpl.class) : null;
                if (ref == null) {
                    return;
                }
                MyResolveContextProcessor processor = new MyResolveContextProcessor(ref.getReferenceName(), this.myDialect, (Iterable<DbDataSource>)this.dataSources.get(parent2.getContainingFile()), parent2);
                ref.initExpectedTargetTypes(processor);
                boolean schemaExpected = processor.isExpected(ObjectKind.SCHEMA);
                boolean dbExpected = processor.isExpected(ObjectKind.DATABASE);
                if (!schemaExpected && !dbExpected) {
                    return;
                }
                SqlReferenceExpression qualifier = (SqlReferenceExpression)ObjectUtils.tryCast((Object)((SqlReferenceExpression)parent2).getQualifierExpression(), SqlReferenceExpression.class);
                Object[] resolved = qualifier == null ? ResolveResult.EMPTY_ARRAY : qualifier.multiResolve(false);
                JBIterable namespaces = JBIterable.empty();
                if (resolved.length == 0) {
                    SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)o.getContainingFile(), SqlFile.class);
                    if (file != null) {
                        SqlImportState checker = SqlDialectImplUtil.getImportCheckerAt(file, (PsiElement)o);
                        for (DbDataSource source : processor.dataSources) {
                            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)source.getDelegate().getModel(), BasicModel.class);
                            if (model == null) continue;
                            namespaces = namespaces.append((Iterable)((JBTreeTraverser)model.traverser(true).expand(SqlFileImpl.importedCondition(checker, source))).filter(BasicMateNamespace.class).transform(n -> Pair.create((Object)source, (Object)n)));
                        }
                    }
                } else {
                    namespaces = JBIterable.of((Object[])resolved).map(ResolveResult::getElement).filter(DbElement.class).flatten(e -> {
                        BasicElement object = (BasicElement)ObjectUtils.tryCast((Object)e.getDelegate(), BasicElement.class);
                        DbDataSource source = e.getDataSource();
                        return object == null ? JBIterable.empty() : object.getChildren().filter(BasicMateNamespace.class).map(n -> Pair.create((Object)source, (Object)n));
                    });
                }
                if (!(candidates = namespaces.filter(arg_0 -> 1.lambda$addIntrospectFixes$6(name = ref.getReferenceName(), dialect, schemaExpected, dbExpected, arg_0)).toList()).isEmpty()) {
                    ObjectKind kind = dbExpected && schemaExpected ? ObjectKind.NONE : (dbExpected ? ObjectKind.DATABASE : ObjectKind.SCHEMA);
                    result2.add((LocalQuickFix)new IntrospectSchemaFix(candidates, kind));
                }
            }

            private static /* synthetic */ boolean lambda$addIntrospectFixes$6(String name, @NotNull SqlLanguageDialectEx dialect2, boolean schemaExpected, boolean dbExpected, Pair n) {
                if (dialect2 == null) {
                    1.$$$reportNull$$$0(12);
                }
                return !((BasicMateNamespace)n.second).isVisible() && DasUtil.nameEqual((DasObject)((DasObject)n.second), (String)name, (CasingProvider)dialect2) && (((BasicMateNamespace)n.second).getKind() == ObjectKind.SCHEMA && schemaExpected || ((BasicMateNamespace)n.second).getKind() == ObjectKind.DATABASE && dbExpected);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 9: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 9: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "re";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 5: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expectedType";
                        break;
                    }
                    case 6: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$1";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dialect";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$1";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createQuickFixesFor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitSqlReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "afterIfExistsClause";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "visitSqlIdentifier";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "isInsertIntoArg";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "addFixesByExpectedType";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "createQuickFixesFor";
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 10: 
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "addIntrospectFixes";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$addIntrospectFixes$6";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 9: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static void setVariable(TemplateImpl copy, String valueString, int index2, String varName, boolean stop) {
        Variable variable = (Variable)copy.getVariables().get(index2);
        assert (varName.equals(variable.getName()));
        variable.setDefaultValueString("\"" + valueString + "\"");
        variable.setAlwaysStopAt(stop);
    }

    @NotNull
    private static String getTypeText(SqlType type, Dbms dbms) {
        String typeName;
        String string = typeName = type == null ? "int" : type.getDisplayName();
        if ((dbms.isOracle() || dbms.isMysql()) && "varchar".equalsIgnoreCase(typeName)) {
            String string2 = typeName + "(255)";
            if (string2 == null) {
                SqlResolveInspection.$$$reportNull$$$0(4);
            }
            return string2;
        }
        String string3 = typeName;
        if (string3 == null) {
            SqlResolveInspection.$$$reportNull$$$0(5);
        }
        return string3;
    }

    private static List<SqlType> mergeTypes(Collection<Collection<SqlType>> types) {
        ArrayList result2 = ContainerUtil.newArrayList();
        for (Collection<SqlType> typeList : types) {
            if (result2.isEmpty()) {
                result2.addAll(typeList);
                continue;
            }
            int i2 = 0;
            for (SqlType type : typeList) {
                if (i2 < result2.size()) {
                    result2.set(i2, SqlResolveInspection.merge((SqlType)result2.get(i2), type));
                }
                ++i2;
            }
        }
        return result2;
    }

    private static SqlType merge(SqlType type, SqlType type1) {
        if (type == null) {
            return type1;
        }
        if (type1 == null) {
            return type;
        }
        return type == type1 ? type : (SqlFunctionsUtil.isAssignable(type, type1) ? type1 : type);
    }

    private static void collectColumnTypes(SqlStatement statement, Collection<Collection<SqlType>> types, List<Boolean> nullableFlags) {
        SqlImplUtil.sqlTraverser((PsiElement)statement).filter(SqlValuesExpression.class).forEach(e -> e.getExpressions().filter(SqlParenthesizedExpression.class).forEach(pe -> {
            types.add(ContainerUtil.map((Collection)pe.getExpressionList(), el -> el.getSqlType()));
            List nullableState = ContainerUtil.map((Collection)pe.getExpressionList(), ex -> ex instanceof SqlLiteralExpression && "null".equals(ex.getText()));
            if (nullableFlags.isEmpty()) {
                nullableFlags.addAll(nullableState);
            } else {
                for (int i2 = 0; i2 < nullableFlags.size(); ++i2) {
                    if (i2 >= nullableState.size()) continue;
                    nullableFlags.set(i2, (Boolean)nullableFlags.get(i2) | (Boolean)nullableState.get(i2));
                }
            }
        }));
        SqlQueryExpression queryExpression = SqlResolveInspection.getQueryExpression(statement);
        if (queryExpression == null) {
            return;
        }
        SqlType type = queryExpression.getSqlType();
        if (type instanceof SqlTableType && !(type instanceof SqlTableTypeBase.Empty)) {
            int columnCount = ((SqlTableType)type).getColumnCount();
            ArrayList allTypes = ContainerUtil.newArrayListWithCapacity((int)columnCount);
            for (int i2 = 0; i2 < columnCount; ++i2) {
                try {
                    SqlType columnType = ((SqlTableType)type).getColumnType(i2);
                    allTypes.add(columnType);
                    continue;
                }
                catch (Exception e2) {
                    allTypes.add(null);
                }
            }
            types.add(allTypes);
        }
    }

    @Nullable
    private static SqlQueryExpression getQueryExpression(SqlStatement statement) {
        if (!(statement instanceof SqlInsertStatement)) {
            return null;
        }
        SqlInsertDmlInstruction insert = (SqlInsertDmlInstruction)PsiTreeUtil.getChildOfType((PsiElement)statement, SqlInsertDmlInstruction.class);
        if (insert == null) {
            return null;
        }
        SqlQueryExpression queryExpression = insert.getQueryExpression();
        if (queryExpression == null) {
            return null;
        }
        return queryExpression;
    }

    private static void collectColumnNames(@NotNull SqlIdentifier element2, @NotNull SqlStatement statement, @NotNull Collection<String> columnsNames) {
        if (element2 == null) {
            SqlResolveInspection.$$$reportNull$$$0(6);
        }
        if (statement == null) {
            SqlResolveInspection.$$$reportNull$$$0(7);
        }
        if (columnsNames == null) {
            SqlResolveInspection.$$$reportNull$$$0(8);
        }
        SqlQueryExpression queryExpression = SqlResolveInspection.getQueryExpression(statement);
        String defaultName = "col";
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)element2);
        Project project = element2.getProject();
        if (queryExpression != null) {
            SqlType type = queryExpression.getSqlType();
            if (type instanceof SqlTableType && !(type instanceof SqlTableTypeBase.Empty)) {
                for (int i2 = 0; i2 < ((SqlTableType)type).getColumnCount(); ++i2) {
                    columnsNames.add(SqlResolveInspection.guessColumnName(columnsNames, defaultName, dialect, project, (SqlTableType)type, i2));
                }
            }
            return;
        }
        SqlLanguageDialectEx sqlLanguage = SqlImplUtil.getSqlDialectSafe((PsiElement)statement);
        CasingProvider casingProvider = SqlImplUtil.getCasingProvider(sqlLanguage, SqlImplUtil.getDataSources((PsiElement)statement));
        SqlAsExpression asExpression = (SqlAsExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlAsExpression.class);
        JBIterable iterable = SqlImplUtil.sqlTraverser((PsiElement)statement).filter(SqlReferenceExpression.class);
        for (SqlReferenceExpression e : iterable) {
            ObjectKind type = e.getReferenceElementType().getTargetKind();
            PsiPolyVariantReference reference = e.getReference();
            SqlIdentifier identifier = e.getIdentifier();
            if (type != ObjectKind.COLUMN || identifier == null || reference.resolve() != null) continue;
            SqlReferenceExpression qualifier = (SqlReferenceExpression)ObjectUtils.tryCast((Object)e.getQualifierExpression(), SqlReferenceExpression.class);
            if (asExpression != null && qualifier != null && !asExpression.equals(qualifier.resolve()) && !new NameChecker(qualifier, sqlLanguage, casingProvider).checkName(element2.getParent(), false)) continue;
            columnsNames.add(identifier.getText());
        }
    }

    @Nullable
    private static String computeNameFromReference(@Nullable SqlReferenceExpression expression) {
        if (expression == null) {
            return null;
        }
        SqlExpression qualifierExpression = expression.getQualifierExpression();
        if (qualifierExpression != null) {
            StringBuilder fullName = new StringBuilder(expression.getName());
            expression = (SqlReferenceExpression)ObjectUtils.tryCast((Object)qualifierExpression, SqlReferenceExpression.class);
            while (expression != null) {
                fullName.insert(0, expression.getName() + "_");
                expression = (SqlReferenceExpression)ObjectUtils.tryCast((Object)expression.getQualifierExpression(), SqlReferenceExpression.class);
            }
            return fullName.toString();
        }
        return null;
    }

    private static String getNameFromElement(@Nullable PsiElement element2, boolean allowUnqualifiedRefs) {
        if (element2 == null) {
            return null;
        }
        if (element2 instanceof SqlReferenceExpression) {
            String nameFromReference = SqlResolveInspection.computeNameFromReference((SqlReferenceExpression)element2);
            return nameFromReference == null && allowUnqualifiedRefs ? ((SqlReferenceExpression)element2).getName() : nameFromReference;
        }
        if (element2 instanceof SqlFunctionCallExpression) {
            SqlReferenceExpression nameElement = ((SqlFunctionCallExpression)element2).getNameElement();
            if (nameElement == null) {
                return null;
            }
            String func_Name = nameElement.getName();
            StringBuilder nameBuilder = new StringBuilder(func_Name);
            SqlExpressionList list = ((SqlFunctionCallExpression)element2).getParameterList();
            if (list != null) {
                for (SqlExpression expression : list.getExpressionList()) {
                    String innerName = SqlResolveInspection.getNameFromElement((PsiElement)expression, true);
                    if (innerName == null) continue;
                    nameBuilder.insert(0, innerName + "_");
                }
            }
            return nameBuilder.toString();
        }
        SqlFunctionCallExpression functionCallExpression = (SqlFunctionCallExpression)SqlImplUtil.sqlTraverser(element2).filter(SqlFunctionCallExpression.class).first();
        if (functionCallExpression != null) {
            return SqlResolveInspection.getNameFromElement((PsiElement)functionCallExpression, true);
        }
        return SqlResolveInspection.getNameFromElement((PsiElement)SqlImplUtil.sqlTraverser(element2).filter(SqlReferenceExpression.class).first(), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static String guessColumnName(@NotNull Collection<String> columnsNames, String defaultName, SqlLanguageDialectEx dialect, Project project, SqlTableType type, int i2) {
        block10: {
            String columnName;
            block11: {
                String string;
                if (columnsNames == null) {
                    SqlResolveInspection.$$$reportNull$$$0(9);
                }
                try {
                    columnName = type.getColumnName(i2);
                    if (columnName == null) break block10;
                    if (!columnsNames.contains(columnName) && StringUtil.indexOfAny((String)columnName, (String)"(\r\n") < 0) break block11;
                    try {
                        PsiElement element2 = type.getColumnElement(i2);
                        String nameFromElement = SqlResolveInspection.getNameFromElement(element2, false);
                        if (nameFromElement == null) break block11;
                        string = SqlResolveInspection.disambiguateAndQuote(columnsNames, nameFromElement, dialect, project);
                    }
                    catch (Exception exception) {
                        // empty catch block
                        break block11;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                    break block10;
                }
                if (string == null) {
                    SqlResolveInspection.$$$reportNull$$$0(10);
                }
                return string;
            }
            columnName = StringUtil.replace((String)columnName, (String)"\r", (String)" ");
            if ((columnName = StringUtil.replace((String)columnName, (String)"\n", (String)" ")).length() <= 30) {
                String string = SqlResolveInspection.disambiguateAndQuote(columnsNames, columnName, dialect, project);
                if (string == null) {
                    SqlResolveInspection.$$$reportNull$$$0(11);
                }
                return string;
            }
        }
        String string = SqlResolveInspection.disambiguateAndQuote(columnsNames, defaultName, dialect, project);
        if (string == null) {
            SqlResolveInspection.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static String disambiguateAndQuote(@NotNull Collection<String> columnsNames, String columnName, SqlLanguageDialectEx dialect, Project project) {
        if (columnsNames == null) {
            SqlResolveInspection.$$$reportNull$$$0(13);
        }
        String finalName = columnName;
        int localIdx = 0;
        while (columnsNames.contains(finalName)) {
            finalName = columnName + ++localIdx;
        }
        return dialect.quoteIdentifier(project, finalName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "guessColumnName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationVisitor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectColumnNames";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "guessColumnName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "disambiguateAndQuote";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyResolveContextProcessor
    extends SqlScopeProcessor {
        final Set<DbTable> dbTables;
        final Set<SqlCreateTableStatement> sqlTables;

        MyResolveContextProcessor(@NotNull String referenceName, @NotNull SqlLanguageDialectEx dialect, @NotNull Iterable<DbDataSource> dataSources2, @Nullable PsiElement place) {
            if (referenceName == null) {
                MyResolveContextProcessor.$$$reportNull$$$0(0);
            }
            if (dialect == null) {
                MyResolveContextProcessor.$$$reportNull$$$0(1);
            }
            if (dataSources2 == null) {
                MyResolveContextProcessor.$$$reportNull$$$0(2);
            }
            super(referenceName, dialect, dataSources2, place);
            this.dbTables = new HashSet<DbTable>();
            this.sqlTables = new HashSet<SqlCreateTableStatement>();
        }

        @Override
        public boolean isResultEmpty() {
            return this.dbTables.isEmpty() && this.sqlTables.isEmpty();
        }

        @Override
        public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object context) {
            if (event == null) {
                MyResolveContextProcessor.$$$reportNull$$$0(3);
            }
            super.handleEvent(event, context);
            if (event != SqlScopeProcessor.RESOLVE_CONTEXT) {
                return;
            }
            if (!(context instanceof PsiElement)) {
                return;
            }
            if (context instanceof SqlDmlInstruction) {
                SqlExpression targetExpression = ((SqlDmlInstruction)context).getTargetExpression();
                this.processReference(targetExpression == null ? null : targetExpression.getReference());
            }
            PsiElement contextParent = ((PsiElement)context).getParent();
            PsiRecursiveElementVisitor visitor2 = new PsiRecursiveElementVisitor(){

                public void visitElement(PsiElement o) {
                    if (o instanceof SqlReferenceExpression) {
                        this.processReference(o.getReference());
                        return;
                    }
                    super.visitElement(o);
                }
            };
            if (contextParent instanceof SqlQueryExpression) {
                SqlTableExpression tableExpression = ((SqlQueryExpression)contextParent).getTableExpression();
                if (tableExpression != null) {
                    tableExpression.accept((PsiElementVisitor)visitor2);
                }
            } else if (contextParent instanceof SqlTableColumnsList) {
                SqlReferenceExpression tableReference = ((SqlTableColumnsList)contextParent).getTableReference();
                this.processReference((PsiReference)(tableReference == null ? null : tableReference.getReference()));
            } else if (contextParent instanceof SqlTableExpression) {
                contextParent.accept((PsiElementVisitor)visitor2);
            } else if (contextParent instanceof SqlAlterStatement) {
                SqlReferenceExpression reference = ((SqlAlterStatement)contextParent).getAlterTargetReference();
                this.processReference((PsiReference)(reference == null ? null : reference.getReference()));
            } else if (context instanceof PsiObject) {
                this.processObject((PsiElement)context);
            }
        }

        private void processReference(@Nullable PsiReference ref) {
            this.processObject(ref != null ? ref.resolve() : null);
        }

        private void processObject(PsiElement resolve) {
            if (resolve instanceof DbTable) {
                this.dbTables.add((DbTable)resolve);
            } else if (resolve instanceof SqlCreateTableStatement) {
                this.sqlTables.add((SqlCreateTableStatement)resolve);
            }
        }

        @Override
        public boolean executeTarget(@Nullable DasObject target, @NotNull PsiElement element2, @Nullable SqlType sqlType, Boolean forcedCaseSens, @NotNull ResolveState state) {
            if (element2 == null) {
                MyResolveContextProcessor.$$$reportNull$$$0(4);
            }
            if (state == null) {
                MyResolveContextProcessor.$$$reportNull$$$0(5);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSources";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$MyResolveContextProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleEvent";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeTarget";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AddDbColumnFix
    extends SqlEditorAwareFix<SqlIdentifier> {
        final ObjectPath myTable;
        final String myColumnName;

        AddDbColumnFix(@NotNull SqlIdentifier o, @NotNull DbTable table) {
            if (o == null) {
                AddDbColumnFix.$$$reportNull$$$0(0);
            }
            if (table == null) {
                AddDbColumnFix.$$$reportNull$$$0(1);
            }
            super(o);
            this.myColumnName = o.getName();
            this.myTable = ObjectPaths.of((DasObject)table);
        }

        @Override
        @NotNull
        public String getText() {
            String string = "Add '" + this.myColumnName + "' to '" + this.myTable.getName() + "' table";
            if (string == null) {
                AddDbColumnFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull SqlIdentifier element2, @Nullable Editor editor) {
            DbDataSourceImpl dataSource;
            if (project == null) {
                AddDbColumnFix.$$$reportNull$$$0(3);
            }
            if (element2 == null) {
                AddDbColumnFix.$$$reportNull$$$0(4);
            }
            if ((dataSource = (DbDataSourceImpl)DbImplUtil.getForcedDataSource(element2.getContainingFile())) == null) {
                return;
            }
            DbElement table = DbSqlUtil.findElement(dataSource, this.myTable);
            if (table == null || table.getKind() != ObjectKind.TABLE) {
                return;
            }
            TransactionGuard.getInstance().submitTransactionLater((Disposable)project, () -> {
                if (element2 == null) {
                    AddDbColumnFix.$$$reportNull$$$0(5);
                }
                DdlActions.AddColumnAction.perform((DbTable)table, null, element2.getText());
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$AddDbColumnFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$AddDbColumnFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$applyFix$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AddDbTableFix
    extends SqlEditorAwareFix<SqlIdentifier> {
        AddDbTableFix(@Nullable SqlIdentifier o) {
            super(o);
        }

        @Override
        @NotNull
        public String getText() {
            if ("Add table to data source" == null) {
                AddDbTableFix.$$$reportNull$$$0(0);
            }
            return "Add table to data source";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull SqlIdentifier element2, @Nullable Editor editor) {
            List strings;
            if (project == null) {
                AddDbTableFix.$$$reportNull$$$0(1);
            }
            if (element2 == null) {
                AddDbTableFix.$$$reportNull$$$0(2);
            }
            DbDataSource dataSource = DbImplUtil.getForcedDataSource(element2.getContainingFile());
            SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlStatement.class);
            List list = strings = statement == null ? ContainerUtil.emptyList() : ContainerUtil.newArrayList();
            if (statement != null) {
                SqlResolveInspection.collectColumnNames(element2, statement, strings);
            }
            if (dataSource != null) {
                AddDbTableFix.showDialog(dataSource, element2, strings);
            } else if (editor != null) {
                ArrayList runners = ContainerUtil.newArrayList();
                for (DbDataSource source : DbPsiFacade.getInstance((Project)project).getDataSources()) {
                    runners.add(JdbcConsoleProvider.newRunner(source, () -> {
                        if (element2 == null) {
                            AddDbTableFix.$$$reportNull$$$0(12);
                        }
                        AddDbTableFix.showDialog(source, element2, strings);
                    }));
                }
                RunQueryInConsoleIntentionAction.chooseAndRunRunners("Data Sources", runners, editor, null);
            }
        }

        private static void showDialog(@NotNull DbDataSource source, @NotNull SqlIdentifier element2, @NotNull Collection<String> strings) {
            if (source == null) {
                AddDbTableFix.$$$reportNull$$$0(3);
            }
            if (element2 == null) {
                AddDbTableFix.$$$reportNull$$$0(4);
            }
            if (strings == null) {
                AddDbTableFix.$$$reportNull$$$0(5);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (source == null) {
                    AddDbTableFix.$$$reportNull$$$0(6);
                }
                if (element2 == null) {
                    AddDbTableFix.$$$reportNull$$$0(7);
                }
                if (strings == null) {
                    AddDbTableFix.$$$reportNull$$$0(8);
                }
                TransactionGuard.getInstance().submitTransactionAndWait(() -> {
                    if (source == null) {
                        AddDbTableFix.$$$reportNull$$$0(9);
                    }
                    if (element2 == null) {
                        AddDbTableFix.$$$reportNull$$$0(10);
                    }
                    if (strings == null) {
                        AddDbTableFix.$$$reportNull$$$0(11);
                    }
                    DdlActions.AddTableAction.showAddTableDialogAndRun(source, null, DbRefactoringHelper.createContext((DasObject)source, (PsiElement)source, false), element2.getText(), strings);
                });
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 5: 
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$AddDbTableFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "showDialog";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$showDialog$2";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$1";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$applyFix$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DeclareUserVariableFix
    extends SqlEditorAwareFix<SqlIdentifier> {
        private final String myText;

        protected DeclareUserVariableFix(@Nullable SqlIdentifier element2, @NotNull String text2) {
            if (text2 == null) {
                DeclareUserVariableFix.$$$reportNull$$$0(0);
            }
            super(element2);
            this.myText = text2;
        }

        @Override
        @NotNull
        public String getText() {
            if ("Declare variable" == null) {
                DeclareUserVariableFix.$$$reportNull$$$0(1);
            }
            return "Declare variable";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull SqlIdentifier element2, @Nullable Editor editor) {
            SqlStatement statement;
            if (project == null) {
                DeclareUserVariableFix.$$$reportNull$$$0(2);
            }
            if (element2 == null) {
                DeclareUserVariableFix.$$$reportNull$$$0(3);
            }
            if ((statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlStatement.class)) == null) {
                return;
            }
            SqlStatement statementFromText = SqlPsiElementFactory.createStatementFromText(this.myText, SqlImplUtil.getSqlDialectSafe((PsiElement)element2), project, (PsiElement)element2);
            assert (statementFromText != null);
            statement.getParent().addBefore((PsiElement)statementFromText, (PsiElement)statement);
        }

        @NotNull
        static String getTypeString(@NotNull SqlIdentifier element2) {
            IElementType sign;
            SqlExpression expression;
            SqlElement value;
            SqlSetAssignment assignment;
            if (element2 == null) {
                DeclareUserVariableFix.$$$reportNull$$$0(4);
            }
            if ((assignment = (SqlSetAssignment)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlSetAssignment.class)) != null && (value = assignment.getRValue()) != null && (expression = SqlPsiElementFactory.createExpressionFromText(value.getText(), SqlImplUtil.getSqlDialectSafe((PsiElement)element2), (PsiElement)element2)) != null) {
                String string = expression.getSqlType().getDisplayName();
                if (string == null) {
                    DeclareUserVariableFix.$$$reportNull$$$0(5);
                }
                return string;
            }
            SqlBinaryExpression binary = (SqlBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlBinaryExpression.class, (boolean)true, (Class[])new Class[]{SqlStatement.class});
            if (binary != null && DeclareUserVariableFix.isSuitableBinary(sign = binary.getOpSign())) {
                SqlExpression left = binary.getLOperand();
                SqlExpression right = binary.getROperand();
                if (right != null) {
                    SqlExpression other;
                    SqlExpression owner = PsiTreeUtil.isAncestor((PsiElement)left, (PsiElement)element2, (boolean)true) ? left : right;
                    SqlExpression sqlExpression = other = owner == left ? right : left;
                    if (owner.getText().equals(element2.getText())) {
                        String string = other.getSqlType().getDisplayName();
                        if (string == null) {
                            DeclareUserVariableFix.$$$reportNull$$$0(6);
                        }
                        return string;
                    }
                }
            }
            if ("int" == null) {
                DeclareUserVariableFix.$$$reportNull$$$0(7);
            }
            return "int";
        }

        private static boolean isSuitableBinary(IElementType sign) {
            return sign == SqlCommonTokens.SQL_OP_EQ || sign == SqlCommonTokens.SQL_OP_EQEQ || sign == SqlCommonTokens.SQL_OP_NEQ;
        }

        @Nullable
        static String wrapVariableText(SqlIdentifier o) {
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)o);
            Dbms dbms = dialect.getDbms();
            String name = o.getText();
            String type = DeclareUserVariableFix.getTypeString(o);
            if (dbms.isMicrosoft() || dbms.isDb2() || dbms.isSybase()) {
                return "declare " + name + " " + type + ";";
            }
            if ("OracleSqlPlus".equals(dialect.getID())) {
                return "define " + name + ";";
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$DeclareUserVariableFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$DeclareUserVariableFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getTypeString";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DeclarePlVariableFix
    extends SqlEditorAwareFix<SqlIdentifier> {
        protected DeclarePlVariableFix(@Nullable SqlIdentifier element2) {
            super(element2);
        }

        @Override
        @NotNull
        public String getText() {
            if ("Declare PL variable" == null) {
                DeclarePlVariableFix.$$$reportNull$$$0(0);
            }
            return "Declare PL variable";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull SqlIdentifier element2, @Nullable Editor editor) {
            if (project == null) {
                DeclarePlVariableFix.$$$reportNull$$$0(1);
            }
            if (element2 == null) {
                DeclarePlVariableFix.$$$reportNull$$$0(2);
            }
            SqlBlockStatement blockStatement = (SqlBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlBlockStatement.class);
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)element2);
            SqlStatement statement = SqlPsiElementFactory.createStatementFromText(DeclarePlVariableFix.createTemplate(dialect.getDbms(), element2.getText(), DeclareUserVariableFix.getTypeString(element2)), dialect, project, (PsiElement)element2);
            SqlVariableDefinition newDefinition = (SqlVariableDefinition)SqlImplUtil.sqlTraverser((PsiElement)statement).filter(SqlVariableDefinition.class).first();
            assert (newDefinition != null);
            SqlVariableDefinition variableDefinition = (SqlVariableDefinition)SqlImplUtil.sqlChildren((PsiElement)blockStatement).filter(SqlVariableDefinition.class).first();
            if (variableDefinition != null) {
                variableDefinition.getParent().addBefore((PsiElement)newDefinition, (PsiElement)variableDefinition);
                DeclarePlVariableFix.addSemiAndNewlineBefore(project, dialect, (PsiElement)variableDefinition);
                return;
            }
            LeafPsiElement beginKeyword = DeclarePlVariableFix.findChildToken(blockStatement, SqlCommonKeywords.SQL_BEGIN);
            assert (beginKeyword != null);
            LeafPsiElement existingDeclare = DeclarePlVariableFix.findChildToken(blockStatement, SqlCommonKeywords.SQL_DECLARE);
            if (existingDeclare == null) {
                LeafPsiElement declareKeyword = (LeafPsiElement)SqlImplUtil.sqlTraverser((PsiElement)statement).filter(LeafPsiElement.class).filter(e -> e.getElementType() == SqlCommonKeywords.SQL_DECLARE).first();
                assert (declareKeyword != null);
                beginKeyword.getParent().addBefore((PsiElement)declareKeyword, (PsiElement)beginKeyword);
            }
            beginKeyword.getParent().addBefore((PsiElement)newDefinition, (PsiElement)beginKeyword);
            DeclarePlVariableFix.addSemiAndNewlineBefore(project, dialect, (PsiElement)beginKeyword);
        }

        private static void addSemiAndNewlineBefore(@NotNull Project project, @NotNull SqlLanguageDialectEx dialect, @NotNull PsiElement element2) {
            if (project == null) {
                DeclarePlVariableFix.$$$reportNull$$$0(3);
            }
            if (dialect == null) {
                DeclarePlVariableFix.$$$reportNull$$$0(4);
            }
            if (element2 == null) {
                DeclarePlVariableFix.$$$reportNull$$$0(5);
            }
            element2.getParent().addBefore(SqlPsiElementFactory.createLeafFromText(project, dialect, ";"), element2);
            element2.getParent().addBefore(SqlPsiElementFactory.createLeafFromText(project, dialect, "\n"), element2);
        }

        private static LeafPsiElement findChildToken(SqlBlockStatement blockStatement, SqlTokenType tokenType) {
            return (LeafPsiElement)SqlImplUtil.sqlChildren((PsiElement)blockStatement).filter(LeafPsiElement.class).filter(e -> e.getElementType() == tokenType).first();
        }

        static boolean supportsPlSql(@NotNull Dbms dbms) {
            if (dbms == null) {
                DeclarePlVariableFix.$$$reportNull$$$0(6);
            }
            return dbms.isPostgres() || dbms.isOracle();
        }

        private static String createTemplate(Dbms dbms, String name, String type) {
            String common = "DECLARE\n  " + name + " " + type + ";\nBEGIN\nEND";
            if (dbms.isPostgres()) {
                return "DO $$\n" + common + " $$;";
            }
            if (dbms.isOracle()) {
                return common + "/";
            }
            if (dbms.isDb2()) {
                return common;
            }
            throw new NotImplementedError("Not implemented for DBMS: " + dbms.getDisplayName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$DeclarePlVariableFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$DeclarePlVariableFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addSemiAndNewlineBefore";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "supportsPlSql";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AddSqlTableFix
    extends SqlEditorAwareFix<SqlIdentifier> {
        private final boolean myTemporary;

        AddSqlTableFix(SqlIdentifier o, boolean temporary) {
            super(o);
            this.myTemporary = temporary;
        }

        @Override
        @NotNull
        public String getText() {
            String string = SqlMessages.message(this.myTemporary ? "quickfix.name.create.table.declaration" : "quickfix.name.create.table.definition", new Object[0]);
            if (string == null) {
                AddSqlTableFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull SqlIdentifier element2, @Nullable Editor editor) {
            if (project == null) {
                AddSqlTableFix.$$$reportNull$$$0(1);
            }
            if (element2 == null) {
                AddSqlTableFix.$$$reportNull$$$0(2);
            }
            if (editor == null) {
                return;
            }
            SqlStatement placeForInsertBefore = (SqlStatement)PsiTreeUtil.getTopmostParentOfType((PsiElement)element2, SqlStatement.class);
            SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlStatement.class);
            if (statement == null || placeForInsertBefore == null) {
                return;
            }
            LinkedHashSet columnsNames = ContainerUtil.newLinkedHashSet();
            ArrayList columnsTypes = ContainerUtil.newArrayList();
            ArrayList nullableFlags = ContainerUtil.newArrayList();
            SqlResolveInspection.collectColumnNames(element2, statement, columnsNames);
            SqlResolveInspection.collectColumnTypes(statement, columnsTypes, nullableFlags);
            List typesMerged = SqlResolveInspection.mergeTypes(columnsTypes);
            int offset = placeForInsertBefore.getTextRange().getStartOffset();
            TemplateManager templateManager = TemplateManager.getInstance((Project)project);
            Template template = this.getTemplate(templateManager, (PsiElement)element2, columnsNames, typesMerged, nullableFlags);
            if (template == null) {
                return;
            }
            editor.getCaretModel().moveToOffset(offset);
            templateManager.startTemplate(editor, template);
        }

        @Nullable
        private Template getTemplate(@NotNull TemplateManager templateManager, @NotNull PsiElement element2, @NotNull Collection<String> columnsNames, @NotNull List<SqlType> typesMerged, @NotNull List<Boolean> nullableFlags) {
            if (templateManager == null) {
                AddSqlTableFix.$$$reportNull$$$0(3);
            }
            if (element2 == null) {
                AddSqlTableFix.$$$reportNull$$$0(4);
            }
            if (columnsNames == null) {
                AddSqlTableFix.$$$reportNull$$$0(5);
            }
            if (typesMerged == null) {
                AddSqlTableFix.$$$reportNull$$$0(6);
            }
            if (nullableFlags == null) {
                AddSqlTableFix.$$$reportNull$$$0(7);
            }
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(element2);
            if (columnsNames.isEmpty() && !this.myTemporary) {
                TemplateImpl template = TemplateSettings.getInstance().getTemplate("tab", "SQL");
                if (template == null) {
                    return null;
                }
                TemplateImpl copy = template.copy();
                SqlResolveInspection.setVariable(copy, element2.getText(), 0, "table", false);
                return copy;
            }
            Template template = templateManager.createTemplate("", "");
            template.setToReformat(true);
            template.addTextSegment((this.myTemporary ? AddSqlTableFix.createTemporaryTableStart(element2.getText(), dialect.getDbms()) : "create table " + element2.getText()) + " (\n");
            int size = columnsNames.size();
            int i2 = 0;
            for (String name : columnsNames) {
                template.addTextSegment(name);
                template.addTextSegment(" ");
                template.addVariable("type" + i2, (Expression)new ConstantNode(i2 < typesMerged.size() ? SqlResolveInspection.getTypeText(typesMerged.get(i2), dialect.getDbms()) : "int"), true);
                if (!dialect.getDbms().isClickHouse()) {
                    template.addTextSegment(" ");
                    template.addVariable("not_null" + i2, (Expression)new ConstantNode(i2 < nullableFlags.size() && nullableFlags.get(i2) != false ? "null" : "not null"), true);
                }
                if (i2 != size - 1) {
                    template.addTextSegment(",");
                }
                template.addTextSegment("\n");
                ++i2;
            }
            template.addTextSegment(");\n");
            return template;
        }

        @NotNull
        private static String createTemporaryTableStart(String name, @NotNull Dbms dbms) {
            if (dbms == null) {
                AddSqlTableFix.$$$reportNull$$$0(8);
            }
            if (dbms.isMicrosoft()) {
                String string = "declare " + name + " table";
                if (string == null) {
                    AddSqlTableFix.$$$reportNull$$$0(9);
                }
                return string;
            }
            if (dbms.isClickHouse()) {
                String string = "create temporary table " + name;
                if (string == null) {
                    AddSqlTableFix.$$$reportNull$$$0(10);
                }
                return string;
            }
            if (dbms.isDb2() || dbms.isDerby()) {
                String string = "declare global temporary table " + name;
                if (string == null) {
                    AddSqlTableFix.$$$reportNull$$$0(11);
                }
                return string;
            }
            if (dbms.isHsqldb() || dbms.isMysql()) {
                String string = "declare local temporary table " + name;
                if (string == null) {
                    AddSqlTableFix.$$$reportNull$$$0(12);
                }
                return string;
            }
            if (dbms.isOracle()) {
                String string = "create global temporary table " + name;
                if (string == null) {
                    AddSqlTableFix.$$$reportNull$$$0(13);
                }
                return string;
            }
            throw new NotImplementedError("DBMS " + dbms.getDisplayName() + " not supported here");
        }

        static boolean supportsNonVarTemporaryTables(@NotNull Dbms dbms) {
            if (dbms == null) {
                AddSqlTableFix.$$$reportNull$$$0(14);
            }
            return dbms.isClickHouse() || dbms.isDb2() || dbms.isDerby() || dbms.isHsqldb() || dbms.isMysql() || dbms.isOracle();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 14: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 14: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$AddSqlTableFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateManager";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnsNames";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typesMerged";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nullableFlags";
                    break;
                }
                case 8: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$AddSqlTableFix";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTemporaryTableStart";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getTemplate";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createTemporaryTableStart";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "supportsNonVarTemporaryTables";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 14: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AddSqlColumnFix
    extends SqlEditorAwareFix<SqlIdentifier> {
        final SmartPsiElementPointer<SqlCreateTableStatement> myTable;
        final String myTableName;
        final String myColumnName;

        AddSqlColumnFix(@NotNull SqlIdentifier o, @NotNull SqlCreateTableStatement table) {
            if (o == null) {
                AddSqlColumnFix.$$$reportNull$$$0(0);
            }
            if (table == null) {
                AddSqlColumnFix.$$$reportNull$$$0(1);
            }
            super(o);
            this.myTable = SmartPointerManager.getInstance((Project)o.getProject()).createSmartPsiElementPointer((PsiElement)table);
            this.myTableName = table.getName();
            this.myColumnName = o.getName();
        }

        @Override
        @NotNull
        public String getText() {
            String string = "Add column '" + this.myColumnName + "' to '" + this.myTableName + "' table";
            if (string == null) {
                AddSqlColumnFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public void applyFix(final @NotNull Project project, @NotNull SqlIdentifier element2, final @Nullable Editor editor) {
            if (project == null) {
                AddSqlColumnFix.$$$reportNull$$$0(3);
            }
            if (element2 == null) {
                AddSqlColumnFix.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                return;
            }
            SqlCreateTableStatement table = (SqlCreateTableStatement)this.myTable.getElement();
            if (table == null) {
                return;
            }
            PsiColumn last = (PsiColumn)table.getDasChildren(ObjectKind.COLUMN).filter(PsiColumn.class).last();
            int offset = -1;
            boolean insertComma = true;
            if (last == null) {
                ASTNode lParen = table.getNode().findChildByType((IElementType)SqlCommonTokens.SQL_LEFT_PAREN);
                if (lParen != null) {
                    offset = lParen.getTextRange().getEndOffset();
                    insertComma = false;
                }
            } else {
                offset = last.getTextRange().getEndOffset();
            }
            if (offset == -1) {
                return;
            }
            TemplateManager instance = TemplateManager.getInstance((Project)project);
            TemplateImpl template = TemplateSettings.getInstance().getTemplate("col", "SQL");
            if (template == null) {
                return;
            }
            TemplateImpl copy = template.copy();
            SqlResolveInspection.setVariable(copy, element2.getText(), 0, "col", false);
            SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlStatement.class);
            ArrayList columnsTypes = ContainerUtil.newArrayList();
            ArrayList nullableFlags = ContainerUtil.newArrayList();
            SqlResolveInspection.collectColumnTypes(statement, columnsTypes, nullableFlags);
            List typesMerged = SqlResolveInspection.mergeTypes(columnsTypes);
            if (typesMerged.size() > table.getDasChildren(ObjectKind.COLUMN).filter(PsiColumn.class).size()) {
                SqlType lastType = (SqlType)ContainerUtil.getLastItem((List)typesMerged);
                if (lastType != null) {
                    SqlResolveInspection.setVariable(copy, SqlResolveInspection.getTypeText(lastType, SqlImplUtil.getSqlDialectSafe((PsiElement)element2).getDbms()), 1, "type", true);
                }
                if (ContainerUtil.getLastItem((List)nullableFlags) == Boolean.TRUE) {
                    SqlResolveInspection.setVariable(copy, "NULL", 2, "null", true);
                }
            }
            editor.getCaretModel().moveToOffset(offset);
            String newLine = (insertComma ? "," : "") + "\n";
            editor.getDocument().insertString(offset, (CharSequence)newLine);
            editor.getCaretModel().moveToOffset(offset + newLine.length());
            instance.startTemplate(editor, (Template)copy, (TemplateEditingListener)new TemplateEditingAdapter(){

                public void templateFinished(@NotNull Template template, boolean brokenOff) {
                    if (template == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (brokenOff) {
                        return;
                    }
                    PsiFile file = myTable.getContainingFile();
                    Segment range = myTable.getRange();
                    if (file == null || range == null) {
                        return;
                    }
                    PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                    WriteAction.run(() -> {
                        if (project == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        CodeStyleManager.getInstance((Project)project).reformatText(file, range.getStartOffset(), range.getEndOffset());
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "template";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$AddSqlColumnFix$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "templateFinished";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$templateFinished$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$AddSqlColumnFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$AddSqlColumnFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IntrospectSchemaFix
    extends IntentionAndQuickFixAction {
        final List<Pair<DbDataSource, BasicMateNamespace>> myCandidates;
        final String myKindName;

        IntrospectSchemaFix(@NotNull List<Pair<DbDataSource, BasicMateNamespace>> candidates, @NotNull ObjectKind kind) {
            if (candidates == null) {
                IntrospectSchemaFix.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                IntrospectSchemaFix.$$$reportNull$$$0(1);
            }
            this.myCandidates = candidates;
            this.myKindName = StringUtil.capitalize((String)DbPresentation.getPresentableName(kind, DatabaseDialects.getGenericDialect()));
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlMessages.message("sql.quickfix.family", new Object[0]);
            if (string == null) {
                IntrospectSchemaFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = "Introspect " + this.myKindName;
            if (string == null) {
                IntrospectSchemaFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                IntrospectSchemaFix.$$$reportNull$$$0(4);
            }
            if (this.myCandidates.size() <= 1 || ApplicationManager.getApplication().isUnitTestMode()) {
                IntrospectSchemaFix.setVisible(this.myCandidates);
            } else {
                final Set ds = JBIterable.from(this.myCandidates).transform(p2 -> (DbDataSource)p2.first).toSet();
                JBPopupFactory.getInstance().createListPopup((ListPopupStep)new MultiSelectionListPopupStep<Pair<DbDataSource, BasicMateNamespace>>("Add to View", this.myCandidates){

                    public Icon getIconFor(Pair<DbDataSource, BasicMateNamespace> value) {
                        return DbPresentation.getIcon((DasObject)value.second);
                    }

                    @NotNull
                    public String getTextFor(Pair<DbDataSource, BasicMateNamespace> value) {
                        BasicElement parent2 = (BasicElement)ObjectUtils.notNull((Object)((BasicMateNamespace)value.second).getParent());
                        StringBuilder text2 = new StringBuilder();
                        if (ds.size() > 1) {
                            text2.append(((DbDataSource)value.first).getName()).append("\u2006.\u2006");
                        }
                        if (parent2.getKind() != ObjectKind.ROOT) {
                            text2.append(parent2.getName()).append("\u2006.\u2006");
                        }
                        text2.append(((BasicMateNamespace)value.second).getName());
                        String string = text2.toString();
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    public PopupStep<?> onChosen(List<Pair<DbDataSource, BasicMateNamespace>> selectedValues, boolean finalChoice) {
                        IntrospectSchemaFix.setVisible(selectedValues);
                        return FINAL_CHOICE;
                    }

                    public boolean isSpeedSearchEnabled() {
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlResolveInspection$IntrospectSchemaFix$1", "getTextFor"));
                    }
                }).showCenteredInCurrentWindow(project);
            }
        }

        private static void setVisible(List<Pair<DbDataSource, BasicMateNamespace>> selectedValues) {
            MultiMap byDs = MultiMap.create();
            selectedValues.forEach(e -> byDs.putValue(e.first, e.second));
            for (Map.Entry entry : byDs.entrySet()) {
                BasicNamespace item = (BasicNamespace)ContainerUtil.getFirstItem((Collection)((Collection)entry.getValue()));
                if (item == null) continue;
                DataSourceUiUtil.setNamespacesVisible((DbDataSource)entry.getKey(), (Iterable)entry.getValue(), true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidates";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$IntrospectSchemaFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$IntrospectSchemaFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AttachConsoleFix
    extends IntentionAndQuickFixAction {
        private AttachConsoleFix() {
        }

        @NotNull
        public String getName() {
            if ("Attach console" == null) {
                AttachConsoleFix.$$$reportNull$$$0(0);
            }
            return "Attach console";
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlMessages.message("sql.quickfix.family", new Object[0]);
            if (string == null) {
                AttachConsoleFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                AttachConsoleFix.$$$reportNull$$$0(2);
            }
            if (editor == null || !EditorUtil.isRealFileEditor((Editor)editor)) {
                return;
            }
            ChooseConsoleAction action = new ChooseConsoleAction();
            action.actionPerformed(AnActionEvent.createFromAnAction((AnAction)action, null, (String)"unknown", (DataContext)DataManager.getInstance().getDataContext((Component)editor.getContentComponent())));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$AttachConsoleFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$AttachConsoleFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class GoToResolutionScopesFix
    extends IntentionAndQuickFixAction {
        private GoToResolutionScopesFix() {
        }

        @NotNull
        public String getName() {
            if ("Go to SQL Resolution Scopes" == null) {
                GoToResolutionScopesFix.$$$reportNull$$$0(0);
            }
            return "Go to SQL Resolution Scopes";
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlMessages.message("sql.quickfix.family", new Object[0]);
            if (string == null) {
                GoToResolutionScopesFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                GoToResolutionScopesFix.$$$reportNull$$$0(2);
            }
            SqlResolveConfigurable.openResolveScopesConfigurable(project, SqlImplUtil.getTopLevelFile(file));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlResolveInspection$GoToResolutionScopesFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlResolveInspection$GoToResolutionScopesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

