/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.run.ui.GridSelectionGrowerStrategy;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.grid.GridSelection;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

class GridSelectionGrower {
    private final TableResultPanel myPanel;
    private boolean myAdjusting;
    private GridSelection myPrevious;

    GridSelectionGrower(@NotNull TableResultPanel panel) {
        if (panel == null) {
            GridSelectionGrower.$$$reportNull$$$0(0);
        }
        this.myPanel = panel;
    }

    void growSelection() {
        if (this.myAdjusting) {
            return;
        }
        try {
            this.myAdjusting = true;
            this.growSelectionInternal();
        }
        finally {
            this.myAdjusting = false;
        }
    }

    void reset() {
        if (this.myAdjusting) {
            return;
        }
        this.myPrevious = null;
    }

    private void growSelectionInternal() {
        GridSelectionGrowerStrategy grower = GridSelectionGrowerStrategy.of(this.myPanel);
        if (grower == null) {
            return;
        }
        if (grower.isNeedRestore() && this.myPrevious != null) {
            this.restore();
        }
        this.myPrevious = grower.isNeedStore() ? GridSelection.store((JTable)((Object)this.myPanel.getTable())) : null;
        grower.changeSelection(this.myPanel);
    }

    private void restore() {
        this.myPanel.getAutoscrollLocker().runWithLock(() -> this.myPrevious.restore((JTable)((Object)this.myPanel.getTable())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/database/run/ui/GridSelectionGrower", "<init>"));
    }
}

