/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.naming;

import b.h.la;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.motion.RubyMotionUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyRenameFix;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.ConventionInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.e;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.search.overriden.RubySuperMethodsSearch;

public class RubyClassMethodNamingConventionInspection
extends ConventionInspection {
    private static final int d = 2;
    private static final int c = 30;
    private static final long e = la.a(-8353441287561483054L, 7705251718466919733L, MethodHandles.lookup().lookupClass()).a(50687146198322L);

    @Override
    protected String getDefaultRegex() {
        long l2 = e ^ 0x5DDC7A4D4761L;
        return TextUtil.IDENTIFIER_LOWERCASE_PATTERN.pattern() + "[!?=]?|\\[\\]=?";
    }

    @Override
    protected String getMotionDefaultRegex() {
        return RubyMotionUtil.getInstance().getRubyMotionIdentifierRegex();
    }

    @Override
    protected int getDefaultMinLength() {
        return 2;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 30;
    }

    @Override
    protected RubyFix buildFix(PsiElement location) {
        return new RubyRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        long l2 = e ^ 0xB0A7BCDD150L;
        if ("Class method naming convention" == null) {
            RubyClassMethodNamingConventionInspection.d(0);
        }
        return "Class method naming convention";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        long l2 = e ^ 0x519D5FA6828L;
        String string = (String)args[0];
        if (string.length() < this.getMinLength()) {
            if ("Class method name '#ref' is too short" == null) {
                RubyClassMethodNamingConventionInspection.d(1);
            }
            return "Class method name '#ref' is too short";
        }
        if (string.length() > this.getMaxLength()) {
            if ("Class method name '#ref' is too long" == null) {
                RubyClassMethodNamingConventionInspection.d(2);
            }
            return "Class method name '#ref' is too long";
        }
        String string2 = "Class method name '#ref' doesn't match regex '" + this.getRegex() + "' #loc";
        if (string2 == null) {
            RubyClassMethodNamingConventionInspection.d(3);
        }
        return string2;
    }

    @Override
    public RubyInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor(null);
    }

    private static /* synthetic */ void d(int n2) {
        Object[] objectArray;
        long l2 = e ^ 0x53842904B031L;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/inspections/naming/RubyClassMethodNamingConventionInspection";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NamingConventionsVisitor
    extends RubyInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitRMethod(RMethod rMethod) {
            if (PsiTreeUtil.getParentOfType((PsiElement)rMethod, RContainer.class) instanceof RObjectClass) {
                this.a(rMethod);
            }
        }

        @Override
        public void visitRSingletonMethod(RSingletonMethod rsMethod) {
            this.a((RMethod)rsMethod);
        }

        private void a(RMethod rMethod) {
            String string = rMethod.getName();
            if (RubyClassMethodNamingConventionInspection.this.isValid(string, (PsiElement)rMethod) || RubySuperMethodsSearch.search(rMethod).findFirst() != null) {
                return;
            }
            this.registerMethodError(rMethod, string);
        }

        /* synthetic */ NamingConventionsVisitor(e x1) {
            this();
        }
    }
}

