/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model;

import b.h.la;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.BaseRailsFacetConfiguration;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.rails.facet.versions.BaseRailsFacet;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsHelper;
import org.jetbrains.plugins.ruby.rails.model.RailsModel;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.utils.NamingConventions;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

public class RailsApp {
    private final Module a;
    private final BaseRailsFacet b;
    private static final long c = la.a(113609596102683299L, 6563094223429337390L, MethodHandles.lookup().lookupClass()).a(41207564184661L);

    private RailsApp(@NotNull Module module, BaseRailsFacet facet) {
        if (module == null) {
            RailsApp.a(0);
        }
        this.a = module;
        this.b = facet;
    }

    public Project getProject() {
        return this.a.getProject();
    }

    @Nullable
    public static RailsApp fromFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            RailsApp.a(1);
        }
        if (file == null) {
            RailsApp.a(2);
        }
        return RailsApp.fromModule(ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project));
    }

    @Contract(value="null -> null")
    @Nullable
    public static RailsApp fromModule(@Nullable Module module) {
        BaseRailsFacet baseRailsFacet;
        if (module != null && (baseRailsFacet = BaseRailsFacet.getInstance(module)) != null) {
            return new RailsApp(module, baseRailsFacet);
        }
        return null;
    }

    @NotNull
    public Module getModule() {
        Module module = this.a;
        if (module == null) {
            RailsApp.a(3);
        }
        return module;
    }

    @NotNull
    public StandardRailsPaths getPaths() {
        StandardRailsPaths standardRailsPaths = ((BaseRailsFacetConfiguration)this.b.getConfiguration()).getPaths();
        if (standardRailsPaths == null) {
            RailsApp.a(4);
        }
        return standardRailsPaths;
    }

    public boolean isAppFile(PsiFile file) {
        return this.isAppFile(file.getVirtualFile());
    }

    public boolean isAppFile(VirtualFile file) {
        return RailsApp.a(RailsUtil.getAppRoot(this.a), file);
    }

    public boolean isVendorFile(PsiFile file) {
        return this.isVendorFile(file.getVirtualFile());
    }

    public boolean isVendorFile(VirtualFile file) {
        return RailsApp.a(RailsUtil.getVendorRoot(this.a), file);
    }

    public boolean isVendorGemFile(PsiFile file) {
        return this.isVendorGemFile(RubyPsiUtil.getVirtualFileFromElement((PsiElement)file));
    }

    public boolean isVendorGemFile(VirtualFile file) {
        return RailsApp.a(this.getVendorGemsRoot(), file);
    }

    public boolean isEdgeRailsFile(PsiFile file) {
        return this.isEdgeRailsFile(file.getVirtualFile());
    }

    public boolean isEdgeRailsFile(VirtualFile file) {
        VirtualFile virtualFile = RailsUtil.getEdgeRailsRoot(this.a);
        return RailsApp.a(virtualFile, file);
    }

    public boolean isTestFile(PsiFile file) {
        return this.isTestFile(file.getVirtualFile());
    }

    public boolean isTestFile(VirtualFile vFile) {
        return RailsApp.a(this.getUTestsRoot(), vFile) || RailsApp.a(this.getSpecTestsRoot(), vFile) || RailsApp.a(this.getFeaturesRoot(), vFile);
    }

    public boolean isInAppFile(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        return psiFile != null && this.isAppFile(psiFile);
    }

    public boolean isMigration(VirtualFile file) {
        VirtualFile virtualFile = this.getMigrationsRoot();
        return virtualFile != null && VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)file, (boolean)true);
    }

    @Nullable
    public static RailsApp fromPsiElement(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            RailsApp.a(5);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            return null;
        }
        return RailsApp.fromModule(module);
    }

    @Nullable
    public RailsHelper findHelper(String helperFullQualifiedName) {
        long l2 = c ^ 0x51AE26B04BA8L;
        VirtualFile virtualFile = this.getHelpersRoot();
        String string = this.appendProjectPrefix(helperFullQualifiedName) + "_helper.rb";
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile.findFileByRelativePath(string);
        if (virtualFile2 != null) {
            return RailsHelper.fromFile(this.a, virtualFile2);
        }
        return null;
    }

    public boolean processModels(@NotNull Processor<RailsModel> processor) {
        VirtualFile virtualFile2;
        if (processor == null) {
            RailsApp.a(6);
        }
        if ((virtualFile2 = this.getModelsRoot()) == null) {
            return true;
        }
        return VfsUtilCore.processFilesRecursively((VirtualFile)virtualFile2, virtualFile -> {
            RailsModel railsModel;
            if (processor == null) {
                RailsApp.a(15);
            }
            ProgressManager.checkCanceled();
            return virtualFile.isDirectory() || !RubyVirtualFileScanner.isRubyFile(virtualFile) || (railsModel = RailsModel.fromFile(this.getModule(), virtualFile)) == null || processor.process((Object)railsModel);
        });
    }

    public List<RailsHelper> getAllHelpers() {
        ArrayList<RailsHelper> arrayList = new ArrayList<RailsHelper>();
        VirtualFile virtualFile = this.getHelpersRoot();
        if (virtualFile != null) {
            ArrayList arrayList2 = new ArrayList();
            RubyVirtualFileScanner.addRubyFiles(virtualFile, arrayList2);
            for (VirtualFile virtualFile2 : arrayList2) {
                RailsHelper railsHelper = RailsHelper.fromFile(this.a, virtualFile2);
                if (railsHelper == null) continue;
                arrayList.add(railsHelper);
            }
        }
        return arrayList;
    }

    @Nullable
    public RailsModel findModelByName(String qualifiedModelName) {
        long l2 = c ^ 0x1BB65AC57565L;
        VirtualFile virtualFile = this.getModelsRoot();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile.findFileByRelativePath(this.appendProjectPrefix(qualifiedModelName) + ".rb");
        if (virtualFile2 != null) {
            return RailsModel.fromFile(this.a, virtualFile2);
        }
        return null;
    }

    @Nullable
    public RailsHelper getApplicationHelper() {
        long l2 = c ^ 0x6A1B754CB214L;
        return this.findHelper("application");
    }

    @Nullable
    public VirtualFile getDBSchemaFile() {
        return RailsApp.c(this.getPaths().getDbSchemaURL());
    }

    @Nullable
    public VirtualFile getDBSeedsFile() {
        return RailsApp.c(this.getPaths().getDbSeedsURL());
    }

    @Deprecated
    @Nullable
    public VirtualFile getRoutesFile() {
        RoutesFiles<VirtualFile> routesFiles = this.getRoutesFiles();
        return !routesFiles.isEmpty() ? routesFiles.getMainRoutesFile() : null;
    }

    @NotNull
    public RoutesFiles<VirtualFile> getRoutesFiles() {
        RoutesFiles routesFiles = (RoutesFiles)CachedValuesManager.getManager((Project)this.getProject()).getCachedValue((UserDataHolder)this.a, () -> CachedValueProvider.Result.create(this.a(), (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS}));
        if (routesFiles == null) {
            RailsApp.a(7);
        }
        return routesFiles;
    }

    @Nullable
    public RailsController getApplicationController() {
        long l2 = c ^ 0xA5E16A8BBAL;
        return this.findController("application");
    }

    @Nullable
    public VirtualFile getApplicationFile() {
        PsiFile[] psiFileArray;
        long l2 = c ^ 0x5747CDB2FB8AL;
        String string = this.getApplicationFileUrl();
        if (string == null) {
            return null;
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(string);
        if (virtualFile != null) {
            return virtualFile;
        }
        VirtualFile virtualFile2 = this.getAppRoot();
        VirtualFile virtualFile3 = virtualFile2 != null ? GemUtil.getSpecFile(virtualFile2.getParent()) : null;
        VirtualFile virtualFile4 = this.getLibsRoot();
        if (virtualFile3 != null && virtualFile4 != null && (psiFileArray = FilenameIndex.getFilesByName((Project)this.getProject(), (String)"engine.rb", (GlobalSearchScope)GlobalSearchScopesCore.directoryScope((Project)this.getProject(), (VirtualFile)virtualFile4, (boolean)true))).length > 0) {
            return psiFileArray[0].getVirtualFile();
        }
        return null;
    }

    @Nullable
    public String getApplicationFileUrl() {
        String string = RailsFacetUtil.getRailsAppHomeDirPathUrl(this.a);
        if (string == null) {
            return null;
        }
        return StandardRailsPaths.buildApplicationRbUrl(string);
    }

    @Nullable
    public String getProjectName() {
        BaseRailsFacet baseRailsFacet = BaseRailsFacet.getInstance(this.a);
        return baseRailsFacet != null ? baseRailsFacet.getProjectName() : null;
    }

    @Nullable
    public String getProjectPrefix() {
        return this.isEngine() ? NamingConventions.toUnderscoreCase(this.getProjectName()) + "/" : "";
    }

    public String appendProjectPrefix(String qualifiedName) {
        String string = this.getProjectPrefix();
        return qualifiedName.startsWith(string) ? qualifiedName : string + qualifiedName;
    }

    @Nullable
    public RailsController findController(String qualifiedName) {
        return RailsController.fromQualifiedName(this.a, qualifiedName);
    }

    @Nullable
    public VirtualFile getControllersRoot() {
        return RailsUtil.getControllersRoot(this.a);
    }

    @Nullable
    public VirtualFile getHelpersRoot() {
        return RailsUtil.getHelpersRoot(this.a);
    }

    @Nullable
    public VirtualFile getAssetsRoot() {
        return RailsUtil.getAssetsRoot(this.a);
    }

    @Nullable
    public VirtualFile getInitializersRoot() {
        return VirtualFileManager.getInstance().findFileByUrl(this.getInitializersRootUrl());
    }

    @NotNull
    public String getInitializersRootUrl() {
        String string = this.getPaths().getInitializersRootUrl();
        if (string == null) {
            RailsApp.a(8);
        }
        return string;
    }

    @Nullable
    public VirtualFile getModelsRoot() {
        return RailsApp.c(this.getPaths().getModelsRootURL());
    }

    @Nullable
    public VirtualFile getMailersRoot() {
        return RailsApp.c(this.getPaths().getMailersRootURL());
    }

    @Nullable
    public VirtualFile getConfigRoot() {
        return RailsApp.c(this.getPaths().getConfigRootURL());
    }

    @Nullable
    public VirtualFile getViewsRoot() {
        return RailsApp.c(this.getPaths().getViewsRootURL());
    }

    @Nullable
    public VirtualFile getVendorRoot() {
        return RailsApp.c(this.getPaths().getVendorRootURL());
    }

    @Nullable
    public VirtualFile getVendorGemsRoot() {
        long l2 = c ^ 0x31C0E6B483D4L;
        return RailsApp.a("gems", this.getVendorRoot());
    }

    @Nullable
    public VirtualFile getLayoutsRoot() {
        return RailsApp.c(this.getPaths().getLayoutsRootURL());
    }

    @Nullable
    public VirtualFile getLibsRoot() {
        return RailsApp.c(this.getPaths().getLibsRootURL());
    }

    @Nullable
    public VirtualFile getRailsApplicationRoot() {
        return RailsApp.c(this.getPaths().getRailsApplicationHomeURL());
    }

    @Nullable
    public VirtualFile getAppRoot() {
        return RailsUtil.getAppRoot(this.a);
    }

    @Nullable
    public VirtualFile getDBRoot() {
        return RailsApp.c(this.getPaths().getDbRootURL());
    }

    @Nullable
    public VirtualFile getMigrationsRoot() {
        return RailsApp.c(this.getPaths().getMigrationsRootURL());
    }

    @Nullable
    public VirtualFile getPluginsRoot() {
        return RailsApp.c(this.getPaths().getPluginsRootURL());
    }

    @Nullable
    public VirtualFile getUTestsRoot() {
        return RailsApp.c(this.getPaths().getTestsStdUnitRootURL());
    }

    @Nullable
    public VirtualFile getUTestsHelpersRoot() {
        long l2 = c ^ 0x15807A70243DL;
        return RailsApp.a("helpers", this.a("unit"));
    }

    @Nullable
    public VirtualFile getSpecTestsRoot() {
        return RailsApp.c(this.getPaths().getTestsSpecRootURL());
    }

    @Nullable
    public VirtualFile getFeaturesRoot() {
        long l2 = c ^ 0x2486905FCD2BL;
        return RailsApp.a("features", this.getRailsApplicationRoot());
    }

    @Nullable
    public String getLogsPath() {
        long l2 = c ^ 0x24BB393CEB4BL;
        String string = VirtualFileUtil.buildUrl(this.getPaths().getRailsApplicationHomeURL(), "log");
        return VfsUtilCore.urlToPath((String)string);
    }

    @Nullable
    public VirtualFile getPublicRoot() {
        return RailsApp.c(this.getPaths().getPublicRootURL());
    }

    @Nullable
    public VirtualFile getFunctionalTestsRoot() {
        long l2 = c ^ 0x7EE18DD6A8CCL;
        return this.a("functional");
    }

    @Nullable
    public VirtualFile getUnitTestsRoot() {
        long l2 = c ^ 0x12627308CEECL;
        return this.a("unit");
    }

    @Nullable
    public VirtualFile getSpecTestsModelsRoot() {
        long l2 = c ^ 0x745EF1A51F34L;
        return this.b("models");
    }

    @Nullable
    public VirtualFile getSpecTestsViewsRoot() {
        long l2 = c ^ 0x1ED20A145510L;
        return this.b("views");
    }

    @Nullable
    public VirtualFile getSpecTestsHelpersRoot() {
        long l2 = c ^ 0x6253B5CC7D8BL;
        return this.b("helpers");
    }

    @Nullable
    public VirtualFile getSpecTestsControllersRoot() {
        long l2 = c ^ 0x22C001E74EE9L;
        return this.b("controllers");
    }

    @Nullable
    public VirtualFile getIntegrationTestRoot() {
        long l2 = c ^ 0x63729BF52E8CL;
        return this.a("integration");
    }

    @NotNull
    public List<VirtualFile> getImplicitModuleDirectoryRoots() {
        List<VirtualFile> list2 = Arrays.asList(RailsUtil.getControllersRoot(this.a), RailsUtil.getModelsRoot(this.a), RailsUtil.getServicesRoot(this.a));
        if (list2 == null) {
            RailsApp.a(9);
        }
        return list2;
    }

    @Nullable
    private VirtualFile a(String string) {
        return RailsApp.a(string, this.getUTestsRoot());
    }

    @Nullable
    private VirtualFile b(String string) {
        return RailsApp.a(string, this.getSpecTestsRoot());
    }

    @Nullable
    private static VirtualFile c(String string) {
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Nullable
    private static VirtualFile a(String string, VirtualFile virtualFile) {
        if (virtualFile != null) {
            return virtualFile.findChild(string);
        }
        return null;
    }

    @Nullable
    public VirtualFile getEnvironmentsRoot() {
        long l2 = c ^ 0x3D077418EF96L;
        VirtualFile virtualFile = RailsUtil.getConfigRoot(this.a);
        if (virtualFile != null) {
            return virtualFile.findChild("environments");
        }
        return null;
    }

    private static boolean a(@Nullable VirtualFile virtualFile, @NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            RailsApp.a(10);
        }
        return virtualFile != null && VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)virtualFile2, (boolean)true);
    }

    public static boolean isRails3App(Module module) {
        long l2 = c ^ 0x61A0E2CF531EL;
        GemInfo gemInfo = module != null ? GemManager.findGem(module, "rails") : null;
        return gemInfo != null && RailsUtil.isRails30OrHigher(gemInfo.getRealVersion());
    }

    public static boolean isRails5App(Module module) {
        long l2 = c ^ 0x1919FC51AF9L;
        GemInfo gemInfo = module != null ? GemManager.findGem(module, "rails") : null;
        return gemInfo != null && RailsUtil.isRails5OrHigher(gemInfo.getRealVersion());
    }

    public boolean isRails3App() {
        return RailsApp.isRails3App(this.a);
    }

    public boolean isRails5App() {
        return RailsApp.isRails5App(this.a);
    }

    public boolean isEngine() {
        long l2 = c ^ 0x704E655E3085L;
        VirtualFile virtualFile = this.getApplicationFile();
        return virtualFile != null && !"application.rb".equals(virtualFile.getName());
    }

    public boolean isApi() {
        PsiFile psiFile;
        long l2 = c ^ 0x5BB6EFF23EE2L;
        VirtualFile virtualFile = this.getApplicationFile();
        if (virtualFile != null && (psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(virtualFile)) != null) {
            return psiFile.getText().contains("config.api_only = true");
        }
        return false;
    }

    @NotNull
    private RoutesFiles<VirtualFile> a() {
        long l2 = c ^ 0x76F528CD2E82L;
        VirtualFile virtualFile2 = RailsUtil.getConfigRoot(this.a);
        if (virtualFile2 == null) {
            RoutesFiles<VirtualFile> routesFiles = RoutesFiles.empty();
            if (routesFiles == null) {
                RailsApp.a(11);
            }
            return routesFiles;
        }
        VirtualFile virtualFile3 = virtualFile2.findChild("routes.rb");
        if (virtualFile3 == null) {
            RoutesFiles<VirtualFile> routesFiles = RoutesFiles.empty();
            if (routesFiles == null) {
                RailsApp.a(12);
            }
            return routesFiles;
        }
        VirtualFile virtualFile4 = virtualFile2.findChild("routes");
        if (virtualFile4 == null || !virtualFile4.isDirectory()) {
            RoutesFiles<VirtualFile> routesFiles = RoutesFiles.create(virtualFile3, Collections.emptySet());
            if (routesFiles == null) {
                RailsApp.a(13);
            }
            return routesFiles;
        }
        RoutesFiles<VirtualFile> routesFiles = RoutesFiles.create(virtualFile3, Stream.of(virtualFile4.getChildren()).filter(virtualFile -> {
            long l2 = c ^ 0x101B6BEB94E8L;
            return "rb".equals(virtualFile.getExtension());
        }).collect(Collectors.toSet()));
        if (routesFiles == null) {
            RailsApp.a(14);
        }
        return routesFiles;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x103E7CF91D1FL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/model/RailsApp";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/RailsApp";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaths";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoutesFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializersRootUrl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitModuleDirectoryRoots";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRoutesFiles";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromFile";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromPsiElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processModels";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isNotNullAncestor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processModels$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RoutesFiles<T> {
        private static final RoutesFiles a;
        @Nullable
        T myMainRoutesFile;
        @NotNull
        Collection<T> myAdditionalRoutesFiles;
        private static final long b;

        private RoutesFiles(@Nullable T mainRoutesFile, @NotNull Collection<T> additionalRoutesFiles) {
            if (additionalRoutesFiles == null) {
                RoutesFiles.a(0);
            }
            this.myMainRoutesFile = mainRoutesFile;
            this.myAdditionalRoutesFiles = additionalRoutesFiles;
        }

        @NotNull
        public T getMainRoutesFile() {
            long l2 = b ^ 0x62F56EF45074L;
            if (this.myMainRoutesFile == null) {
                throw new IllegalStateException("Please check for emptyness before");
            }
            T t2 = this.myMainRoutesFile;
            if (t2 == null) {
                RoutesFiles.a(1);
            }
            return t2;
        }

        @NotNull
        public Collection<T> getAdditionalRoutesFiles() {
            Collection<T> collection = this.myAdditionalRoutesFiles;
            if (collection == null) {
                RoutesFiles.a(2);
            }
            return collection;
        }

        @NotNull
        public Stream<T> allFiles() {
            StreamEx streamEx = StreamEx.of(this.myAdditionalRoutesFiles).prepend(this.myMainRoutesFile);
            if (streamEx == null) {
                RoutesFiles.a(3);
            }
            return streamEx;
        }

        public boolean contains(@Nullable T file) {
            return Comparing.equal(file, this.myMainRoutesFile) || this.myAdditionalRoutesFiles.contains(file);
        }

        public boolean isEmpty() {
            return this == a;
        }

        @NotNull
        public <V> RoutesFiles<V> toType(@NotNull NullableFunction<? super T, V> mappingFunction) {
            if (mappingFunction == null) {
                RoutesFiles.a(4);
            }
            if (this == a) {
                RoutesFiles<T> routesFiles = RoutesFiles.empty();
                if (routesFiles == null) {
                    RoutesFiles.a(5);
                }
                return routesFiles;
            }
            Object object = mappingFunction.fun(this.myMainRoutesFile);
            if (object == null) {
                RoutesFiles<T> routesFiles = RoutesFiles.empty();
                if (routesFiles == null) {
                    RoutesFiles.a(6);
                }
                return routesFiles;
            }
            RoutesFiles<Object> routesFiles = RoutesFiles.create(object, ContainerUtil.mapNotNull(this.myAdditionalRoutesFiles, mappingFunction));
            if (routesFiles == null) {
                RoutesFiles.a(7);
            }
            return routesFiles;
        }

        @NotNull
        public static <T> RoutesFiles<T> create(@NotNull T mainRoutesFile, @NotNull Collection<T> additionalRoutesFiles) {
            if (mainRoutesFile == null) {
                RoutesFiles.a(8);
            }
            if (additionalRoutesFiles == null) {
                RoutesFiles.a(9);
            }
            RoutesFiles<T> routesFiles = new RoutesFiles<T>(mainRoutesFile, additionalRoutesFiles);
            if (routesFiles == null) {
                RoutesFiles.a(10);
            }
            return routesFiles;
        }

        @NotNull
        public static <T> RoutesFiles<T> empty() {
            RoutesFiles routesFiles = a;
            if (routesFiles == null) {
                RoutesFiles.a(11);
            }
            return routesFiles;
        }

        static {
            b = la.a(7712677771417219749L, -467336862591839168L, MethodHandles.lookup().lookupClass()).a(238149179523607L);
            a = new RoutesFiles<Object>(null, Collections.emptySet());
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = b ^ 0x4E8313618B6BL;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 10: 
                case 11: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "additionalRoutesFiles";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/rails/model/RailsApp$RoutesFiles";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mappingFunction";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mainRoutesFile";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/RailsApp$RoutesFiles";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMainRoutesFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAdditionalRoutesFiles";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "allFiles";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toType";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "empty";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 10: 
                case 11: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "toType";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

