/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.tools;

import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteConnectionType;
import com.intellij.tools.BaseToolManager;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolsGroup;
import com.intellij.tools.ToolsProcessor;
import com.jetbrains.plugins.remotesdk.tools.RemoteTool;
import org.jdom.Element;

public class RemoteToolManager
extends BaseToolManager<RemoteTool> {
    private static final String CONNECTION_TYPE = "CONNECTION_TYPE";
    private static final String CONNECTION_ID = "CONNECTION_ID";

    public RemoteToolManager(ActionManagerEx actionManagerEx, SchemeManagerFactory factory) {
        super(actionManagerEx, factory, "remoteTools", "Remote Tools");
    }

    protected SchemeProcessor<ToolsGroup<RemoteTool>, ToolsGroup<RemoteTool>> createProcessor() {
        return new ToolsProcessor<RemoteTool>(){

            protected ToolsGroup<RemoteTool> createToolsGroup(String groupName) {
                return new ToolsGroup(groupName);
            }

            protected RemoteTool createTool() {
                return new RemoteTool();
            }

            protected void readToolAttributes(Element element, RemoteTool tool) {
                super.readToolAttributes(element, (Tool)tool);
                tool.setConnectionType(RemoteConnectionType.findByName((String)element.getAttributeValue(RemoteToolManager.CONNECTION_TYPE)));
                tool.setConnectionId(BaseToolManager.convertString((String)element.getAttributeValue(RemoteToolManager.CONNECTION_ID)));
            }

            protected void saveToolAttributes(RemoteTool tool, Element element) {
                String connectionTypeName;
                super.saveToolAttributes((Tool)tool, element);
                RemoteConnectionType connectionType = tool.getConnectionType();
                String string = connectionTypeName = connectionType == null ? null : connectionType.name();
                if (!StringUtil.isEmpty((String)connectionTypeName)) {
                    element.setAttribute(RemoteToolManager.CONNECTION_TYPE, connectionTypeName);
                }
                if (!StringUtil.isEmpty((String)tool.getConnectionId())) {
                    element.setAttribute(RemoteToolManager.CONNECTION_ID, tool.getConnectionId());
                }
            }
        };
    }

    protected String getActionIdPrefix() {
        return "RemoteTool_";
    }

    public static RemoteToolManager getInstance() {
        return (RemoteToolManager)((Object)ApplicationManager.getApplication().getComponent(RemoteToolManager.class));
    }
}

