/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0015\u0010\u0000\u001a\u00020\u0001\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003H\u0086\b\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u001a-\u0010\b\u001a\u00020\t*\u00020\u00012\u0010\b\u0002\u0010\n\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0086\b\u001a-\u0010\u000f\u001a\u00020\t*\u00020\u00012\u0010\b\u0002\u0010\n\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0086\b\u001a(\u0010\u0010\u001a\u0004\u0018\u0001H\u0002\"\u0004\b\u0000\u0010\u0002*\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000eH\u0086\b\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "T", "", "category", "", "field", "Lkotlin/reflect/KProperty;", "debug", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "lazyMessage", "Lkotlin/Function0;", "debugOrInfoIfTestMode", "runAndLogException", "runnable", "(Lcom/intellij/openapi/diagnostic/Logger;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.platform.projectModel"})
public final class LoggerKt {
    private static final <T> Logger logger() {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Logger logger = Logger.getInstance(Object.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        return logger;
    }

    @NotNull
    public static final Logger logger(@NotNull String category) {
        Intrinsics.checkParameterIsNotNull((Object)category, (String)"category");
        Logger logger = Logger.getInstance((String)category);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(category)");
        return logger;
    }

    @NotNull
    public static final Logger logger(@NotNull KProperty<? extends Logger> field) {
        Intrinsics.checkParameterIsNotNull(field, (String)"field");
        Method method = ReflectJvmMapping.getJavaGetter(field);
        if (method == null) {
            Intrinsics.throwNpe();
        }
        Logger logger = Logger.getInstance(method.getDeclaringClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(field\u2026aGetter!!.declaringClass)");
        return logger;
    }

    public static final void debug(@NotNull Logger $receiver, @Nullable Exception e, @NotNull Function0<String> lazyMessage) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(lazyMessage, (String)"lazyMessage");
        if ($receiver.isDebugEnabled()) {
            $receiver.debug((String)lazyMessage.invoke(), (Throwable)e);
        }
    }

    public static /* synthetic */ void debug$default(Logger $receiver, Exception e, Function0 lazyMessage, int n, Object object) {
        if ((n & 1) != 0) {
            e = null;
        }
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)lazyMessage, (String)"lazyMessage");
        if ($receiver.isDebugEnabled()) {
            $receiver.debug((String)lazyMessage.invoke(), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void debugOrInfoIfTestMode(@NotNull Logger $receiver, @Nullable Exception e, @NotNull Function0<String> lazyMessage) {
        Logger $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(lazyMessage, (String)"lazyMessage");
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            if (application.isUnitTestMode()) {
                $receiver.info((String)lazyMessage.invoke());
                return;
            }
        }
        if (!($receiver$iv = $receiver).isDebugEnabled()) return;
        $receiver$iv.debug((String)lazyMessage.invoke(), (Throwable)e);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static /* synthetic */ void debugOrInfoIfTestMode$default(Logger $receiver, Exception e, Function0 lazyMessage, int n, Object object) {
        Logger $receiver$iv;
        if ((n & 1) != 0) {
            e = null;
        }
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)lazyMessage, (String)"lazyMessage");
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            if (application.isUnitTestMode()) {
                $receiver.info((String)lazyMessage.invoke());
                return;
            }
        }
        if (!($receiver$iv = $receiver).isDebugEnabled()) return;
        $receiver$iv.debug((String)lazyMessage.invoke(), (Throwable)e);
    }

    @Nullable
    public static final <T> T runAndLogException(@NotNull Logger $receiver, @NotNull Function0<? extends T> runnable) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(runnable, (String)"runnable");
        try {
            return (T)runnable.invoke();
        }
        catch (ProcessCanceledException e) {
            return null;
        }
        catch (Throwable e) {
            $receiver.error(e);
            return null;
        }
    }
}

