/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.BasicAttributeValueReference;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrefixReferenceProvider
extends PsiReferenceProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.intellij.plugins.relaxNG.references.PrefixReferenceProvider");

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        XmlAttributeValue value;
        String s;
        int i;
        if (element == null) {
            PrefixReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PrefixReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((i = (s = (value = (XmlAttributeValue)element).getValue()).indexOf(58)) <= 0 || s.startsWith("xml:")) {
            if (PsiReference.EMPTY_ARRAY == null) {
                PrefixReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new PrefixReference(value, i)};
        if (psiReferenceArray == null) {
            PrefixReferenceProvider.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/references/PrefixReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/references/PrefixReferenceProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PrefixReference
    extends BasicAttributeValueReference
    implements EmptyResolveMessageProvider,
    LocalQuickFixProvider {
        PrefixReference(XmlAttributeValue value, int length) {
            super((PsiElement)value, TextRange.from((int)1, (int)length));
        }

        @Nullable
        public PsiElement resolve() {
            String prefix = this.getCanonicalText();
            for (XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlTag.class); tag != null; tag = tag.getParentTag()) {
                if (!tag.getLocalNamespaceDeclarations().containsKey(prefix)) continue;
                XmlAttribute attribute = tag.getAttribute("xmlns:" + prefix, "");
                TextRange textRange = TextRange.from((int)"xmlns:".length(), (int)prefix.length());
                return new SchemaPrefix(attribute, textRange, prefix);
            }
            return null;
        }

        @Override
        public boolean isReferenceTo(@NotNull PsiElement element) {
            PsiElement e;
            if (element == null) {
                PrefixReference.$$$reportNull$$$0(0);
            }
            if (element instanceof SchemaPrefix && element.getContainingFile() == this.myElement.getContainingFile() && (e = this.resolve()) instanceof SchemaPrefix) {
                String s = ((SchemaPrefix)e).getName();
                return s != null && s.equals(((SchemaPrefix)element).getName());
            }
            return super.isReferenceTo(element);
        }

        @Nullable
        public LocalQuickFix[] getQuickFixes() {
            PsiElement element = this.getElement();
            XmlElementFactory factory = XmlElementFactory.getInstance((Project)element.getProject());
            String value = ((XmlAttributeValue)element).getValue();
            String[] name = value.split(":");
            XmlTag tag = factory.createTagFromText((CharSequence)("<" + (name.length > 1 ? name[1] : value) + " />"), (Language)XMLLanguage.INSTANCE);
            return new LocalQuickFix[]{XmlQuickFixFactory.getInstance().createNSDeclarationIntentionFix((PsiElement)tag, this.getCanonicalText(), null)};
        }

        public boolean isSoft() {
            return false;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            if ("Undefined namespace prefix ''{0}''" == null) {
                PrefixReference.$$$reportNull$$$0(1);
            }
            return "Undefined namespace prefix ''{0}''";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/relaxNG/references/PrefixReferenceProvider$PrefixReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/relaxNG/references/PrefixReferenceProvider$PrefixReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

