/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.psi.impl;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Set;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncDefine;
import org.intellij.plugins.relaxNG.compact.psi.RncFile;
import org.intellij.plugins.relaxNG.compact.psi.RncGrammar;
import org.intellij.plugins.relaxNG.compact.psi.RncPattern;
import org.intellij.plugins.relaxNG.compact.psi.RncRef;
import org.intellij.plugins.relaxNG.compact.psi.util.EscapeUtil;
import org.intellij.plugins.relaxNG.compact.psi.util.RenameUtil;
import org.intellij.plugins.relaxNG.model.Define;
import org.intellij.plugins.relaxNG.model.resolve.DefinitionResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PatternReference
extends PsiReferenceBase.Poly<RncRef>
implements Function<Define, ResolveResult>,
LocalQuickFixProvider,
EmptyResolveMessageProvider {
    PatternReference(RncRef ref) {
        super((PsiElement)ref);
    }

    @NotNull
    public TextRange getRangeInElement() {
        ASTNode node = this.findNameNode();
        if (node == null) {
            TextRange textRange = TextRange.from((int)0, (int)0);
            if (textRange == null) {
                PatternReference.$$$reportNull$$$0(0);
            }
            return textRange;
        }
        int offset = ((RncRef)this.myElement).getTextOffset();
        TextRange textRange = TextRange.from((int)(offset - ((RncRef)this.myElement).getTextRange().getStartOffset()), (int)node.getTextLength());
        if (textRange == null) {
            PatternReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    private ASTNode findNameNode() {
        ASTNode node = ((RncRef)this.myElement).getNode();
        assert (node != null);
        return node.findChildByType(RncTokenTypes.IDENTIFIERS);
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        return results.length == 1 ? results[0].getElement() : null;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        RncGrammar scope = this.getScope();
        if (scope == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                PatternReference.$$$reportNull$$$0(2);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        Set<Define> set = DefinitionResolver.resolve(scope, this.getCanonicalText());
        if (set == null || set.size() == 0) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                PatternReference.$$$reportNull$$$0(3);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] resolveResultArray = (ResolveResult[])ContainerUtil.map2Array(set, ResolveResult.class, (Function)this);
        if (resolveResultArray == null) {
            PatternReference.$$$reportNull$$$0(4);
        }
        return resolveResultArray;
    }

    public ResolveResult fun(Define rncDefine) {
        Object element = rncDefine.getPsiElement();
        return element != null ? new PsiElementResolveResult(element) : new ResolveResult(){

            @Nullable
            public PsiElement getElement() {
                return null;
            }

            public boolean isValidResult() {
                return false;
            }
        };
    }

    @Nullable
    protected RncGrammar getScope() {
        return (RncGrammar)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, RncGrammar.class, (boolean)true, (Class[])new Class[]{PsiFile.class});
    }

    @NotNull
    public String getCanonicalText() {
        ASTNode node = this.findNameNode();
        String string = node != null ? EscapeUtil.unescapeText(node) : "";
        if (string == null) {
            PatternReference.$$$reportNull$$$0(5);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            PatternReference.$$$reportNull$$$0(6);
        }
        ASTNode newNode = RenameUtil.createIdentifierNode(((RncRef)this.getElement()).getManager(), newElementName);
        ASTNode nameNode = this.findNameNode();
        nameNode.getTreeParent().replaceChild(nameNode, newNode);
        return this.getElement();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PatternReference.$$$reportNull$$$0(7);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Object[] getVariants() {
        RncGrammar scope = this.getScope();
        if (scope == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                PatternReference.$$$reportNull$$$0(8);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        Map<String, Set<Define>> map = DefinitionResolver.getAllVariants(scope);
        if (map == null || map.size() == 0) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                PatternReference.$$$reportNull$$$0(9);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        Object[] objectArray = ContainerUtil.mapNotNull(map.values(), defines -> defines.size() == 0 ? null : ((Define)defines.iterator().next()).getPsiElement()).toArray();
        if (objectArray == null) {
            PatternReference.$$$reportNull$$$0(10);
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        if ("Unresolved pattern reference ''{0}''" == null) {
            PatternReference.$$$reportNull$$$0(11);
        }
        return "Unresolved pattern reference ''{0}''";
    }

    @Nullable
    public LocalQuickFix[] getQuickFixes() {
        if (this.getScope() != null) {
            return new LocalQuickFix[]{new CreatePatternFix(this)};
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/compact/psi/impl/PatternReference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/compact/psi/impl/PatternReference";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class CreatePatternFix
    implements LocalQuickFix {
        private final PatternReference myReference;

        CreatePatternFix(PatternReference reference2) {
            this.myReference = reference2;
        }

        @NotNull
        public String getName() {
            String string = "Create Pattern '" + this.myReference.getCanonicalText() + "'";
            if (string == null) {
                CreatePatternFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Create Pattern" == null) {
                CreatePatternFix.$$$reportNull$$$0(1);
            }
            return "Create Pattern";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                CreatePatternFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                CreatePatternFix.$$$reportNull$$$0(3);
            }
            RncFile rncfile = (RncFile)PsiFileFactory.getInstance((Project)((RncRef)this.myReference.getElement()).getProject()).createFileFromText("dummy.rnc", RncFileType.getInstance(), (CharSequence)"dummy = xxx");
            RncGrammar grammar = rncfile.getGrammar();
            assert (grammar != null);
            RncDefine def = (RncDefine)grammar.getFirstChild();
            RncGrammar scope = this.myReference.getScope();
            assert (scope != null);
            assert (def != null);
            RncDefine e = (RncDefine)scope.add(def);
            def.setName(this.myReference.getCanonicalText());
            SmartPsiElementPointer p = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)e);
            ASTNode blockNode = e.getParent().getNode();
            assert (blockNode != null);
            ASTNode newNode = e.getNode();
            assert (newNode != null);
            CodeStyleManager.getInstance((Project)e.getManager().getProject()).reformatNewlyAddedElement(blockNode, newNode);
            RncDefine d = (RncDefine)p.getElement();
            assert (d != null);
            RncPattern definition = d.getPattern();
            assert (definition != null);
            int offset = definition.getTextRange().getStartOffset();
            definition.delete();
            VirtualFile virtualFile = ((RncRef)this.myReference.getElement()).getContainingFile().getVirtualFile();
            if (virtualFile != null) {
                FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile, offset), true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/relaxNG/compact/psi/impl/PatternReference$CreatePatternFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/relaxNG/compact/psi/impl/PatternReference$CreatePatternFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

