/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.execution.impl.AsyncFilterRunner;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorHyperlinkSupport {
    private static final Key<TextAttributes> OLD_HYPERLINK_TEXT_ATTRIBUTES = Key.create((String)"OLD_HYPERLINK_TEXT_ATTRIBUTES");
    private static final Key<HyperlinkInfoTextAttributes> HYPERLINK = Key.create((String)"HYPERLINK");
    private final Editor myEditor;
    @NotNull
    private final Project myProject;
    private final AsyncFilterRunner myFilterRunner;

    public EditorHyperlinkSupport(final @NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(0);
        }
        if (project == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(1);
        }
        this.myEditor = editor;
        this.myProject = project;
        this.myFilterRunner = new AsyncFilterRunner(this, this.myEditor);
        editor.addEditorMouseListener(new EditorMouseListener(){

            public void mouseClicked(@NotNull EditorMouseEvent e) {
                Runnable runnable2;
                MouseEvent mouseEvent;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((mouseEvent = e.getMouseEvent()).getButton() == 1 && !mouseEvent.isPopupTrigger() && (runnable2 = EditorHyperlinkSupport.this.getLinkNavigationRunnable(EditorHyperlinkSupport.this.myEditor.xyToLogicalPosition(e.getMouseEvent().getPoint()))) != null) {
                    runnable2.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/impl/EditorHyperlinkSupport$1", "mouseClicked"));
            }
        });
        editor.addEditorMouseMotionListener(new EditorMouseMotionListener(){

            public void mouseMoved(@NotNull EditorMouseEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (e.getArea() != EditorMouseEventArea.EDITING_AREA) {
                    return;
                }
                HyperlinkInfo info = EditorHyperlinkSupport.this.getHyperlinkInfoByPoint(e.getMouseEvent().getPoint());
                Cursor handCursor = Cursor.getPredefinedCursor(12);
                if (info != null) {
                    EditorHyperlinkSupport.this.myEditor.getContentComponent().setCursor(handCursor);
                } else if (EditorHyperlinkSupport.this.myEditor.getContentComponent().getCursor() == handCursor) {
                    Cursor cursor = editor instanceof EditorEx ? UIUtil.getTextCursor((Color)((EditorEx)editor).getBackgroundColor()) : Cursor.getPredefinedCursor(2);
                    EditorHyperlinkSupport.this.myEditor.getContentComponent().setCursor(cursor);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/impl/EditorHyperlinkSupport$2", "mouseMoved"));
            }
        });
    }

    public void clearHyperlinks() {
        for (RangeHighlighter highlighter : EditorHyperlinkSupport.getHyperlinks(0, this.myEditor.getDocument().getTextLength(), this.myEditor)) {
            this.removeHyperlink(highlighter);
        }
    }

    public void waitForPendingFilters(long timeoutMs) {
        this.myFilterRunner.waitForPendingFilters(timeoutMs);
    }

    @Deprecated
    public Map<RangeHighlighter, HyperlinkInfo> getHyperlinks() {
        LinkedHashMap result2 = new LinkedHashMap();
        for (RangeHighlighter highlighter : EditorHyperlinkSupport.getHyperlinks(0, this.myEditor.getDocument().getTextLength(), this.myEditor)) {
            HyperlinkInfo info = EditorHyperlinkSupport.getHyperlinkInfo(highlighter);
            if (info == null) continue;
            result2.put((Object)highlighter, (Object)info);
        }
        return result2;
    }

    @Nullable
    public Runnable getLinkNavigationRunnable(LogicalPosition logical) {
        HyperlinkInfo hyperlinkInfo;
        if (EditorUtil.inVirtualSpace(this.myEditor, logical)) {
            return null;
        }
        RangeHighlighter range2 = this.findLinkRangeAt(this.myEditor.logicalPositionToOffset(logical));
        if (range2 != null && (hyperlinkInfo = EditorHyperlinkSupport.getHyperlinkInfo(range2)) != null) {
            return () -> {
                if (hyperlinkInfo instanceof HyperlinkInfoBase) {
                    Point point = this.myEditor.logicalPositionToXY(logical);
                    MouseEvent event = new MouseEvent(this.myEditor.getContentComponent(), 0, 0L, 0, point.x, point.y, 1, false);
                    ((HyperlinkInfoBase)hyperlinkInfo).navigate(this.myProject, new RelativePoint(event));
                } else {
                    hyperlinkInfo.navigate(this.myProject);
                }
                EditorHyperlinkSupport.linkFollowed(this.myEditor, EditorHyperlinkSupport.getHyperlinks(0, this.myEditor.getDocument().getTextLength(), this.myEditor), range2);
            };
        }
        return null;
    }

    @Nullable
    public static HyperlinkInfo getHyperlinkInfo(@NotNull RangeHighlighter range2) {
        HyperlinkInfoTextAttributes attributes;
        if (range2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(2);
        }
        return (attributes = (HyperlinkInfoTextAttributes)((Object)range2.getUserData(HYPERLINK))) != null ? attributes.getHyperlinkInfo() : null;
    }

    @Nullable
    private RangeHighlighter findLinkRangeAt(int offset) {
        Iterator<RangeHighlighter> iterator = EditorHyperlinkSupport.getHyperlinks(offset, offset, this.myEditor).iterator();
        if (iterator.hasNext()) {
            RangeHighlighter highlighter = iterator.next();
            return highlighter;
        }
        return null;
    }

    @Nullable
    private HyperlinkInfo getHyperlinkAt(int offset) {
        RangeHighlighter range2 = this.findLinkRangeAt(offset);
        return range2 == null ? null : EditorHyperlinkSupport.getHyperlinkInfo(range2);
    }

    public List<RangeHighlighter> findAllHyperlinksOnLine(int line) {
        int lineStart = this.myEditor.getDocument().getLineStartOffset(line);
        int lineEnd = this.myEditor.getDocument().getLineEndOffset(line);
        return EditorHyperlinkSupport.getHyperlinks(lineStart, lineEnd, this.myEditor);
    }

    private static List<RangeHighlighter> getHyperlinks(int startOffset, int endOffset, Editor editor) {
        MarkupModelEx markupModel = (MarkupModelEx)editor.getMarkupModel();
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        markupModel.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)new FilteringProcessor(rangeHighlighterEx -> rangeHighlighterEx.isValid() && EditorHyperlinkSupport.getHyperlinkInfo(rangeHighlighterEx) != null, (Processor)processor2));
        return new ArrayList<RangeHighlighter>(processor2.getResults());
    }

    public void removeHyperlink(@NotNull RangeHighlighter hyperlink) {
        if (hyperlink == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(3);
        }
        this.myEditor.getMarkupModel().removeHighlighter(hyperlink);
    }

    @Nullable
    public HyperlinkInfo getHyperlinkInfoByLineAndCol(int line, int col) {
        return this.getHyperlinkAt(this.myEditor.logicalPositionToOffset(new LogicalPosition(line, col)));
    }

    @Deprecated
    public void addHyperlink(int highlightStartOffset, int highlightEndOffset, @Nullable TextAttributes highlightAttributes, @NotNull HyperlinkInfo hyperlinkInfo) {
        if (hyperlinkInfo == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(4);
        }
        this.createHyperlink(highlightStartOffset, highlightEndOffset, highlightAttributes, hyperlinkInfo);
    }

    @NotNull
    public RangeHighlighter createHyperlink(int highlightStartOffset, int highlightEndOffset, @Nullable TextAttributes highlightAttributes, @NotNull HyperlinkInfo hyperlinkInfo) {
        if (hyperlinkInfo == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(5);
        }
        RangeHighlighter rangeHighlighter = this.createHyperlink(highlightStartOffset, highlightEndOffset, highlightAttributes, hyperlinkInfo, null, 5900);
        if (rangeHighlighter == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(6);
        }
        return rangeHighlighter;
    }

    @NotNull
    private RangeHighlighter createHyperlink(int highlightStartOffset, int highlightEndOffset, @Nullable TextAttributes highlightAttributes, @NotNull HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes followedHyperlinkAttributes, int layer) {
        if (hyperlinkInfo == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(7);
        }
        TextAttributes textAttributes = highlightAttributes != null ? highlightAttributes : EditorHyperlinkSupport.getHyperlinkAttributes();
        RangeHighlighter highlighter = this.myEditor.getMarkupModel().addRangeHighlighter(highlightStartOffset, highlightEndOffset, layer, textAttributes, HighlighterTargetArea.EXACT_RANGE);
        EditorHyperlinkSupport.associateHyperlink(highlighter, hyperlinkInfo, followedHyperlinkAttributes);
        RangeHighlighter rangeHighlighter = highlighter;
        if (rangeHighlighter == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(8);
        }
        return rangeHighlighter;
    }

    public static void associateHyperlink(@NotNull RangeHighlighter highlighter, @NotNull HyperlinkInfo hyperlinkInfo) {
        if (highlighter == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(9);
        }
        if (hyperlinkInfo == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(10);
        }
        EditorHyperlinkSupport.associateHyperlink(highlighter, hyperlinkInfo, null);
    }

    private static void associateHyperlink(@NotNull RangeHighlighter highlighter, @NotNull HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes followedHyperlinkAttributes) {
        if (highlighter == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(11);
        }
        if (hyperlinkInfo == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(12);
        }
        highlighter.putUserData(HYPERLINK, (Object)new HyperlinkInfoTextAttributes(hyperlinkInfo, followedHyperlinkAttributes));
    }

    @Nullable
    public HyperlinkInfo getHyperlinkInfoByPoint(Point p) {
        LogicalPosition pos = this.myEditor.xyToLogicalPosition(new Point(p.x, p.y));
        if (EditorUtil.inVirtualSpace(this.myEditor, pos)) {
            return null;
        }
        return this.getHyperlinkInfoByLineAndCol(pos.line, pos.column);
    }

    @Deprecated
    public void highlightHyperlinks(Filter customFilter, Filter predefinedMessageFilter, int line1, int endLine) {
        this.highlightHyperlinks((line, entireLength) -> {
            Filter.Result result2 = customFilter.applyFilter(line, entireLength);
            return result2 != null ? result2 : predefinedMessageFilter.applyFilter(line, entireLength);
        }, line1, endLine);
    }

    public void highlightHyperlinks(Filter customFilter, int line1, int endLine) {
        this.myFilterRunner.highlightHyperlinks(customFilter, Math.max(0, line1), endLine);
    }

    void highlightHyperlinks(@NotNull Filter.Result result2, int offsetDelta) {
        if (result2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(13);
        }
        Document document = this.myEditor.getDocument();
        for (Filter.ResultItem resultItem : result2.getResultItems()) {
            int start2 = resultItem.getHighlightStartOffset() + offsetDelta;
            int end = resultItem.getHighlightEndOffset() + offsetDelta;
            if (start2 < 0 || end < start2 || end > document.getTextLength()) continue;
            TextAttributes attributes = resultItem.getHighlightAttributes();
            if (resultItem.getHyperlinkInfo() != null) {
                this.createHyperlink(start2, end, attributes, resultItem.getHyperlinkInfo(), resultItem.getFollowedHyperlinkAttributes(), resultItem.getHighlighterLayer());
                continue;
            }
            if (attributes == null) continue;
            this.addHighlighter(start2, end, attributes, resultItem.getHighlighterLayer());
        }
    }

    public void addHighlighter(int highlightStartOffset, int highlightEndOffset, TextAttributes highlightAttributes) {
        this.addHighlighter(highlightStartOffset, highlightEndOffset, highlightAttributes, 5800);
    }

    public void addHighlighter(int highlightStartOffset, int highlightEndOffset, TextAttributes highlightAttributes, int highlighterLayer) {
        this.myEditor.getMarkupModel().addRangeHighlighter(highlightStartOffset, highlightEndOffset, highlighterLayer, highlightAttributes, HighlighterTargetArea.EXACT_RANGE);
    }

    private static TextAttributes getHyperlinkAttributes() {
        return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
    }

    @NotNull
    private static TextAttributes getFollowedHyperlinkAttributes(@NotNull RangeHighlighter range2) {
        HyperlinkInfoTextAttributes attrs;
        TextAttributes result2;
        if (range2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(14);
        }
        TextAttributes textAttributes = result2 = (attrs = (HyperlinkInfoTextAttributes)((Object)HYPERLINK.get((UserDataHolder)range2))) != null ? attrs.getFollowedHyperlinkAttributes() : null;
        if (result2 == null) {
            result2 = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.FOLLOWED_HYPERLINK_ATTRIBUTES);
        }
        TextAttributes textAttributes2 = result2;
        if (textAttributes2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(15);
        }
        return textAttributes2;
    }

    @Nullable
    public static OccurenceNavigator.OccurenceInfo getNextOccurrence(final Editor editor, int delta, final Consumer<? super RangeHighlighter> action) {
        RangeHighlighter range2;
        int i;
        final List<RangeHighlighter> ranges = EditorHyperlinkSupport.getHyperlinks(0, editor.getDocument().getTextLength(), editor);
        if (ranges.isEmpty()) {
            return null;
        }
        for (i = 0; i < ranges.size() && (range2 = ranges.get(i)).getUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES) == null; ++i) {
        }
        int newIndex = i %= ranges.size();
        while (newIndex < ranges.size() && newIndex >= 0) {
            newIndex = (newIndex + delta + ranges.size()) % ranges.size();
            final RangeHighlighter next = ranges.get(newIndex);
            HyperlinkInfo info = EditorHyperlinkSupport.getHyperlinkInfo(next);
            assert (info != null);
            if (info.includeInOccurenceNavigation()) {
                boolean inCollapsedRegion;
                boolean bl = inCollapsedRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(next.getStartOffset()) != null;
                if (!inCollapsedRegion) {
                    return new OccurenceNavigator.OccurenceInfo((Navigatable)new NavigatableAdapter(){

                        public void navigate(boolean requestFocus) {
                            action.consume((Object)next);
                            EditorHyperlinkSupport.linkFollowed(editor, ranges, next);
                        }
                    }, newIndex == -1 ? -1 : newIndex + 1, ranges.size());
                }
            }
            if (newIndex != i) continue;
            break;
        }
        return null;
    }

    private static void linkFollowed(Editor editor, Collection<? extends RangeHighlighter> ranges, RangeHighlighter link) {
        MarkupModelEx markupModel = (MarkupModelEx)editor.getMarkupModel();
        for (RangeHighlighter rangeHighlighter : ranges) {
            TextAttributes oldAttr = (TextAttributes)rangeHighlighter.getUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES);
            if (oldAttr != null) {
                markupModel.setRangeHighlighterAttributes(rangeHighlighter, oldAttr);
                rangeHighlighter.putUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES, null);
            }
            if (rangeHighlighter != link) continue;
            rangeHighlighter.putUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES, (Object)rangeHighlighter.getTextAttributes());
            markupModel.setRangeHighlighterAttributes(rangeHighlighter, EditorHyperlinkSupport.getFollowedHyperlinkAttributes(rangeHighlighter));
        }
        markupModel.addRangeHighlighter(0, 0, link.getLayer(), EditorHyperlinkSupport.getHyperlinkAttributes(), HighlighterTargetArea.EXACT_RANGE).dispose();
    }

    @NotNull
    public static String getLineText(@NotNull Document document, int lineNumber, boolean includeEol) {
        if (document == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(16);
        }
        String string = EditorHyperlinkSupport.getLineSequence(document, lineNumber, includeEol).toString();
        if (string == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private static CharSequence getLineSequence(@NotNull Document document, int lineNumber, boolean includeEol) {
        if (document == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(18);
        }
        int endOffset = document.getLineEndOffset(lineNumber);
        if (includeEol && endOffset < document.getTextLength()) {
            ++endOffset;
        }
        CharSequence charSequence = document.getImmutableCharSequence().subSequence(document.getLineStartOffset(lineNumber), endOffset);
        if (charSequence == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(19);
        }
        return charSequence;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 15: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 15: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlink";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkInfo";
                break;
            }
            case 6: 
            case 8: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/EditorHyperlinkSupport";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/EditorHyperlinkSupport";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createHyperlink";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFollowedHyperlinkAttributes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineText";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHyperlinkInfo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeHyperlink";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addHyperlink";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createHyperlink";
                break;
            }
            case 6: 
            case 8: 
            case 15: 
            case 17: 
            case 19: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "associateHyperlink";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "highlightHyperlinks";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFollowedHyperlinkAttributes";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLineText";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLineSequence";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 15: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HyperlinkInfoTextAttributes
    extends TextAttributes {
        private final HyperlinkInfo myHyperlinkInfo;
        private final TextAttributes myFollowedHyperlinkAttributes;

        HyperlinkInfoTextAttributes(@NotNull HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes followedHyperlinkAttributes) {
            if (hyperlinkInfo == null) {
                HyperlinkInfoTextAttributes.$$$reportNull$$$0(0);
            }
            this.myHyperlinkInfo = hyperlinkInfo;
            this.myFollowedHyperlinkAttributes = followedHyperlinkAttributes;
        }

        @NotNull
        HyperlinkInfo getHyperlinkInfo() {
            HyperlinkInfo hyperlinkInfo = this.myHyperlinkInfo;
            if (hyperlinkInfo == null) {
                HyperlinkInfoTextAttributes.$$$reportNull$$$0(1);
            }
            return hyperlinkInfo;
        }

        @Nullable
        TextAttributes getFollowedHyperlinkAttributes() {
            return this.myFollowedHyperlinkAttributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hyperlinkInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/impl/EditorHyperlinkSupport$HyperlinkInfoTextAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/impl/EditorHyperlinkSupport$HyperlinkInfoTextAttributes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHyperlinkInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

