/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class CssEditorUtil {
    public static int skipWhiteSpaces(Editor editor, int offset) {
        CharSequence sequence = editor.getDocument().getCharsSequence();
        while (offset < sequence.length() && StringUtil.isWhiteSpace((char)sequence.charAt(offset))) {
            ++offset;
        }
        return Math.min(sequence.length() - 1, offset);
    }

    public static void typeOrMove(@NotNull Editor editor, char ch) {
        if (editor == null) {
            CssEditorUtil.$$$reportNull$$$0(0);
        }
        if (!CssEditorUtil.isCaretAtChar(editor, ch)) {
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)String.valueOf(ch));
        } else {
            EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
        }
    }

    private static boolean isCaretAtChar(@NotNull Editor editor, char ch) {
        if (editor == null) {
            CssEditorUtil.$$$reportNull$$$0(1);
        }
        int startOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        return document.getTextLength() > startOffset && document.getCharsSequence().charAt(startOffset) == ch;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "editor";
        objectArray2[1] = "com/intellij/psi/css/util/CssEditorUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "typeOrMove";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isCaretAtChar";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

