/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing.modifiers;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6FunctionParser;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.psi.tree.IElementType;
import java.util.function.Predicate;

public final class JSModifiersStructureLeaf
implements JSModifiersStructure {
    private final IElementType myTokenType;
    private final boolean myAllowNewlineAfter;

    public JSModifiersStructureLeaf(IElementType tokenType) {
        this(tokenType, true);
    }

    public JSModifiersStructureLeaf(IElementType tokenType, boolean allowNewlineAfter) {
        this.myTokenType = tokenType;
        this.myAllowNewlineAfter = allowNewlineAfter;
    }

    @Override
    public boolean parseOptimistically(PsiBuilder builder) {
        if (this.isPossibleLookahead(builder)) {
            builder.advanceLexer();
            this.setContexts(builder, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean parse(PsiBuilder builder, Predicate<PsiBuilder> isPossibleLookahead) {
        if (this.isPossibleLookahead(builder)) {
            PsiBuilder.Marker temp = builder.mark();
            builder.advanceLexer();
            if (isPossibleLookahead.test(builder)) {
                temp.drop();
                this.setContexts(builder, true);
                return true;
            }
            temp.rollbackTo();
        }
        return false;
    }

    private void setContexts(PsiBuilder builder, boolean value) {
        if (this.myTokenType == JSTokenTypes.ASYNC_KEYWORD) {
            builder.putUserData(ES6FunctionParser.HAD_ASYNC_MODIFIER_KEY, (Object)value);
        } else if (this.myTokenType == JSTokenTypes.MULT) {
            builder.putUserData(FunctionParser.IS_GENERATOR_FUNCTION_KEY, (Object)value);
        } else if (this.myTokenType == JSTokenTypes.GET_KEYWORD || this.myTokenType == JSTokenTypes.SET_KEYWORD) {
            builder.putUserData(FunctionParser.HAD_GET_SET, (Object)value);
        }
    }

    @Override
    public void resetContexts(PsiBuilder builder) {
        this.setContexts(builder, false);
    }

    @Override
    public boolean isPossibleLookahead(PsiBuilder builder) {
        return (this.myAllowNewlineAfter || !JavaScriptParserBase.hasSemanticLinefeedAfter(builder)) && builder.getTokenType() == this.myTokenType;
    }
}

