/*
 * Decompiled with CFR 0.152.
 */
package git4idea.cherrypick;

import com.intellij.dvcs.cherrypick.VcsCherryPicker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import git4idea.GitApplyChangesProcess;
import git4idea.GitProtectedBranchesKt;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import org.jetbrains.annotations.NotNull;

public class GitCherryPicker
extends VcsCherryPicker {
    private static final Logger LOG = Logger.getInstance(GitCherryPicker.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final GitVcsSettings mySettings;

    public GitCherryPicker(@NotNull Project project, @NotNull Git git) {
        if (project == null) {
            GitCherryPicker.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitCherryPicker.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myGit = git;
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.mySettings = GitVcsSettings.getInstance(this.myProject);
    }

    public void cherryPick(@NotNull List<VcsFullCommitDetails> commits2) {
        if (commits2 == null) {
            GitCherryPicker.$$$reportNull$$$0(2);
        }
        GitApplyChangesProcess applyProcess = new GitApplyChangesProcess(this.myProject, commits2, this.isAutoCommit(), "cherry-pick", "applied", (Function4<? super GitRepository, ? super Hash, ? super Boolean, ? super List<? extends GitLineHandlerListener>, ? extends GitCommandResult>)((Function4)(repository, commit2, autoCommit, listeners) -> this.myGit.cherryPick((GitRepository)repository, commit2.asString(), (boolean)autoCommit, this.shouldAddSuffix((GitRepository)repository, (Hash)commit2), (GitLineHandlerListener[])ArrayUtil.toObjectArray((Collection)listeners, GitLineHandlerListener.class))), (Function1<? super GitCommandResult, Boolean>)((Function1)result2 -> GitCherryPicker.isNothingToCommitMessage(result2)), (Function2<? super GitRepository, ? super VcsFullCommitDetails, String>)((Function2)(repository, commit2) -> this.createCommitMessage((GitRepository)repository, (VcsFullCommitDetails)commit2)), true, (Function1<? super GitRepository, Unit>)((Function1)repository -> this.cancelCherryPick((GitRepository)repository)));
        applyProcess.execute();
    }

    private static boolean isNothingToCommitMessage(@NotNull GitCommandResult result2) {
        String stdout;
        if (result2 == null) {
            GitCherryPicker.$$$reportNull$$$0(3);
        }
        return (stdout = result2.getOutputAsJoinedString()).contains("nothing to commit") || stdout.contains("previous cherry-pick is now empty");
    }

    @NotNull
    private String createCommitMessage(@NotNull GitRepository repository, @NotNull VcsFullCommitDetails commit2) {
        if (repository == null) {
            GitCherryPicker.$$$reportNull$$$0(4);
        }
        if (commit2 == null) {
            GitCherryPicker.$$$reportNull$$$0(5);
        }
        String message = commit2.getFullMessage();
        if (this.shouldAddSuffix(repository, (Hash)commit2.getId())) {
            message = message + "\n\n(cherry picked from commit " + ((Hash)commit2.getId()).asString() + ")";
        }
        String string = message;
        if (string == null) {
            GitCherryPicker.$$$reportNull$$$0(6);
        }
        return string;
    }

    private boolean shouldAddSuffix(@NotNull GitRepository repository, @NotNull Hash commit2) {
        if (repository == null) {
            GitCherryPicker.$$$reportNull$$$0(7);
        }
        if (commit2 == null) {
            GitCherryPicker.$$$reportNull$$$0(8);
        }
        return this.mySettings.shouldAddSuffixToCherryPicksOfPublishedCommits() && GitProtectedBranchesKt.isCommitPublished(repository, commit2);
    }

    private Unit cancelCherryPick(@NotNull GitRepository repository) {
        if (repository == null) {
            GitCherryPicker.$$$reportNull$$$0(9);
        }
        if (this.isAutoCommit()) {
            GitCherryPicker.removeCherryPickHead(repository);
        }
        return Unit.INSTANCE;
    }

    private static void removeCherryPickHead(@NotNull GitRepository repository) {
        File cherryPickHeadFile;
        if (repository == null) {
            GitCherryPicker.$$$reportNull$$$0(10);
        }
        if ((cherryPickHeadFile = repository.getRepositoryFiles().getCherryPickHead()).exists()) {
            boolean deleted = FileUtil.delete((File)cherryPickHeadFile);
            if (!deleted) {
                LOG.warn("Couldn't delete " + cherryPickHeadFile);
            }
        } else {
            LOG.info("Cancel cherry-pick in " + repository.getPresentableUrl() + ": no CHERRY_PICK_HEAD found");
        }
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = GitVcs.getKey();
        if (vcsKey == null) {
            GitCherryPicker.$$$reportNull$$$0(11);
        }
        return vcsKey;
    }

    @NotNull
    public String getActionTitle() {
        if ("Cherry-Pick" == null) {
            GitCherryPicker.$$$reportNull$$$0(12);
        }
        return "Cherry-Pick";
    }

    private boolean isAutoCommit() {
        return GitVcsSettings.getInstance(this.myProject).isAutoCommitOnCherryPick();
    }

    public boolean canHandleForRoots(@NotNull Collection<VirtualFile> roots) {
        if (roots == null) {
            GitCherryPicker.$$$reportNull$$$0(13);
        }
        return roots.stream().allMatch(r -> this.myRepositoryManager.getRepositoryForRoot((VirtualFile)r) != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/cherrypick/GitCherryPicker";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/cherrypick/GitCherryPicker";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommitMessage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedVcs";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "cherryPick";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isNothingToCommitMessage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCommitMessage";
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddSuffix";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "cancelCherryPick";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeCherryPickHead";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canHandleForRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

