/*
 * Decompiled with CFR 0.152.
 */
package custom;

import custom.AnimationAction;
import custom.AnimationMessage;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lts.Relation;

public class OutputActionRegistry {
    Hashtable outputs = new Hashtable();
    Relation actionMap;
    AnimationMessage msg;

    public OutputActionRegistry(Relation relation, AnimationMessage animationMessage) {
        this.actionMap = relation;
        this.msg = animationMessage;
    }

    public void register(String string, AnimationAction animationAction) {
        Vector<AnimationAction> vector = (Vector<AnimationAction>)this.outputs.get(string);
        if (vector != null) {
            vector.addElement(animationAction);
        } else {
            vector = new Vector<AnimationAction>();
            vector.addElement(animationAction);
            this.outputs.put(string, vector);
        }
    }

    public void doAction(String string) {
        this.msg.traceMsg(string);
        Object v = this.actionMap.get(string);
        if (v == null) {
            return;
        }
        if (v instanceof String) {
            this.execute((String)v);
        } else {
            Vector vector = (Vector)v;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.execute((String)enumeration.nextElement());
            }
        }
    }

    private void execute(String string) {
        this.msg.debugMsg("-action -" + string);
        Vector vector = (Vector)this.outputs.get(string);
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            AnimationAction animationAction = (AnimationAction)enumeration.nextElement();
            animationAction.action();
        }
    }
}

