#---------------------------------------------------------------
# Help utilities
#---------------------------------------------------------------

#---------------------------------------------------------------
# Procedure: about
#  Pops up the "about" window
#---------------------------------------------------------------
proc about {} {
    infodialog .about 32 8 {
	"\nThe Keyboard Practicer (kp)\n"
	"Ver 0.96 (October 17, 1996)\n\n"
	"Author: Satoshi Asami\n"
	" asami@cs.berekley.edu\n"
	" asami@freebsd.org\n\n"
    }
}

#---------------------------------------------------------------
# Procedure: help
#  Pops up the "help" window
#---------------------------------------------------------------
proc help {} {
    infodialog .help 67 29 {
	"\nThis message describes the general function of KP and the ways\n"
	"the features without \"Help\" buttons work.\n"
	"Try the \"Help\" buttons on dialogs if you want to read a detailed\n"
	"description of that particular function.\n\n"
	"You are supposed to type the key that corresponds to the character\n"
	"that is at the cursor.  When the program is case-insensitive, you\n"
	"don't have to hold the shift key to type uppercase letters.  When\n"
	"it is case-sensitive, you are expected to type the shift key too.\n\n"
	"When the \"Show next key\" feature is enabled, you will see the\n"
	"next key you have to type in reverse-video.\n\n"
	"You can choose between Dvorak an qwerty keyboards.\n\n"
	"There is a \"Filter\" feature that allows you to specify keys you\n"
	"want to practice.  Refer to its \"Help\" button for more details.\n\n"
	"All the features mentioned above can be selected using the\n"
	"\"Options\" menu.\n\n"
	"You can load any text file using the \"Load file\" entry in the\n"
	"\"File\" menu.  Try some English document---manual pages (cat\n"
	"versions) are a good start.\n\n"
	"                   Enjoy!\n\n"
    }
}

#---------------------------------------------------------------
# Procedure: filterhelp
#  Pops up the "help" window for the filter
#---------------------------------------------------------------
proc filterhelp {} {
    infodialog .filterhelp 64 10 {
	"\nIf you choose \"OK\", the program will display only words that "
	"are\n"
	"composed entirely from the characters you enter here.\n"
	"\"Unfilter\" (in the Options menu) will resume original contents.\n\n"
	"When the \"Case Insensitive\" option is set, both uppercase and\n"
	"lowercase versions are included.\n\n"
	"We recommend you to begin with the home position keys.\n\n"
    }
}

#---------------------------------------------------------------
# Procedure: infodialog {w height width text}
#  Pops up an info box.  Refer to kpdialog for meanings of arguments.
#---------------------------------------------------------------
proc infodialog {w width height text} {
    kpdialog $w $width $height "$text" info
}

#---------------------------------------------------------------
# Procedure: errordialog {w height width text}
#  Pops up an error box.  Refer to kpdialog for meanings of arguments.
#---------------------------------------------------------------
proc errordialog {w width height text} {
    kpdialog $w $width $height "$text" error
}

#---------------------------------------------------------------
# Procedure: kpdialog {w height width text bitmap}
#  Pops up an dialog box with name $w and text $text,
#   with an "OK" button at bottom
#  $text is a list of strings.
#  The size of text window is $width x $text.
#  Displays bitmap too.
#---------------------------------------------------------------
proc kpdialog {w width height text bitmap} {
    toplevel $w
    relative . $w 100 0
    frame $w.top -relief groove -bd 3
    label $w.top.info -bitmap $bitmap
    text $w.top.text -width $width -height $height
    foreach line $text {
	$w.top.text insert end $line
    }
    pack $w.top.info $w.top.text -side left -anchor center \
	    -padx 7
    pack $w.top
    frame $w.bottom
    frame $w.bottom.frame -relief sunken -bd 1
    button $w.bottom.frame.ok -text "OK" -command "destroy $w"
    pack $w.bottom.frame -pady 6
    pack $w.bottom.frame.ok -ipadx 20 -ipady 2 -pady 3 -padx 3
    pack $w.bottom -pady 8
}
