/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.external;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.external.ExternalByteArrayCodec;
import htsjdk.samtools.cram.encoding.external.ExternalEncoding;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.SliceBlocksReadStreams;
import htsjdk.samtools.cram.structure.SliceBlocksWriteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public final class ExternalByteArrayEncoding
extends ExternalEncoding<byte[]> {
    public ExternalByteArrayEncoding(int externalBlockContentId) {
        super(externalBlockContentId);
    }

    public static ExternalByteArrayEncoding fromSerializedEncodingParams(byte[] serializedParams) {
        int contentId = ITF8.readUnsignedITF8(serializedParams);
        return new ExternalByteArrayEncoding(contentId);
    }

    @Override
    public byte[] toSerializedEncodingParams() {
        return ITF8.writeUnsignedITF8(this.externalBlockContentId);
    }

    @Override
    public CRAMCodec<byte[]> buildCodec(SliceBlocksReadStreams sliceBlocksReadStreams, SliceBlocksWriteStreams sliceBlocksWriteStreams) {
        ByteArrayInputStream is = sliceBlocksReadStreams == null ? null : sliceBlocksReadStreams.getExternalInputStream(this.externalBlockContentId);
        ByteArrayOutputStream os = sliceBlocksWriteStreams == null ? null : sliceBlocksWriteStreams.getExternalOutputStream(this.externalBlockContentId);
        return new ExternalByteArrayCodec(is, os);
    }

    @Override
    public String toString() {
        return String.format("Content ID: %d", this.externalBlockContentId);
    }
}

