/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.net.URI;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.resource.ExternalResourceListBuildOperationType;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.transfer.AbstractProgressLoggingHandler;
import org.gradle.internal.resource.transfer.ExternalResourceLister;

public class ProgressLoggingExternalResourceLister
extends AbstractProgressLoggingHandler
implements ExternalResourceLister {
    private final ExternalResourceLister delegate;
    private final BuildOperationRunner buildOperationExecutor;
    private static final ExternalResourceListBuildOperationType.Result LIST_RESULT = new ExternalResourceListBuildOperationType.Result(){};

    public ProgressLoggingExternalResourceLister(ExternalResourceLister delegate, BuildOperationRunner buildOperationRunner) {
        this.delegate = delegate;
        this.buildOperationExecutor = buildOperationRunner;
    }

    @Nullable
    public List<String> list(ExternalResourceName parent) throws ResourceException {
        return (List)this.buildOperationExecutor.call((CallableBuildOperation)new ListOperation(parent));
    }

    private class ListOperation
    implements CallableBuildOperation<List<String>> {
        private final ExternalResourceName parent;

        public ListOperation(ExternalResourceName parent) {
            this.parent = parent;
        }

        public List<String> call(BuildOperationContext context) {
            try {
                List list = ProgressLoggingExternalResourceLister.this.delegate.list(this.parent);
                return list;
            }
            finally {
                context.setResult((Object)LIST_RESULT);
            }
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)("List " + this.parent.getUri())).details((Object)new ListOperationDetails(this.parent.getUri()));
        }
    }

    private static class ListOperationDetails
    extends AbstractProgressLoggingHandler.LocationDetails
    implements ExternalResourceListBuildOperationType.Details {
        private ListOperationDetails(URI location) {
            super(location);
        }

        public String toString() {
            return "ExternalResourceListBuildOperationType.Details{location=" + this.getLocation() + ", " + '}';
        }
    }
}

