/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.SchemaElement;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DITStructureRuleDefinition
extends SchemaElement {
    private static final int[] NO_INTS = new int[0];
    private static final long serialVersionUID = -3233223742542121140L;
    private final boolean isObsolete;
    private final int ruleID;
    private final int[] superiorRuleIDs;
    private final Map<String, String[]> extensions;
    private final String description;
    private final String ditStructureRuleString;
    private final String nameFormID;
    private final String[] names;

    public DITStructureRuleDefinition(String s) throws LDAPException {
        String nfID;
        String descr;
        Boolean obsolete;
        LinkedHashMap<String, String[]> exts;
        ArrayList<String> nameList;
        ArrayList<Integer> supList;
        block25: {
            String token;
            Validator.ensureNotNull(s);
            this.ditStructureRuleString = s.trim();
            int length = this.ditStructureRuleString.length();
            if (length == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_EMPTY.get());
            }
            if (this.ditStructureRuleString.charAt(0) != '(') {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_NO_OPENING_PAREN.get(this.ditStructureRuleString));
            }
            int pos = DITStructureRuleDefinition.skipSpaces(this.ditStructureRuleString, 1, length);
            StringBuilder buffer = new StringBuilder();
            pos = DITStructureRuleDefinition.readOID(this.ditStructureRuleString, pos, length, buffer);
            String ruleIDStr = buffer.toString();
            try {
                this.ruleID = Integer.parseInt(ruleIDStr);
            }
            catch (NumberFormatException nfe) {
                Debug.debugException(nfe);
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_RULE_ID_NOT_INT.get(this.ditStructureRuleString), nfe);
            }
            supList = new ArrayList<Integer>(1);
            nameList = new ArrayList<String>(1);
            exts = new LinkedHashMap<String, String[]>(5);
            obsolete = null;
            descr = null;
            nfID = null;
            block4: while (true) {
                String lowerToken;
                int tokenStartPos = pos = DITStructureRuleDefinition.skipSpaces(this.ditStructureRuleString, pos, length);
                while (pos < length && this.ditStructureRuleString.charAt(pos) != ' ') {
                    ++pos;
                }
                token = this.ditStructureRuleString.substring(tokenStartPos, pos);
                if (token.length() > 1 && token.endsWith(")")) {
                    token = token.substring(0, token.length() - 1);
                    --pos;
                }
                if ((lowerToken = StaticUtils.toLowerCase(token)).equals(")")) {
                    if (pos < length) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_CLOSE_NOT_AT_END.get(this.ditStructureRuleString));
                    }
                    break block25;
                }
                if (lowerToken.equals("name")) {
                    if (nameList.isEmpty()) {
                        pos = DITStructureRuleDefinition.skipSpaces(this.ditStructureRuleString, pos, length);
                        pos = DITStructureRuleDefinition.readQDStrings(this.ditStructureRuleString, pos, length, nameList);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_MULTIPLE_ELEMENTS.get(this.ditStructureRuleString, "NAME"));
                }
                if (lowerToken.equals("desc")) {
                    if (descr == null) {
                        pos = DITStructureRuleDefinition.skipSpaces(this.ditStructureRuleString, pos, length);
                        buffer = new StringBuilder();
                        pos = DITStructureRuleDefinition.readQDString(this.ditStructureRuleString, pos, length, buffer);
                        descr = buffer.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_MULTIPLE_ELEMENTS.get(this.ditStructureRuleString, "DESC"));
                }
                if (lowerToken.equals("obsolete")) {
                    if (obsolete == null) {
                        obsolete = true;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_MULTIPLE_ELEMENTS.get(this.ditStructureRuleString, "OBSOLETE"));
                }
                if (lowerToken.equals("form")) {
                    if (nfID == null) {
                        pos = DITStructureRuleDefinition.skipSpaces(this.ditStructureRuleString, pos, length);
                        buffer = new StringBuilder();
                        pos = DITStructureRuleDefinition.readOID(this.ditStructureRuleString, pos, length, buffer);
                        nfID = buffer.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_MULTIPLE_ELEMENTS.get(this.ditStructureRuleString, "FORM"));
                }
                if (lowerToken.equals("sup")) {
                    if (supList.isEmpty()) {
                        ArrayList<String> supStrs = new ArrayList<String>(1);
                        pos = DITStructureRuleDefinition.skipSpaces(this.ditStructureRuleString, pos, length);
                        pos = DITStructureRuleDefinition.readOIDs(this.ditStructureRuleString, pos, length, supStrs);
                        supList.ensureCapacity(supStrs.size());
                        Iterator<String> i$ = supStrs.iterator();
                        while (true) {
                            if (!i$.hasNext()) continue block4;
                            String supStr = i$.next();
                            try {
                                supList.add(Integer.parseInt(supStr));
                            }
                            catch (NumberFormatException nfe) {
                                Debug.debugException(nfe);
                                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_SUP_ID_NOT_INT.get(this.ditStructureRuleString), nfe);
                            }
                        }
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_MULTIPLE_ELEMENTS.get(this.ditStructureRuleString, "SUP"));
                }
                if (!lowerToken.startsWith("x-")) break;
                pos = DITStructureRuleDefinition.skipSpaces(this.ditStructureRuleString, pos, length);
                ArrayList<String> valueList = new ArrayList<String>(5);
                pos = DITStructureRuleDefinition.readQDStrings(this.ditStructureRuleString, pos, length, valueList);
                String[] values = new String[valueList.size()];
                valueList.toArray(values);
                if (exts.containsKey(token)) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_DUP_EXT.get(this.ditStructureRuleString, token));
                }
                exts.put(token, values);
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_UNEXPECTED_TOKEN.get(this.ditStructureRuleString, token));
        }
        this.description = descr;
        this.nameFormID = nfID;
        if (this.nameFormID == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_DSR_DECODE_NO_FORM.get(this.ditStructureRuleString));
        }
        this.names = new String[nameList.size()];
        nameList.toArray(this.names);
        this.superiorRuleIDs = new int[supList.size()];
        for (int i = 0; i < this.superiorRuleIDs.length; ++i) {
            this.superiorRuleIDs[i] = (Integer)supList.get(i);
        }
        this.isObsolete = obsolete != null;
        this.extensions = Collections.unmodifiableMap(exts);
    }

    public DITStructureRuleDefinition(int ruleID, String name, String description, String nameFormID, Integer superiorRuleID, Map<String, String[]> extensions) {
        int[] nArray;
        String[] stringArray;
        if (name == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = name;
        }
        if (superiorRuleID == null) {
            nArray = null;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = superiorRuleID;
        }
        this(ruleID, stringArray, description, false, nameFormID, nArray, extensions);
    }

    public DITStructureRuleDefinition(int ruleID, String[] names, String description, boolean isObsolete, String nameFormID, int[] superiorRuleIDs, Map<String, String[]> extensions) {
        Validator.ensureNotNull(nameFormID);
        this.ruleID = ruleID;
        this.description = description;
        this.isObsolete = isObsolete;
        this.nameFormID = nameFormID;
        this.names = names == null ? StaticUtils.NO_STRINGS : names;
        this.superiorRuleIDs = superiorRuleIDs == null ? NO_INTS : superiorRuleIDs;
        this.extensions = extensions == null ? Collections.emptyMap() : Collections.unmodifiableMap(extensions);
        StringBuilder buffer = new StringBuilder();
        this.createDefinitionString(buffer);
        this.ditStructureRuleString = buffer.toString();
    }

    private void createDefinitionString(StringBuilder buffer) {
        buffer.append("( ");
        buffer.append(this.ruleID);
        if (this.names.length == 1) {
            buffer.append(" NAME '");
            buffer.append(this.names[0]);
            buffer.append('\'');
        } else if (this.names.length > 1) {
            buffer.append(" NAME (");
            for (String name : this.names) {
                buffer.append(" '");
                buffer.append(name);
                buffer.append('\'');
            }
            buffer.append(" )");
        }
        if (this.description != null) {
            buffer.append(" DESC '");
            DITStructureRuleDefinition.encodeValue(this.description, buffer);
            buffer.append('\'');
        }
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        buffer.append(" FORM ");
        buffer.append(this.nameFormID);
        if (this.superiorRuleIDs.length == 1) {
            buffer.append(" SUP ");
            buffer.append(this.superiorRuleIDs[0]);
        } else if (this.superiorRuleIDs.length > 1) {
            buffer.append(" SUP (");
            for (int supID : this.superiorRuleIDs) {
                buffer.append(" $ ");
                buffer.append(supID);
            }
            buffer.append(" )");
        }
        for (Map.Entry<String, String[]> e : this.extensions.entrySet()) {
            String name = e.getKey();
            String[] values = e.getValue();
            if (values.length == 1) {
                buffer.append(' ');
                buffer.append(name);
                buffer.append(" '");
                DITStructureRuleDefinition.encodeValue(values[0], buffer);
                buffer.append('\'');
                continue;
            }
            buffer.append(' ');
            buffer.append(name);
            buffer.append(" (");
            for (String value : values) {
                buffer.append(" '");
                DITStructureRuleDefinition.encodeValue(value, buffer);
                buffer.append('\'');
            }
            buffer.append(" )");
        }
        buffer.append(" )");
    }

    public int getRuleID() {
        return this.ruleID;
    }

    public String[] getNames() {
        return this.names;
    }

    public String getNameOrRuleID() {
        if (this.names.length == 0) {
            return String.valueOf(this.ruleID);
        }
        return this.names[0];
    }

    public boolean hasNameOrRuleID(String s) {
        for (String name : this.names) {
            if (!s.equalsIgnoreCase(name)) continue;
            return true;
        }
        return s.equalsIgnoreCase(String.valueOf(this.ruleID));
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public String getNameFormID() {
        return this.nameFormID;
    }

    public int[] getSuperiorRuleIDs() {
        return this.superiorRuleIDs;
    }

    public Map<String, String[]> getExtensions() {
        return this.extensions;
    }

    @Override
    public int hashCode() {
        return this.ruleID;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof DITStructureRuleDefinition)) {
            return false;
        }
        DITStructureRuleDefinition d = (DITStructureRuleDefinition)o;
        if (this.ruleID == d.ruleID && this.nameFormID.equalsIgnoreCase(d.nameFormID) && StaticUtils.stringsEqualIgnoreCaseOrderIndependent(this.names, d.names) && this.isObsolete == d.isObsolete && DITStructureRuleDefinition.extensionsEqual(this.extensions, d.extensions)) {
            if (this.superiorRuleIDs.length != d.superiorRuleIDs.length) {
                return false;
            }
            HashSet<Integer> s1 = new HashSet<Integer>(this.superiorRuleIDs.length);
            HashSet<Integer> s2 = new HashSet<Integer>(this.superiorRuleIDs.length);
            for (int i : this.superiorRuleIDs) {
                s1.add(i);
            }
            for (int i : d.superiorRuleIDs) {
                s2.add(i);
            }
            return s1.equals(s2);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.ditStructureRuleString;
    }
}

