/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.appframework.miscutils;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class IconImageConverter
implements Converter {
    private static final Logger LOG = Logger.getLogger(IconImageConverter.class);

    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        ImageIcon image = (ImageIcon)object;
        int width = image.getIconWidth();
        int height = image.getIconHeight();
        int[] pixels = new int[width * height];
        if (image != null) {
            try {
                PixelGrabber pg = new PixelGrabber(image.getImage(), 0, 0, width, height, pixels, 0, width);
                pg.grabPixels();
                if ((pg.getStatus() & 0x80) != 0) {
                    LOG.error((Object)"Failed to load image contents");
                }
            }
            catch (InterruptedException e) {
                LOG.error((Object)"Image load interrupted");
            }
        }
        LOG.debug((Object)("Writing image to file: " + width + "x" + height));
        writer.addAttribute("width", Integer.toString(width));
        writer.addAttribute("height", Integer.toString(height));
        StringBuilder dataBuilder = new StringBuilder();
        int n = 0;
        for (int pixel : pixels) {
            dataBuilder.append(Integer.toString(pixel, 16));
            dataBuilder.append(",");
            if (++n % 16 != 0) continue;
            dataBuilder.append("\n");
        }
        writer.addAttribute("data", dataBuilder.toString());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        int width = Integer.parseInt(reader.getAttribute("width"));
        int height = Integer.parseInt(reader.getAttribute("height"));
        LOG.debug((Object)("Reading image from file: " + width + "x" + height));
        int[] pixels = new int[width * height];
        String data = reader.getAttribute("data").replace("\n", "");
        String[] splitData = data.split(",");
        for (int i = 0; i < Math.min(splitData.length, pixels.length); ++i) {
            if (splitData[i].trim().isEmpty()) continue;
            try {
                pixels[i] = Integer.parseInt(splitData[i].trim(), 16);
                continue;
            }
            catch (Exception e) {
                pixels[i] = 0;
            }
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        ColorModel colorModel = ColorModel.getRGBdefault();
        Image image = toolkit.createImage(new MemoryImageSource(width, height, colorModel, pixels, 0, width));
        return new ImageIcon(image);
    }

    public boolean canConvert(Class clazz) {
        return ImageIcon.class.isAssignableFrom(clazz);
    }
}

