/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.regions.util.HttpResourcesUtils;
import software.amazon.awssdk.regions.util.ResourcesEndpointProvider;
import software.amazon.awssdk.utils.ComparableUtils;
import software.amazon.awssdk.utils.DateUtils;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.cache.CachedSupplier;
import software.amazon.awssdk.utils.cache.NonBlocking;
import software.amazon.awssdk.utils.cache.RefreshResult;

@SdkProtectedApi
public abstract class HttpCredentialsProvider
implements AwsCredentialsProvider,
SdkAutoCloseable {
    private static final JsonNodeParser SENSITIVE_PARSER = JsonNodeParser.builder().removeErrorLocations(true).build();
    private final Optional<CachedSupplier<AwsCredentials>> credentialsCache;

    protected HttpCredentialsProvider(BuilderImpl<?, ?> builder) {
        this(((BuilderImpl)builder).asyncCredentialUpdateEnabled, ((BuilderImpl)builder).asyncThreadName);
    }

    HttpCredentialsProvider(boolean asyncCredentialUpdateEnabled, String asyncThreadName) {
        if (this.isLocalCredentialLoadingDisabled()) {
            this.credentialsCache = Optional.empty();
        } else {
            CachedSupplier.Builder cacheBuilder = CachedSupplier.builder(this::refreshCredentials);
            if (asyncCredentialUpdateEnabled) {
                cacheBuilder.prefetchStrategy((CachedSupplier.PrefetchStrategy)new NonBlocking(asyncThreadName));
            }
            this.credentialsCache = Optional.of(cacheBuilder.build());
        }
    }

    protected abstract ResourcesEndpointProvider getCredentialsEndpointProvider();

    protected boolean isLocalCredentialLoadingDisabled() {
        return false;
    }

    private RefreshResult<AwsCredentials> refreshCredentials() {
        try {
            String credentialsResponse = HttpResourcesUtils.instance().readResource(this.getCredentialsEndpointProvider());
            Map node = SENSITIVE_PARSER.parse(credentialsResponse).asObject();
            JsonNode accessKey = (JsonNode)node.get("AccessKeyId");
            JsonNode secretKey = (JsonNode)node.get("SecretAccessKey");
            JsonNode token = (JsonNode)node.get("Token");
            JsonNode expirationNode = (JsonNode)node.get("Expiration");
            Validate.notNull((Object)accessKey, (String)"Failed to load access key.", (Object[])new Object[0]);
            Validate.notNull((Object)secretKey, (String)"Failed to load secret key.", (Object[])new Object[0]);
            AwsBasicCredentials credentials = token == null ? AwsBasicCredentials.create(accessKey.text(), secretKey.text()) : AwsSessionCredentials.create(accessKey.text(), secretKey.text(), token.text());
            Instant expiration = this.getExpiration(expirationNode).orElse(null);
            if (expiration != null && Instant.now().isAfter(expiration)) {
                throw SdkClientException.builder().message("Credentials obtained from metadata service are already expired.").build();
            }
            return RefreshResult.builder((Object)credentials).staleTime(this.getStaleTime(expiration)).prefetchTime(this.getPrefetchTime(expiration)).build();
        }
        catch (SdkClientException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw SdkClientException.builder().message("Unable to load credentials from service endpoint.").cause((Throwable)e).build();
        }
    }

    private Optional<Instant> getExpiration(JsonNode expirationNode) {
        return Optional.ofNullable(expirationNode).map(node -> {
            String expirationValue = node.text().replaceAll("\\+0000$", "Z");
            try {
                return DateUtils.parseIso8601Date((String)expirationValue);
            }
            catch (RuntimeException e) {
                throw new IllegalStateException("Unable to parse credentials expiration date from metadata service.", e);
            }
        });
    }

    private Instant getStaleTime(Instant expiration) {
        return expiration == null ? null : expiration.minus(Duration.ofMinutes(1L));
    }

    private Instant getPrefetchTime(Instant expiration) {
        Instant oneHourFromNow = Instant.now().plus(Duration.ofHours(1L));
        return expiration == null ? oneHourFromNow : (Instant)ComparableUtils.minimum((Comparable[])new Instant[]{oneHourFromNow, expiration.minus(Duration.ofMinutes(15L))});
    }

    @Override
    public AwsCredentials resolveCredentials() {
        if (this.isLocalCredentialLoadingDisabled()) {
            throw SdkClientException.builder().message("Loading credentials from local endpoint is disabled. Unable to load credentials from service endpoint.").build();
        }
        return this.credentialsCache.map(CachedSupplier::get).orElseThrow(() -> SdkClientException.builder().message("Unable to load credentials from service endpoint").build());
    }

    public void close() {
        this.credentialsCache.ifPresent(CachedSupplier::close);
    }

    protected static abstract class BuilderImpl<TypeToBuildT extends HttpCredentialsProvider, BuilderT extends Builder>
    implements Builder<TypeToBuildT, BuilderT> {
        private boolean asyncCredentialUpdateEnabled = false;
        private String asyncThreadName;

        protected BuilderImpl() {
        }

        @Override
        public BuilderT asyncCredentialUpdateEnabled(Boolean asyncCredentialUpdateEnabled) {
            this.asyncCredentialUpdateEnabled = asyncCredentialUpdateEnabled;
            return (BuilderT)this;
        }

        public void setAsyncCredentialUpdateEnabled(boolean asyncCredentialUpdateEnabled) {
            this.asyncCredentialUpdateEnabled(asyncCredentialUpdateEnabled);
        }

        @Override
        public BuilderT asyncThreadName(String asyncThreadName) {
            this.asyncThreadName = asyncThreadName;
            return (BuilderT)this;
        }

        public void setAsyncThreadName(String asyncThreadName) {
            this.asyncThreadName(asyncThreadName);
        }
    }

    public static interface Builder<TypeToBuildT extends HttpCredentialsProvider, BuilderT extends Builder> {
        public BuilderT asyncCredentialUpdateEnabled(Boolean var1);

        public BuilderT asyncThreadName(String var1);

        public TypeToBuildT build();
    }
}

