/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.CachedHashDecoratedKey;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.dht.ComparableObjectToken;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.Pair;

public class OrderPreservingPartitioner
implements IPartitioner {
    public static final StringToken MINIMUM = new StringToken("");
    public static final BigInteger CHAR_MASK = new BigInteger("65535");
    private static final long EMPTY_SIZE = ObjectSizes.measure(MINIMUM);
    public static final OrderPreservingPartitioner instance = new OrderPreservingPartitioner();
    private final Token.TokenFactory tokenFactory = new Token.TokenFactory(){

        @Override
        public ByteBuffer toByteArray(Token token) {
            StringToken stringToken = (StringToken)token;
            return ByteBufferUtil.bytes((String)((Object)stringToken.token));
        }

        @Override
        public Token fromByteArray(ByteBuffer bytes) {
            try {
                return new StringToken(ByteBufferUtil.string(bytes));
            }
            catch (CharacterCodingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String toString(Token token) {
            StringToken stringToken = (StringToken)token;
            return (String)((Object)stringToken.token);
        }

        @Override
        public void validate(String token) throws ConfigurationException {
            if (token.contains(VersionedValue.DELIMITER_STR)) {
                throw new ConfigurationException("Tokens may not contain the character " + VersionedValue.DELIMITER_STR);
            }
        }

        @Override
        public Token fromString(String string) {
            return new StringToken(string);
        }
    };

    @Override
    public DecoratedKey decorateKey(ByteBuffer key) {
        return new CachedHashDecoratedKey(this.getToken(key), key);
    }

    @Override
    public StringToken midpoint(Token ltoken, Token rtoken) {
        int sigchars = Math.max(((String)((Object)((StringToken)ltoken).token)).length(), ((String)((Object)((StringToken)rtoken).token)).length());
        BigInteger left = OrderPreservingPartitioner.bigForString((String)((Object)((StringToken)ltoken).token), sigchars);
        BigInteger right = OrderPreservingPartitioner.bigForString((String)((Object)((StringToken)rtoken).token), sigchars);
        Pair<BigInteger, Boolean> midpair = FBUtilities.midpoint(left, right, 16 * sigchars);
        return new StringToken(this.stringForBig((BigInteger)midpair.left, sigchars, (Boolean)midpair.right));
    }

    private static BigInteger bigForString(String str, int sigchars) {
        assert (str.length() <= sigchars);
        BigInteger big = BigInteger.ZERO;
        for (int i = 0; i < str.length(); ++i) {
            int charpos = 16 * (sigchars - (i + 1));
            BigInteger charbig = BigInteger.valueOf(str.charAt(i) & 0xFFFF);
            big = big.or(charbig.shiftLeft(charpos));
        }
        return big;
    }

    private String stringForBig(BigInteger big, int sigchars, boolean remainder) {
        char[] chars = new char[sigchars + (remainder ? 1 : 0)];
        if (remainder) {
            int n = sigchars;
            chars[n] = (char)(chars[n] | 0x8000);
        }
        for (int i = 0; i < sigchars; ++i) {
            int maskpos = 16 * (sigchars - (i + 1));
            chars[i] = (char)(big.and(CHAR_MASK.shiftLeft(maskpos)).shiftRight(maskpos).intValue() & 0xFFFF);
        }
        return new String(chars);
    }

    @Override
    public StringToken getMinimumToken() {
        return MINIMUM;
    }

    @Override
    public StringToken getRandomToken() {
        String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random r = new Random();
        StringBuilder buffer = new StringBuilder();
        for (int j = 0; j < 16; ++j) {
            buffer.append(chars.charAt(r.nextInt(chars.length())));
        }
        return new StringToken(buffer.toString());
    }

    @Override
    public Token.TokenFactory getTokenFactory() {
        return this.tokenFactory;
    }

    @Override
    public boolean preservesOrder() {
        return true;
    }

    @Override
    public StringToken getToken(ByteBuffer key) {
        String skey;
        try {
            skey = ByteBufferUtil.string(key);
        }
        catch (CharacterCodingException e) {
            skey = ByteBufferUtil.bytesToHex(key);
        }
        return new StringToken(skey);
    }

    @Override
    public Map<Token, Float> describeOwnership(List<Token> sortedTokens) {
        HashMap<Token, Float> allTokens = new HashMap<Token, Float>();
        ArrayList<Range<Token>> sortedRanges = new ArrayList<Range<Token>>(sortedTokens.size());
        Token lastToken = sortedTokens.get(sortedTokens.size() - 1);
        for (Token node : sortedTokens) {
            allTokens.put(node, new Float(0.0));
            sortedRanges.add(new Range<Token>(lastToken, node));
            lastToken = node;
        }
        for (String ks : Schema.instance.getKeyspaces()) {
            for (CFMetaData cfmd : Schema.instance.getKSMetaData(ks).cfMetaData().values()) {
                for (Range range : sortedRanges) {
                    allTokens.put((Token)range.right, Float.valueOf(((Float)allTokens.get(range.right)).floatValue() + (float)StorageService.instance.getSplits(ks, cfmd.cfName, range, cfmd.getMinIndexInterval()).size()));
                }
            }
        }
        Float total = new Float(0.0);
        for (Float f : allTokens.values()) {
            total = Float.valueOf(total.floatValue() + f.floatValue());
        }
        for (Map.Entry entry : allTokens.entrySet()) {
            allTokens.put((Token)entry.getKey(), Float.valueOf(((Float)entry.getValue()).floatValue() / total.floatValue()));
        }
        return allTokens;
    }

    @Override
    public AbstractType<?> getTokenValidator() {
        return UTF8Type.instance;
    }

    public static class StringToken
    extends ComparableObjectToken<String> {
        static final long serialVersionUID = 5464084395277974963L;

        public StringToken(String token) {
            super(token);
        }

        @Override
        public IPartitioner getPartitioner() {
            return instance;
        }

        @Override
        public long getHeapSize() {
            return EMPTY_SIZE + ObjectSizes.sizeOf((String)((Object)this.token));
        }
    }
}

