/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.Font;
import java.util.List;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.omegat.util.Preferences;
import org.omegat.util.gui.FontFallbackManager;

public class FontFallbackListener
implements DocumentListener {
    private Font defaultFont;

    public FontFallbackListener(JTextComponent comp) {
        this.defaultFont = comp.getFont();
        comp.addPropertyChangeListener("font", evt -> {
            if (evt.getNewValue() != null && !evt.getNewValue().equals(evt.getOldValue())) {
                this.defaultFont = (Font)evt.getNewValue();
                Document doc = comp.getDocument();
                this.doStyling(doc, 0, doc.getLength());
            }
        });
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.doStyling(e.getDocument(), e.getOffset(), e.getLength());
    }

    private void doStyling(Document document, final int offset, final int length) {
        if (!Preferences.isPreference("font_fallback")) {
            return;
        }
        if (!(document instanceof StyledDocument)) {
            return;
        }
        final StyledDocument doc = (StyledDocument)document;
        new SwingWorker<Void, StyleRun>(){

            @Override
            protected Void doInBackground() throws Exception {
                Segment seg = new Segment();
                seg.setPartialReturn(true);
                int nleft = length;
                int offs = offset;
                try {
                    while (nleft > 0) {
                        doc.getText(offs, nleft, seg);
                        int i = seg.getBeginIndex();
                        while ((i = FontFallbackManager.canDisplayUpTo(FontFallbackListener.this.defaultFont, seg, i, seg.getEndIndex())) != -1) {
                            int ccn;
                            int cp = Character.codePointAt(seg, i - seg.getBeginIndex());
                            int start = i;
                            i += Character.charCount(cp);
                            Font font = FontFallbackManager.getCapableFont(cp);
                            if (font == null) continue;
                            for (int j = i; j < seg.getEndIndex(); j += ccn) {
                                int cpn = Character.codePointAt(seg, j - seg.getBeginIndex());
                                ccn = Character.charCount(cpn);
                                if (FontFallbackManager.canDisplay(FontFallbackListener.this.defaultFont, cpn) || !FontFallbackManager.canDisplay(font, cpn)) break;
                                i += ccn;
                            }
                            this.publish(new StyleRun(start, i - start, FontFallbackListener.this.getAttributes(font)));
                        }
                        nleft -= seg.count;
                        offs += seg.count;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                return null;
            }

            @Override
            protected void process(List<StyleRun> chunks) {
                for (StyleRun chunk : chunks) {
                    doc.setCharacterAttributes(chunk.start, chunk.length, chunk.attrs, false);
                }
            }
        }.execute();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private AttributeSet getAttributes(Font font) {
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attrs, font.getFamily());
        StyleConstants.setFontSize(attrs, this.defaultFont.getSize());
        return attrs;
    }

    private static class StyleRun {
        public final int start;
        public final int length;
        public final AttributeSet attrs;

        StyleRun(int start, int length, AttributeSet attrs) {
            this.start = start;
            this.length = length;
            this.attrs = attrs;
        }
    }
}

