/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.omegat.util.Platform;
import org.omegat.util.gui.NoWrapEditorKit;

public final class DataTableStyling {
    public static final Color COLOR_STANDARD_FG = UIManager.getColor("TextArea.foreground");
    public static final Color COLOR_STANDARD_BG = UIManager.getColor("TextArea.background");
    public static final Color COLOR_SELECTION_FG = UIManager.getColor("TextArea.selectionForeground");
    public static final Color COLOR_SELECTION_BG = UIManager.getColor("TextArea.selectionBackground");
    public static final Color COLOR_ALTERNATING_HILITE = UIManager.getColor("OmegaT.alternatingHilite");
    public static final Border TABLE_FOCUS_BORDER = new MatteBorder(1, 1, 1, 1, UIManager.getColor("TextArea.border"));
    public static final Border TABLE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    public static final DecimalFormat NUMBER_FORMAT = new DecimalFormat(",##0");
    public static final int FONT_NO_CHANGE = -1;
    public static final int LINE_SPACING = 6;

    private DataTableStyling() {
    }

    public static void applyColors(JTable table) {
        if (!Platform.isMacOSX()) {
            if (table.getParent() instanceof JViewport) {
                table.getParent().setBackground(COLOR_STANDARD_BG);
            }
            if (table.getParent().getParent() instanceof JScrollPane) {
                table.getParent().getParent().setBackground(COLOR_STANDARD_BG);
            }
            if (table.getTableHeader() != null) {
                table.getTableHeader().setBackground(COLOR_STANDARD_BG);
            }
        }
        table.setForeground(COLOR_STANDARD_FG);
        table.setBackground(COLOR_STANDARD_BG);
        table.setSelectionForeground(COLOR_SELECTION_FG);
        table.setSelectionBackground(COLOR_SELECTION_BG);
        table.setGridColor(COLOR_STANDARD_BG);
    }

    public static void applyFont(JTable table, Font font) {
        table.setFont(font);
        table.setRowHeight(font.getSize() + 6);
    }

    public static TableCellRenderer getNumberCellRenderer() {
        return new AlternatingHighlightRenderer().setAlignment(4).setNumberFormat(NUMBER_FORMAT);
    }

    public static TableCellRenderer getTextCellRenderer() {
        return new AlternatingHighlightRenderer();
    }

    public static TableCellRenderer getHeaderTextCellRenderer() {
        return new AlternatingHighlightRenderer().setFontStyle(1);
    }

    public static class PatternHighlightRenderer
    extends FancyRenderer<JTextPane> {
        private static final Color HIGHLIGHT_FG_COLOR = Color.BLACK;
        private static final Color HIGHLIGHT_BG_COLOR = Color.YELLOW;
        private static final AttributeSet EMPTY_ATTR = new SimpleAttributeSet();
        private static final AttributeSet HIGHLIGHT_ATTR;
        private final JTextPane component = new JTextPane();
        private Pattern pattern;

        public PatternHighlightRenderer(boolean lineWrapEnabled) {
            if (!lineWrapEnabled) {
                this.component.setEditorKit(new NoWrapEditorKit());
            }
        }

        public PatternHighlightRenderer setPattern(Pattern pattern) {
            this.pattern = pattern;
            return this;
        }

        @Override
        protected JTextPane getComponent() {
            return this.component;
        }

        @Override
        protected void applyValue(String value) {
            this.component.setText(value);
            if (value != null) {
                this.doHighlighting(value);
            }
        }

        void doHighlighting(String text) {
            StyledDocument doc = this.component.getStyledDocument();
            doc.setCharacterAttributes(0, text.length(), EMPTY_ATTR, true);
            if (this.pattern != null) {
                Matcher m = this.pattern.matcher(text);
                while (m.find()) {
                    doc.setCharacterAttributes(m.start(), m.end() - m.start(), HIGHLIGHT_ATTR, true);
                }
            }
        }

        static {
            SimpleAttributeSet sas = new SimpleAttributeSet();
            StyleConstants.setBackground(sas, HIGHLIGHT_BG_COLOR);
            StyleConstants.setForeground(sas, HIGHLIGHT_FG_COLOR);
            HIGHLIGHT_ATTR = sas;
        }
    }

    public static class AlternatingHighlightRenderer
    extends FancyRenderer<DefaultTableCellRenderer> {
        private final DefaultTableCellRenderer component = new DefaultTableCellRenderer();

        public AlternatingHighlightRenderer setAlignment(int alignment) {
            this.component.setHorizontalAlignment(alignment);
            return this;
        }

        @Override
        protected DefaultTableCellRenderer getComponent() {
            return this.component;
        }

        @Override
        protected void applyValue(String value) {
            this.component.setText(value);
        }
    }

    public static abstract class FancyRenderer<T extends JComponent>
    implements TableCellRenderer {
        private NumberFormat numberFormat = null;
        private boolean doHighlight = true;
        private int fontStyle = -1;

        public FancyRenderer<T> setNumberFormat(NumberFormat numberFormat) {
            this.numberFormat = numberFormat;
            return this;
        }

        public FancyRenderer<T> setDoHighlight(boolean doHighlight) {
            this.doHighlight = doHighlight;
            return this;
        }

        public FancyRenderer<T> setFontStyle(int fontStyle) {
            this.fontStyle = fontStyle;
            return this;
        }

        protected String transformValue(Object value) {
            if (value == null) {
                return null;
            }
            if (this.numberFormat != null) {
                if (value instanceof Number) {
                    return this.numberFormat.format((Number)value);
                }
                if (value instanceof String) {
                    try {
                        long lVal = Long.parseLong((String)value);
                        return this.numberFormat.format(lVal);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return value.toString();
        }

        protected abstract T getComponent();

        protected abstract void applyValue(String var1);

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            T result = this.getComponent();
            Font font = table.getFont();
            if (this.fontStyle != -1) {
                font = font.deriveFont(this.fontStyle);
            }
            ((JComponent)result).setFont(font);
            if (isSelected) {
                ((JComponent)result).setForeground(table.getSelectionForeground());
                ((JComponent)result).setBackground(table.getSelectionBackground());
            } else if (row % 2 != 0 && this.doHighlight) {
                ((JComponent)result).setForeground(table.getForeground());
                ((JComponent)result).setBackground(COLOR_ALTERNATING_HILITE);
            } else {
                ((JComponent)result).setForeground(table.getForeground());
                ((JComponent)result).setBackground(table.getBackground());
            }
            ((JComponent)result).setBorder(hasFocus ? TABLE_FOCUS_BORDER : TABLE_NO_FOCUS_BORDER);
            this.applyValue(this.transformValue(value));
            return result;
        }
    }
}

