/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import gen.core.project.Masks;
import gen.core.project.Omegat;
import gen.core.project.Project;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.omegat.core.data.ProjectProperties;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public final class ProjectFileStorage {
    public static final String DEFAULT_FOLDER_MARKER = "__DEFAULT__";
    private static final JAXBContext CONTEXT;

    private ProjectFileStorage() {
    }

    public static Omegat parseProjectFile(File file) throws Exception {
        return ProjectFileStorage.parseProjectFile(FileUtils.readFileToByteArray((File)file));
    }

    public static Omegat parseProjectFile(byte[] projectFile) throws Exception {
        return (Omegat)CONTEXT.createUnmarshaller().unmarshal(new ByteArrayInputStream(projectFile));
    }

    public static ProjectProperties loadProjectProperties(File projectDir) throws Exception {
        return ProjectFileStorage.loadPropertiesFile(projectDir, new File(projectDir, "omegat.project"));
    }

    public static ProjectProperties loadPropertiesFile(File projectDir, File projectFile) throws Exception {
        if (!projectFile.isFile()) {
            throw new IllegalArgumentException("Project file " + projectFile + " was not a file");
        }
        Omegat om = ProjectFileStorage.parseProjectFile(projectFile);
        return ProjectFileStorage.loadPropertiesFile(projectDir, om);
    }

    static ProjectProperties loadPropertiesFile(File projectDir, Omegat om) throws Exception {
        if (!projectDir.isDirectory()) {
            throw new IllegalArgumentException("Project directory was not a directory");
        }
        ProjectProperties result = new ProjectProperties(projectDir);
        if (!"1.0".equals(om.getProject().getVersion())) {
            throw new TranslationException(StringUtil.format(OStrings.getString("PFR_ERROR_UNSUPPORTED_PROJECT_VERSION"), om.getProject().getVersion()));
        }
        result.setTargetRoot(ProjectFileStorage.normalizeLoadedPath(om.getProject().getTargetDir(), "target"));
        result.setSourceRoot(ProjectFileStorage.normalizeLoadedPath(om.getProject().getSourceDir(), "source"));
        result.getSourceRootExcludes().clear();
        if (om.getProject().getSourceDirExcludes() != null) {
            result.getSourceRootExcludes().addAll(om.getProject().getSourceDirExcludes().getMask());
        } else {
            result.getSourceRootExcludes().addAll(ProjectProperties.getDefaultExcludes());
        }
        result.setTMRoot(ProjectFileStorage.normalizeLoadedPath(om.getProject().getTmDir(), "tm"));
        result.setExportTMRoot(ProjectFileStorage.normalizeLoadedPath(om.getProject().getExportTmDir(), ""));
        result.setExportTmLevels(ProjectFileStorage.normalizeLoadedExportTmLevels(om.getProject().getExportTmLevels(), "omegat level1 level2"));
        result.setGlossaryRoot(ProjectFileStorage.normalizeLoadedPath(om.getProject().getGlossaryDir(), "glossary"));
        Object glossaryFile = om.getProject().getGlossaryFile();
        if (StringUtil.isEmpty((String)glossaryFile)) {
            glossaryFile = DEFAULT_FOLDER_MARKER;
        }
        glossaryFile = ((String)glossaryFile).equalsIgnoreCase(DEFAULT_FOLDER_MARKER) ? result.computeDefaultWriteableGlossaryFile() : result.getGlossaryDir().getAsString() + (String)glossaryFile;
        result.setWriteableGlossary((String)glossaryFile);
        result.setDictRoot(ProjectFileStorage.normalizeLoadedPath(om.getProject().getDictionaryDir(), "dictionary"));
        result.setSourceLanguage(om.getProject().getSourceLang());
        result.setTargetLanguage(om.getProject().getTargetLang());
        result.setSourceTokenizer(ProjectFileStorage.loadTokenizer(om.getProject().getSourceTok(), result.getSourceLanguage()));
        result.setTargetTokenizer(ProjectFileStorage.loadTokenizer(om.getProject().getTargetTok(), result.getTargetLanguage()));
        if (om.getProject().isSentenceSeg() != null) {
            result.setSentenceSegmentingEnabled(om.getProject().isSentenceSeg());
        }
        if (om.getProject().isSupportDefaultTranslations() != null) {
            result.setSupportDefaultTranslations(om.getProject().isSupportDefaultTranslations());
        }
        if (om.getProject().isRemoveTags() != null) {
            result.setRemoveTags(om.getProject().isRemoveTags());
        }
        if (om.getProject().getExternalCommand() != null) {
            result.setExternalCommand(om.getProject().getExternalCommand());
        }
        if (om.getProject().getRepositories() != null) {
            result.setRepositories(om.getProject().getRepositories().getRepository());
        }
        return result;
    }

    public static void writeProjectFile(ProjectProperties props) throws Exception {
        ProjectFileStorage.writeProjectFile(new File(props.getProjectRoot(), "omegat.project"), props);
    }

    public static void writeProjectFile(File outFile, ProjectProperties props) throws Exception {
        String root = outFile.getAbsoluteFile().getParent();
        Omegat om = new Omegat();
        om.setProject(new Project());
        om.getProject().setVersion("1.0");
        om.getProject().setSourceDir(ProjectFileStorage.getPathForStoring(root, props.getSourceRoot(), "source"));
        om.getProject().setSourceDirExcludes(new Masks());
        om.getProject().getSourceDirExcludes().getMask().addAll(props.getSourceRootExcludes());
        om.getProject().setTargetDir(ProjectFileStorage.getPathForStoring(root, props.getTargetRoot(), "target"));
        om.getProject().setTmDir(ProjectFileStorage.getPathForStoring(root, props.getTMRoot(), "tm"));
        om.getProject().setExportTmDir(ProjectFileStorage.getPathForStoring(root, props.getExportTMRoot(), ""));
        om.getProject().setExportTmLevels(String.join((CharSequence)" ", props.getExportTmLevels()));
        String glossaryDir = ProjectFileStorage.getPathForStoring(root, props.getGlossaryRoot(), "glossary");
        om.getProject().setGlossaryDir(glossaryDir);
        String glossaryFile = ProjectFileStorage.getPathForStoring(props.getGlossaryRoot(), props.getWriteableGlossary(), null);
        if (glossaryDir.equalsIgnoreCase(DEFAULT_FOLDER_MARKER) && props.isDefaultWriteableGlossaryFile()) {
            glossaryFile = DEFAULT_FOLDER_MARKER;
        }
        om.getProject().setGlossaryFile(glossaryFile);
        om.getProject().setDictionaryDir(ProjectFileStorage.getPathForStoring(root, props.getDictRoot(), "dictionary"));
        om.getProject().setSourceLang(props.getSourceLanguage().toString());
        om.getProject().setTargetLang(props.getTargetLanguage().toString());
        om.getProject().setSourceTok(props.getSourceTokenizer().getCanonicalName());
        om.getProject().setTargetTok(props.getTargetTokenizer().getCanonicalName());
        om.getProject().setSentenceSeg(props.isSentenceSegmentingEnabled());
        om.getProject().setSupportDefaultTranslations(props.isSupportDefaultTranslations());
        om.getProject().setRemoveTags(props.isRemoveTags());
        om.getProject().setExternalCommand(props.getExternalCommand());
        if (props.getRepositories() != null && !props.getRepositories().isEmpty()) {
            om.getProject().setRepositories(new Project.Repositories());
            om.getProject().getRepositories().getRepository().addAll(props.getRepositories());
        }
        Marshaller m = CONTEXT.createMarshaller();
        m.setProperty("jaxb.formatted.output", true);
        m.marshal((Object)om, outFile);
    }

    private static String normalizeLoadedPath(String path, String defaultValue) {
        if (StringUtil.isEmpty(path) || DEFAULT_FOLDER_MARKER.equals(path)) {
            return defaultValue;
        }
        return ProjectFileStorage.normalizeSlashes(path);
    }

    private static List<String> normalizeLoadedExportTmLevels(String levels, String defaultValue) {
        String normalizedLevels = levels;
        if (levels == null) {
            normalizedLevels = defaultValue;
        }
        return StringUtil.convertToList(normalizedLevels.toLowerCase());
    }

    private static String getPathForStoring(String root, String absolutePath, String defaultName) {
        if (defaultName != null && new File(absolutePath).equals(new File(root, defaultName))) {
            return DEFAULT_FOLDER_MARKER;
        }
        String result = absolutePath;
        try {
            Path absPath = Paths.get(absolutePath, new String[0]).normalize();
            String rel = Paths.get(root, new String[0]).relativize(absPath).toString();
            result = StringUtils.countMatches((String)rel, (String)(".." + File.separatorChar)) <= 5 ? rel : absPath.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return ProjectFileStorage.normalizeSlashes(result);
    }

    private static Class<?> loadTokenizer(String className, Language fallback) {
        if (!StringUtil.isEmpty(className)) {
            try {
                return ProjectFileStorage.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                Log.log(e.toString());
            }
        }
        return PluginUtils.getTokenizerClassForLanguage(fallback);
    }

    static String normalizeSlashes(String path) {
        return ProjectFileStorage.withoutTrailingSlash(path.replace('\\', '/'));
    }

    static String withoutTrailingSlash(String path) {
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    static {
        try {
            CONTEXT = JAXBContext.newInstance(Omegat.class);
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }
}

