/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.function.Function;
import org.omegat.util.StringUtil;

public final class OStrings {
    public static final String BRANDING = "";
    public static final String VERSION;
    public static final String UPDATE;
    public static final String REVISION;
    public static final boolean IS_BETA;
    private static ResourceBundle bundle;

    private OStrings() {
    }

    public static ResourceBundle getResourceBundle() {
        return bundle;
    }

    public static void loadBundle(String filename) {
        boolean loaded = false;
        try {
            FileInputStream in = new FileInputStream(filename);
            bundle = new PropertyResourceBundle(in);
            loaded = true;
            in.close();
        }
        catch (FileNotFoundException exception) {
            System.err.println("Resource bundle file not found: " + filename);
        }
        catch (IOException exception) {
            System.err.println("Error while reading resource bundle file: " + filename);
        }
        if (!loaded) {
            System.err.println("Reverting to resource bundle for the default locale");
            bundle = ResourceBundle.getBundle("org/omegat/Bundle");
        }
    }

    public static String getString(String key) {
        return bundle.getString(key);
    }

    public static String getString(String key, Object ... formatArgs) {
        return StringUtil.format(OStrings.getString(key), formatArgs);
    }

    public static String getApplicationDisplayName() {
        String name = bundle.getString("application-name");
        return BRANDING.isEmpty() ? name : name + " ";
    }

    public static String getApplicationName() {
        String name = bundle.getString("application-name");
        return BRANDING.isEmpty() ? name : name + "_";
    }

    public static String getBrandingToken() {
        return BRANDING.isEmpty() ? BRANDING : "-";
    }

    public static String getDisplayNameAndVersion() {
        if (UPDATE != null && !UPDATE.equals("0")) {
            return StringUtil.format(OStrings.getString("app-version-template-pretty-update"), OStrings.getApplicationDisplayName(), VERSION, UPDATE);
        }
        return StringUtil.format(OStrings.getString("app-version-template-pretty"), OStrings.getApplicationDisplayName(), VERSION);
    }

    public static String getNameAndVersion() {
        return StringUtil.format(OStrings.getString("app-version-template"), OStrings.getApplicationName(), VERSION, UPDATE, REVISION);
    }

    public static String getVersion() {
        return StringUtil.format(OStrings.getString("version-template"), VERSION, UPDATE, REVISION);
    }

    public static String getSimpleVersion() {
        return OStrings.getSimpleVersion(VERSION, UPDATE);
    }

    public static String getSimpleVersion(String version, String update) {
        if (update != null && !update.equals("0")) {
            return OStrings.getString("version-template-simple", version, update);
        }
        return version;
    }

    public static String getProgressBarDefaultPrecentageText() {
        return StringUtil.format(OStrings.getString("MW_PROGRESS_DEFAULT_PERCENTAGE"), "--%", "--", "--%", "--", "--");
    }

    public static String getSegmentMarker() {
        return OStrings.getString("TF_CUR_SEGMENT_START");
    }

    public static void validateVersion(Function<String, String> map) {
        String version = map.apply("version");
        String update = map.apply("update");
        String revision = map.apply("revision");
        String beta = map.apply("beta");
        if (version == null) {
            throw new IllegalArgumentException("Field 'version' must not be null");
        }
        if (update == null) {
            throw new IllegalArgumentException("Field 'update' must not be null");
        }
        if (revision == null) {
            throw new IllegalArgumentException("Field 'revision' must not be null");
        }
        if (beta == null) {
            throw new IllegalArgumentException("Field 'beta' must not be null");
        }
        if (version.split("\\.").length != 3) {
            throw new IllegalArgumentException("Field 'version' must be 3 parts");
        }
        if (!beta.isEmpty() && !"_Beta".equals(beta)) {
            throw new IllegalArgumentException("Field 'beta' must be empty or '_Beta'");
        }
    }

    static {
        ResourceBundle b = ResourceBundle.getBundle("org/omegat/Version");
        OStrings.validateVersion(b::getString);
        VERSION = b.getString("version");
        UPDATE = b.getString("update");
        REVISION = b.getString("revision");
        IS_BETA = !b.getString("beta").isEmpty();
        bundle = ResourceBundle.getBundle("org/omegat/Bundle");
    }
}

