/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.segmentation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.omegat.core.segmentation.LanguageCodes;
import org.omegat.core.segmentation.Rule;
import org.omegat.util.StringUtil;

public class MapRule
implements Serializable {
    private static final long serialVersionUID = -5868132953113679291L;
    private String languageCode;
    private Pattern pattern;
    private List<Rule> rules;

    public MapRule() {
    }

    public MapRule(String language, String pattern, List<Rule> rules) {
        this.setLanguage(language);
        this.setPattern(pattern);
        this.setRules(rules);
    }

    public String getLanguage() {
        String res = LanguageCodes.getLanguageName(this.languageCode);
        return StringUtil.isEmpty(res) ? this.languageCode : res;
    }

    public void setLanguage(String language) {
        this.languageCode = language;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public String getPattern() {
        if (this.pattern != null) {
            return this.pattern.pattern();
        }
        return null;
    }

    public Pattern getCompiledPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) throws PatternSyntaxException {
        this.pattern = Pattern.compile(pattern, 2);
    }

    public MapRule copy() {
        MapRule result = new MapRule();
        result.languageCode = this.languageCode;
        result.pattern = this.pattern;
        result.rules = new ArrayList<Rule>(this.rules.size());
        for (Rule rule : this.rules) {
            result.rules.add(rule.copy());
        }
        return result;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MapRule)) {
            return false;
        }
        MapRule that = (MapRule)obj;
        return this.getPattern().equals(that.getPattern()) && this.getLanguage().equals(that.getLanguage()) && this.getRules().equals(that.getRules());
    }

    public int hashCode() {
        return this.getPattern().hashCode() + this.getLanguage().hashCode() + this.getRules().hashCode();
    }

    public String toString() {
        return this.getLanguage() + " (" + this.getPattern() + ") " + this.getRules().toString();
    }
}

