/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import org.newsclub.net.unix.AFUNIXServerSocketChannel;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketImpl;
import org.newsclub.net.unix.Closeables;
import org.newsclub.net.unix.FileDescriptorAccess;
import org.newsclub.net.unix.NativeUnixSocket;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFUNIXServerSocket
extends ServerSocket
implements FileDescriptorAccess {
    private final AFUNIXSocketImpl implementation;
    private AFUNIXSocketAddress boundEndpoint;
    private final Closeables closeables = new Closeables();
    private final AtomicBoolean created = new AtomicBoolean(false);
    private final AtomicBoolean deleteOnClose = new AtomicBoolean(true);
    private final AFUNIXServerSocketChannel channel = new AFUNIXServerSocketChannel(this);

    protected AFUNIXServerSocket() throws IOException {
        this((FileDescriptor)null);
    }

    AFUNIXServerSocket(FileDescriptor fdObj) throws IOException {
        this.implementation = new AFUNIXSocketImpl(fdObj);
        NativeUnixSocket.initServerImpl(this, this.implementation);
        this.setReuseAddress(true);
    }

    public static AFUNIXServerSocket newInstance() throws IOException {
        return new AFUNIXServerSocket(null);
    }

    public static AFUNIXServerSocket newInstance(FileDescriptor fdObj, int localPort, int remotePort) throws IOException {
        if (fdObj == null) {
            return AFUNIXServerSocket.newInstance();
        }
        int status = NativeUnixSocket.socketStatus(fdObj);
        if (!fdObj.valid() || status == -1) {
            throw new SocketException("Not a valid socket");
        }
        AFUNIXServerSocket socket = new AFUNIXServerSocket(fdObj);
        socket.getAFImpl().updatePorts(localPort, remotePort);
        switch (status) {
            case 2: {
                throw new SocketException("Not a ServerSocket");
            }
            case 1: {
                socket.bind(AFUNIXSocketAddress.INTERNAL_DUMMY_BIND);
                socket.setBoundEndpoint(AFUNIXSocketAddress.getSocketAddress(fdObj, false, localPort));
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException("Invalid socketStatus response: " + status);
            }
        }
        socket.getAFImpl().setSocketAddress(socket.getLocalSocketAddress());
        return socket;
    }

    public static AFUNIXServerSocket bindOn(AFUNIXSocketAddress addr) throws IOException {
        AFUNIXServerSocket socket = AFUNIXServerSocket.newInstance();
        socket.bind(addr);
        return socket;
    }

    public static AFUNIXServerSocket bindOn(AFUNIXSocketAddress addr, boolean deleteOnClose) throws IOException {
        AFUNIXServerSocket socket = AFUNIXServerSocket.newInstance();
        socket.bind(addr);
        socket.setDeleteOnClose(deleteOnClose);
        return socket;
    }

    public static AFUNIXServerSocket bindOn(File path, boolean deleteOnClose) throws IOException {
        return AFUNIXServerSocket.bindOn(path.toPath(), deleteOnClose);
    }

    public static AFUNIXServerSocket bindOn(Path path, boolean deleteOnClose) throws IOException {
        AFUNIXServerSocket socket = AFUNIXServerSocket.newInstance();
        socket.setDeleteOnClose(deleteOnClose);
        socket.bind(AFUNIXSocketAddress.of(path));
        return socket;
    }

    public static AFUNIXServerSocket forceBindOn(final AFUNIXSocketAddress forceAddr) throws IOException {
        return new AFUNIXServerSocket(null){

            @Override
            public void bind(SocketAddress ignored, int backlog) throws IOException {
                super.bind(forceAddr, backlog);
            }
        };
    }

    @Override
    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isBound()) {
            throw new SocketException("Already bound");
        }
        if (!(endpoint instanceof AFUNIXSocketAddress)) {
            throw new IllegalArgumentException("Can only bind to endpoints of type " + AFUNIXSocketAddress.class.getName());
        }
        this.getAFImpl().bind(endpoint, this.getReuseAddress() ? -1 : 0);
        this.setBoundEndpoint((AFUNIXSocketAddress)endpoint);
        if (endpoint == AFUNIXSocketAddress.INTERNAL_DUMMY_BIND) {
            return;
        }
        this.implementation.listen(backlog);
    }

    @Override
    public boolean isBound() {
        return this.boundEndpoint != null;
    }

    @Override
    public boolean isClosed() {
        return super.isClosed() || this.isBound() && !this.implementation.getFD().valid();
    }

    @Override
    public AFUNIXSocket accept() throws IOException {
        AFUNIXSocket as = this.newSocketInstance();
        boolean success = this.implementation.accept0(as.getAFImpl());
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!success) {
            return null;
        }
        as.connect(AFUNIXSocketAddress.INTERNAL_DUMMY_CONNECT);
        as.getAFImpl().updatePorts(this.getAFImpl().getLocalPort1(), this.getAFImpl().getRemotePort());
        return as;
    }

    protected AFUNIXSocket newSocketInstance() throws IOException {
        return AFUNIXSocket.newInstance();
    }

    @Override
    public String toString() {
        return "AFUNIXServerSocket[" + (this.isBound() ? this.boundEndpoint.toString() : "unbound") + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        AFUNIXSocketAddress endpoint = this.boundEndpoint;
        IOException superException = null;
        try {
            super.close();
        }
        catch (IOException e) {
            superException = e;
        }
        if (this.implementation != null) {
            try {
                this.implementation.close();
            }
            catch (IOException e) {
                if (superException == null) {
                    superException = e;
                }
                superException.addSuppressed(e);
            }
        }
        IOException ex = null;
        try {
            this.closeables.close(superException);
        }
        finally {
            File f;
            if (endpoint != null && endpoint.hasFilename() && this.isDeleteOnClose() && !(f = endpoint.getFile()).delete() && f.exists()) {
                ex = new IOException("Could not delete socket file after close: " + f);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public void addCloseable(Closeable closeable) {
        this.closeables.add(closeable);
    }

    public void removeCloseable(Closeable closeable) {
        this.closeables.remove(closeable);
    }

    public static boolean isSupported() {
        return NativeUnixSocket.isLoaded();
    }

    @Override
    public AFUNIXSocketAddress getLocalSocketAddress() {
        return this.boundEndpoint;
    }

    void setBoundEndpoint(AFUNIXSocketAddress addr) {
        this.boundEndpoint = addr;
        this.getAFImpl().updatePorts(addr.getPort(), -1);
    }

    @Override
    public int getLocalPort() {
        if (this.boundEndpoint == null) {
            return -1;
        }
        return this.getAFImpl().getLocalPort1();
    }

    public boolean isDeleteOnClose() {
        return this.deleteOnClose.get();
    }

    public void setDeleteOnClose(boolean b) {
        this.deleteOnClose.set(b);
    }

    AFUNIXSocketImpl getAFImpl() {
        if (this.created.compareAndSet(false, true)) {
            try {
                this.getSoTimeout();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.implementation;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public AFUNIXServerSocketChannel getChannel() {
        return this.channel;
    }

    @Override
    public FileDescriptor getFileDescriptor() throws IOException {
        return this.implementation.getFileDescriptor();
    }
}

