/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
 * SPDX-License-Identifier: MIT
 */

#ifndef VSYNC_ATOMIC_H
#define VSYNC_ATOMIC_H
/*******************************************************************************
 * @file atomic.h
 * @brief Rich interface of atomic operations and fences
 *
 * Atomics are implemented in custom assembly or compiler builtins.
 *
 * - check core.h for the documentation of the core interface.
 * - check await.h for the documentation of the await interface.
 * - check config.h to learn about libvsync available configurations.
 * - check atomic/dispatch.h an additional dispatch layer allows for a more
 * flexible use of the interface.
 ******************************************************************************/

#include <vsync/atomic/await.h>
#include <vsync/atomic/core.h>
#include <vsync/atomic/dispatch.h>

#endif /* VSYNC_ATOMIC_H */
