/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.fife.ui.BevelDividerBorder;
import org.fife.ui.SizeGrip;
import org.fife.ui.StatusBarPanel;

public class StatusBar
extends StatusBarPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    public static final String STYLE_PROPERTY = "StatusBar.style";
    public static final int WINDOWS_98_STYLE = 0;
    public static final int WINDOWS_XP_STYLE = 1;
    private static final int MIN_STYLE_CONSTANT = 0;
    private static final int MAX_STYLE_CONSTANT = 1;
    public static final String DEFAULT_STATUS_MESSAGE = "Ready";
    private JLabel statusMessage;
    private String defaultMessage;
    private GridBagLayout gridBag;
    private SizeGrip sizeGrip;

    public StatusBar() {
        this(DEFAULT_STATUS_MESSAGE);
    }

    public StatusBar(String defaultStatusMessage) {
        this(defaultStatusMessage, 1);
    }

    public StatusBar(String defaultStatusMessage, int style) {
        this.defaultMessage = defaultStatusMessage;
        this.statusMessage = new JLabel(defaultStatusMessage);
        this.gridBag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(this.gridBag);
        c.fill = 1;
        c.weightx = 1.0;
        StatusBarPanel status = new StatusBarPanel((LayoutManager)new GridLayout(1, 1, 8, 8), this.statusMessage);
        this.gridBag.setConstraints(status, c);
        this.add(status);
        this.sizeGrip = new SizeGrip();
        c.weightx = 0.0;
        this.gridBag.setConstraints(this.sizeGrip, c);
        this.add(this.sizeGrip);
        this.setStyle(style);
        this.setBorder(this.getStatusBarBorder());
    }

    public void addStatusBarComponent(StatusBarPanel panel, int index, GridBagConstraints constraints) {
        this.gridBag.setConstraints(panel, constraints);
        panel.setBorder(this.getStatusBarComponentBorder());
        if (++index < 1) {
            index = 1;
        } else if (index > this.getComponentCount() - this.fromRight()) {
            index = this.getComponentCount() - this.fromRight();
        }
        this.add((Component)panel, index);
        this.revalidate();
    }

    public void addStatusBarComponent(StatusBarPanel panel, GridBagConstraints constraints) {
        int index = this.getComponentCount() - this.fromRight();
        this.addStatusBarComponent(panel, index, constraints);
    }

    public void applyComponentOrientation(ComponentOrientation o) {
        super.applyComponentOrientation(o);
        this.setBorder(this.getStatusBarBorder());
    }

    private final int fromRight() {
        if (this.getStyle() == 1) {
            return 2;
        }
        return 1;
    }

    public String getDefaultStatusMessage() {
        return this.defaultMessage;
    }

    private Border getStatusBarBorder() {
        if (this.getComponentOrientation().isLeftToRight()) {
            return BorderFactory.createEmptyBorder(0, 5, 0, 0);
        }
        return BorderFactory.createEmptyBorder(0, 0, 0, 5);
    }

    private Border getStatusBarComponentBorder() {
        switch (this.getStyle()) {
            case 0: {
                return BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(0, 3, 0, 3));
            }
            case 1: {
                return BorderFactory.createCompoundBorder(new BevelDividerBorder(2, 2), BorderFactory.createEmptyBorder(0, 3, 0, 3));
            }
        }
        return null;
    }

    public String getStatusMessage() {
        return this.statusMessage.getText();
    }

    public int getStyle() {
        return this.sizeGrip.getSizeGripIcon().getStyle();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        Action a;
        Component c = e.getComponent();
        String description = null;
        if (c instanceof AbstractButton && (a = ((AbstractButton)c).getAction()) != null) {
            description = (String)a.getValue("ShortDescription");
        }
        if (description == null) {
            description = c.getAccessibleContext().getAccessibleDescription();
        }
        if (description != null) {
            this.setStatusMessage(description);
        }
    }

    public final void mouseExited(MouseEvent e) {
        this.setStatusMessage(this.getDefaultStatusMessage());
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void setStatusMessage(String newMessage) {
        this.statusMessage.setText(newMessage);
        this.statusMessage.paintImmediately(this.statusMessage.getBounds());
    }

    public void setStyle(int style) {
        int oldStyle;
        if (style < 0 || style > 1) {
            style = 0;
        }
        if ((oldStyle = this.sizeGrip.getSizeGripIcon().getStyle()) != style) {
            this.sizeGrip.getSizeGripIcon().setStyle(style);
            Component[] comps = this.getComponents();
            int count = comps.length;
            if (this.sizeGrip != null) {
                --count;
            }
            for (int i = 1; i < count; ++i) {
                ((JComponent)comps[i]).setBorder(this.getStatusBarComponentBorder());
            }
            switch (style) {
                case 0: {
                    if (oldStyle != 1) break;
                    this.remove(count - 1);
                    break;
                }
                case 1: {
                    GridBagConstraints c = new GridBagConstraints();
                    c.fill = 1;
                    c.weightx = 0.0;
                    StatusBarPanel filler = new StatusBarPanel();
                    this.gridBag.setConstraints(filler, c);
                    this.add((Component)filler, count);
                }
            }
        }
    }
}

