/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.api.renderers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.TreeCellRenderer;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceTreeUI;
import org.jvnet.substance.api.ColorSchemeAssociationKind;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceApi;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.renderers.SubstanceRenderer;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceImageCreator;
import org.jvnet.substance.utils.SubstanceStripingUtils;

@SubstanceApi
@SubstanceRenderer
public class SubstanceDefaultTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private JTree tree;
    protected boolean selected;
    protected boolean hasFocus;

    public SubstanceDefaultTreeCellRenderer() {
        this.setHorizontalAlignment(2);
        this.putClientProperty("substancelaf.colorizationFactor", 1.0);
    }

    public Icon getDefaultOpenIcon() {
        return UIManager.getIcon("Tree.openIcon");
    }

    public Icon getDefaultClosedIcon() {
        return UIManager.getIcon("Tree.closedIcon");
    }

    public Icon getDefaultLeafIcon() {
        return UIManager.getIcon("Tree.leafIcon");
    }

    @Override
    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    @Override
    public Font getFont() {
        Font font = super.getFont();
        if (font == null && this.tree != null) {
            font = this.tree.getFont();
        }
        return font;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        SubstanceTreeUI ui;
        String stringValue = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
        this.tree = tree;
        this.hasFocus = hasFocus;
        this.setText(stringValue);
        TreeUI treeUI = tree.getUI();
        if (treeUI instanceof SubstanceTreeUI) {
            SubstanceColorScheme scheme;
            ui = (SubstanceTreeUI)treeUI;
            SubstanceTreeUI.TreePathId pathId = new SubstanceTreeUI.TreePathId(tree.getPathForRow(row));
            ComponentState state = ui.getPathState(pathId);
            ComponentState prevState = ui.getPrevPathState(pathId);
            SubstanceColorScheme substanceColorScheme = scheme = state == ComponentState.DEFAULT ? ui.getDefaultColorScheme() : SubstanceColorSchemeUtilities.getColorScheme(tree, ColorSchemeAssociationKind.HIGHLIGHT, state);
            if (scheme == null) {
                scheme = SubstanceColorSchemeUtilities.getColorScheme(tree, ColorSchemeAssociationKind.HIGHLIGHT, state);
            }
            SubstanceColorScheme prevScheme = scheme;
            if (prevState != state) {
                SubstanceColorScheme substanceColorScheme2 = prevScheme = prevState == ComponentState.DEFAULT ? ui.getDefaultColorScheme() : SubstanceColorSchemeUtilities.getColorScheme(tree, ColorSchemeAssociationKind.HIGHLIGHT, prevState);
                if (prevScheme == null) {
                    prevScheme = prevState == ComponentState.DEFAULT ? SubstanceColorSchemeUtilities.getColorScheme(tree, prevState) : SubstanceColorSchemeUtilities.getColorScheme(tree, ColorSchemeAssociationKind.HIGHLIGHT, prevState);
                }
            }
            Color color = SubstanceColorUtilities.getInterpolatedForegroundColor(tree, pathId, scheme, state, prevScheme, prevState, FadeKind.SELECTION, FadeKind.ROLLOVER);
            super.setForeground(new ColorUIResource(color));
        } else if (sel) {
            this.setForeground(UIManager.getColor("Tree.selectionForeground"));
        } else {
            this.setForeground(UIManager.getColor("Tree.textForeground"));
        }
        if (SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            SubstanceStripingUtils.applyStripedBackground(tree, row, this);
        }
        if (!tree.isEnabled()) {
            this.setEnabled(false);
            if (leaf) {
                this.setDisabledIcon(SubstanceImageCreator.toGreyscale(SubstanceImageCreator.makeTransparent(tree, this.getDefaultLeafIcon(), 0.5)));
            } else if (expanded) {
                this.setDisabledIcon(SubstanceImageCreator.toGreyscale(SubstanceImageCreator.makeTransparent(tree, this.getDefaultOpenIcon(), 0.5)));
            } else {
                this.setDisabledIcon(SubstanceImageCreator.toGreyscale(SubstanceImageCreator.makeTransparent(tree, this.getDefaultClosedIcon(), 0.5)));
            }
        } else {
            this.setEnabled(true);
            if (leaf) {
                this.setIcon(this.getDefaultLeafIcon());
            } else if (expanded) {
                this.setIcon(this.getDefaultOpenIcon());
            } else {
                this.setIcon(this.getDefaultClosedIcon());
            }
        }
        this.setComponentOrientation(tree.getComponentOrientation());
        this.setOpaque(false);
        this.selected = sel;
        if (treeUI instanceof SubstanceTreeUI) {
            ui = (SubstanceTreeUI)treeUI;
            Insets regInsets = ui.getCellRendererInsets();
            this.setBorder(new BorderUIResource.EmptyBorderUIResource(regInsets));
        }
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension retDimension = super.getPreferredSize();
        if (retDimension != null) {
            retDimension = new Dimension(retDimension.width + 3, retDimension.height);
        }
        return retDimension;
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public final void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    protected final void paintComponent(Graphics g) {
        super.paintComponent(g);
    }
}

