/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import com.incors.plaf.kunststoff.GradientTheme;
import com.incors.plaf.kunststoff.KunststoffGradientTheme;
import com.incors.plaf.kunststoff.KunststoffTheme;
import com.incors.plaf.kunststoff.KunststoffUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class KunststoffLookAndFeel
extends MetalLookAndFeel {
    private static GradientTheme gradientTheme;
    private static boolean isInstalled;
    private static boolean themeHasBeenSet;

    public KunststoffLookAndFeel() {
        if (!isInstalled) {
            UIManager.installLookAndFeel(new UIManager.LookAndFeelInfo("Kunststoff", "com.incors.plaf.kunststoff.KunststoffLookAndFeel"));
            isInstalled = true;
        }
    }

    public String getID() {
        return "Kunststoff";
    }

    public String getName() {
        return "Kunststoff";
    }

    public String getDescription() {
        return "Kunststoff Look&Feel 2.0.2. Developed by INCORS GmbH and contributors, 2001-2004. Published under the Lesser GNU Public Licence.";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        this.putDefault(table, "ButtonUI");
        this.putDefault(table, "ToggleButtonUI");
        this.putDefault(table, "ComboBoxUI");
        this.putDefault(table, "TabbedPaneUI");
        this.putDefault(table, "TextFieldUI");
        this.putDefault(table, "PasswordFieldUI");
        this.putDefault(table, "ListUI");
        this.putDefault(table, "TreeUI");
        this.putDefault(table, "ToolBarUI");
        this.putDefault(table, "MenuBarUI");
        this.putDefault(table, "MenuUI");
        this.putDefault(table, "ScrollBarUI");
        this.putDefault(table, "ProgressBarUI");
        this.putDefault(table, "TableHeaderUI");
        this.putDefault(table, "InternalFrameUI");
    }

    protected void putDefault(UIDefaults table, String uiKey) {
        try {
            String className = "com.incors.plaf.kunststoff.Kunststoff" + uiKey;
            table.put(uiKey, className);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void createDefaultTheme() {
        if (!themeHasBeenSet) {
            KunststoffLookAndFeel.setCurrentTheme(new KunststoffTheme());
        }
        if (gradientTheme == null) {
            gradientTheme = new KunststoffGradientTheme();
        }
    }

    public static void setCurrentGradientTheme(GradientTheme theme) {
        if (theme == null) {
            throw new NullPointerException("Gradient Theme cannot have null value");
        }
        gradientTheme = theme;
    }

    public static void setCurrentTheme(MetalTheme theme) {
        MetalLookAndFeel.setCurrentTheme(theme);
        themeHasBeenSet = true;
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        table.put("textHighlight", KunststoffUtilities.getTranslucentColorUIResource(KunststoffLookAndFeel.getTextHighlightColor(), 128));
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        table.put("SplitPane.dividerSize", new Integer(8));
    }

    public static ColorUIResource getComponentGradientColorReflection() {
        return gradientTheme.getComponentGradientColorReflection();
    }

    public static ColorUIResource getComponentGradientColorShadow() {
        return gradientTheme.getComponentGradientColorShadow();
    }

    public static ColorUIResource getTextComponentGradientColorReflection() {
        return gradientTheme.getTextComponentGradientColorReflection();
    }

    public static ColorUIResource getTextComponentGradientColorShadow() {
        return gradientTheme.getTextComponentGradientColorShadow();
    }

    public static int getBackgroundGradientShadow() {
        return gradientTheme.getBackgroundGradientShadow();
    }

    static {
        isInstalled = false;
        themeHasBeenSet = false;
    }
}

