/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import java.util.Iterator;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.TypeCheckerEnvironment;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.CollationMap;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.SubExpressionInfo;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.FLWORExpression;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionVisitor
implements TypeCheckerEnvironment {
    private Stack<Expression> expressionStack = new Stack();
    private Executable executable;
    private StaticContext staticContext;
    private Configuration configuration;
    private boolean optimizeForStreaming = false;

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    @Override
    public CollationMap getCollationMap() {
        return this.executable.getCollationTable();
    }

    public Stack<Expression> getExpressionStack() {
        return this.expressionStack;
    }

    public void setExpressionStack(Stack<Expression> expressionStack) {
        this.expressionStack = expressionStack;
    }

    public StaticContext getStaticContext() {
        return this.staticContext;
    }

    public void setStaticContext(StaticContext staticContext) {
        this.staticContext = staticContext;
    }

    public Expression getCurrentExpression() {
        return this.expressionStack.peek();
    }

    public static ExpressionVisitor make(StaticContext env, Executable exec) {
        ExpressionVisitor visitor = new ExpressionVisitor();
        visitor.setStaticContext(env);
        visitor.setExecutable(exec);
        visitor.setConfiguration(env.getConfiguration());
        return visitor;
    }

    @Override
    public void issueWarning(String message, SourceLocator locator) {
        this.staticContext.issueWarning(message, locator);
    }

    @Override
    public XPathContext makeDynamicContext() {
        return this.staticContext.makeEarlyEvaluationContext();
    }

    @Override
    public Expression simplify(Expression exp) throws XPathException {
        if (exp != null) {
            this.expressionStack.push(exp);
            Expression exp2 = exp.simplify(this);
            if (exp2 != exp) {
                ExpressionTool.copyLocationInfo(exp, exp2);
            }
            this.expressionStack.pop();
            return exp2;
        }
        return null;
    }

    @Override
    public Expression typeCheck(Expression exp, ContextItemType contextItemType) throws XPathException {
        if (exp != null) {
            Expression exp2;
            this.expressionStack.push(exp);
            try {
                exp2 = exp.typeCheck(this, contextItemType);
            }
            catch (XPathException e) {
                if (!e.isReportableStatically()) {
                    this.getStaticContext().issueWarning("Evaluation will always throw a dynamic error: " + e.getMessage(), exp);
                    exp2 = new ErrorExpression(e);
                }
                throw e;
            }
            if (exp2 != exp) {
                ExpressionTool.copyLocationInfo(exp, exp2);
            }
            this.expressionStack.pop();
            return exp2;
        }
        return null;
    }

    public void setOptimizeForStreaming(boolean option) {
        this.optimizeForStreaming = option;
    }

    public boolean isOptimizeForStreaming() {
        return this.optimizeForStreaming;
    }

    public Expression optimize(Expression exp, ContextItemType contextItemType) throws XPathException {
        if (exp != null) {
            this.expressionStack.push(exp);
            Expression exp2 = null;
            try {
                exp2 = exp.optimize(this, contextItemType);
            }
            catch (XPathException e) {
                if (!e.isReportableStatically()) {
                    this.getStaticContext().issueWarning("Evaluation will always throw a dynamic error: " + e.getMessage(), exp);
                    exp2 = new ErrorExpression(e);
                }
                throw e;
            }
            if (exp2 != exp) {
                ExpressionTool.copyLocationInfo(exp, exp2);
            }
            this.expressionStack.pop();
            return exp2;
        }
        return null;
    }

    public Expression getParentExpression() {
        int pos = this.expressionStack.size() - 2;
        if (pos > 0) {
            return (Expression)this.expressionStack.get(pos);
        }
        return null;
    }

    public boolean isLoopingSubexpression(Expression ancestor) {
        int top = this.expressionStack.size() - 1;
        while (top > 0) {
            Expression parent = (Expression)this.expressionStack.get(top - 1);
            if (ExpressionVisitor.hasLoopingSubexpression(parent, (Expression)this.expressionStack.get(top))) {
                return true;
            }
            if (parent == ancestor) {
                return false;
            }
            --top;
        }
        return false;
    }

    public boolean isLoopingReference(Binding binding, VariableReference ref) {
        int top = this.expressionStack.size() - 1;
        while (top > 0) {
            Expression parent = (Expression)this.expressionStack.get(top - 1);
            if (parent instanceof FLWORExpression) {
                if (parent.hasVariableBinding(binding)) {
                    return ((FLWORExpression)parent).hasLoopingVariableReference(binding);
                }
                if (ExpressionVisitor.hasLoopingSubexpression(parent, (Expression)this.expressionStack.get(top))) {
                    return true;
                }
            } else {
                if (ExpressionVisitor.hasLoopingSubexpression(parent, (Expression)this.expressionStack.get(top))) {
                    return true;
                }
                if (parent.hasVariableBinding(binding)) {
                    return false;
                }
            }
            --top;
        }
        return true;
    }

    private static boolean hasLoopingSubexpression(Expression parent, Expression child) {
        Iterator<SubExpressionInfo> iter = parent.iterateSubExpressionInfo();
        while (iter.hasNext()) {
            SubExpressionInfo info = iter.next();
            if (info.expression != child) continue;
            return info.isEvaluatedRepeatedly;
        }
        return false;
    }

    public final void resetStaticProperties() {
        for (Expression exp : this.expressionStack) {
            exp.resetLocalStaticProperties();
        }
    }

    public static class ContextItemType {
        public ItemType itemType;
        public boolean contextMaybeUndefined;

        public ContextItemType(ItemType itemType, boolean maybeUndefined) {
            this.itemType = itemType;
            this.contextMaybeUndefined = maybeUndefined;
        }
    }
}

