// Copyright 2000-2018 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.elements;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.lang.psi.stubs.PhpNamespaceStub;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PhpNamespace extends PhpNamedElement, StubBasedPsiElement<PhpNamespaceStub>, PhpScopeHolder, PsiDirectoryContainer {

  Condition<PsiElement> INSTANCEOF = use -> use instanceof PhpNamespace;

  @Nullable
  GroupStatement getStatements();

  @NotNull
  String getParentNamespaceName();

  boolean isBraced();
}
