/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.vagrant.VagrantBoxManager;
import com.jetbrains.plugins.vagrant.VagrantItem;
import com.jetbrains.plugins.vagrant.VagrantItemsModel;
import com.jetbrains.plugins.vagrant.actions.VagrantTask;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVagrantItemManager<T extends VagrantItem>
implements VagrantItemsModel<T> {
    private static final Logger LOG = Logger.getInstance(VagrantBoxManager.class);
    protected final Project myProject;
    private Ref<List<T>> myItemsCache = null;
    private String myVagrantPath;
    private final List<VagrantItemsModel.VagrantItemListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public AbstractVagrantItemManager(Project project) {
        this.myProject = project;
    }

    private List<T> parseItemsList(ProcessOutput output) {
        ArrayList result = Lists.newArrayList();
        for (String line : output.getStdoutLines()) {
            if (line.contains(this.emptyListText())) {
                return result;
            }
            result.add(this.createItem(line));
        }
        return result;
    }

    protected abstract T createItem(String var1);

    protected abstract String emptyListText();

    @Override
    public void dropCache() {
        this.myItemsCache = null;
    }

    @Override
    @Nullable
    public List<T> listItems() {
        if (this.myItemsCache == null) {
            this.myItemsCache = Ref.create(this.doListItems(this.listItemsArguments()));
        }
        return (List)this.myItemsCache.get();
    }

    protected abstract String[] listItemsArguments();

    @Nullable
    private List<T> doListItems(String ... arguments) {
        block4: {
            VagrantTask listBoxesTask = this.createTask(arguments);
            if (listBoxesTask != null) {
                try {
                    CapturingAnsiEscapesAwareProcessHandler handler = new CapturingAnsiEscapesAwareProcessHandler(listBoxesTask.createCommandLine());
                    ProcessOutput output = handler.runProcess();
                    List<T> boxes = this.parseItemsList(output);
                    if (boxes.size() == 0 && output.getExitCode() != 0) {
                        LOG.error("Error loading list " + output.getStderr());
                    }
                    return boxes;
                }
                catch (Exception e) {
                    if (!new File(this.myVagrantPath).exists()) break block4;
                    LOG.error("Can't list vagrant items: " + listBoxesTask.createCommandLine().getCommandLineString(), (Throwable)e);
                }
            }
        }
        return null;
    }

    protected VagrantTask createTask(String ... commands) {
        if (StringUtil.isEmpty((String)this.myVagrantPath)) {
            return null;
        }
        return VagrantTask.create(this.myProject, this.myVagrantPath, null, commands);
    }

    public void setVagrantPath(String vagrantPath) {
        if (!StringUtil.equals((CharSequence)vagrantPath, (CharSequence)this.myVagrantPath)) {
            this.dropCache();
        }
        this.myVagrantPath = vagrantPath;
        this.fireEvent();
    }

    protected void fireEvent() {
        for (VagrantItemsModel.VagrantItemListener l : this.myListeners) {
            l.fireEvent();
        }
    }

    @Override
    public void remove(VagrantItem box) {
        VagrantTask task = this.createTask(this.removeItemArguments(box));
        if (task != null) {
            this.runTask(task, "Deleting Vagrant " + this.getItemName(), false);
        }
    }

    protected abstract String getItemName();

    private void runTask(final @NotNull VagrantTask task, final @NotNull String title, final @Nullable Predicate<ProcessOutput> onSuccess) {
        if (task == null) {
            AbstractVagrantItemManager.$$$reportNull$$$0(0);
        }
        if (title == null) {
            AbstractVagrantItemManager.$$$reportNull$$$0(1);
        }
        Task.Backgroundable backgroundableTask = new Task.Backgroundable(this.myProject, title, true, new PerformInBackgroundOption(){

            public boolean shouldStartInBackground() {
                return false;
            }
        }){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                indicator.setFraction(0.0);
                indicator.isIndeterminate();
                try {
                    CapturingAnsiEscapesAwareProcessHandler handler = new CapturingAnsiEscapesAwareProcessHandler(task.createCommandLine());
                    ProcessOutput output = handler.runProcess();
                    if (output.getExitCode() != 0) {
                        UIUtil.invokeLaterIfNeeded(() -> {
                            if (title == null) {
                                2.$$$reportNull$$$0(2);
                            }
                            Messages.showErrorDialog((Project)this.myProject, (String)output.getStderr(), (String)title);
                        });
                    } else {
                        AbstractVagrantItemManager.this.dropCache();
                        if (onSuccess != null) {
                            onSuccess.apply((Object)output);
                        }
                        AbstractVagrantItemManager.this.fireEvent();
                    }
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    UIUtil.invokeLaterIfNeeded(() -> {
                        if (title == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        Messages.showErrorDialog((Project)this.myProject, (String)("Can't add Vagrant " + AbstractVagrantItemManager.this.getItemName() + message), (String)title);
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "title";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/plugins/vagrant/AbstractVagrantItemManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$run$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$run$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ProgressManager.getInstance().run((Task)backgroundableTask);
    }

    protected void runTask(@NotNull VagrantTask task, @NotNull String title, boolean showResult) {
        if (task == null) {
            AbstractVagrantItemManager.$$$reportNull$$$0(2);
        }
        if (title == null) {
            AbstractVagrantItemManager.$$$reportNull$$$0(3);
        }
        this.runTask(task, title, showResult ? output -> {
            if (title == null) {
                AbstractVagrantItemManager.$$$reportNull$$$0(4);
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (title == null) {
                    AbstractVagrantItemManager.$$$reportNull$$$0(5);
                }
                Messages.showInfoMessage((Project)this.myProject, (String)output.getStdout(), (String)title);
            });
            return true;
        } : null);
    }

    protected abstract String[] removeItemArguments(VagrantItem var1);

    @Override
    public void addListener(VagrantItemsModel.VagrantItemListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeListener(VagrantItemsModel.VagrantItemListener listener) {
        this.myListeners.remove(listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/vagrant/AbstractVagrantItemManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runTask";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$runTask$1";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

