/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtilRt {
    @Contract(pure=true)
    public static boolean charsEqualIgnoreCase(char a, char b) {
        return a == b || StringUtilRt.toUpperCase(a) == StringUtilRt.toUpperCase(b) || StringUtilRt.toLowerCase(a) == StringUtilRt.toLowerCase(b);
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence toUpperCase(@NotNull CharSequence s) {
        if (s == null) {
            StringUtilRt.$$$reportNull$$$0(0);
        }
        StringBuilder answer = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            char upCased = StringUtilRt.toUpperCase(c);
            if (answer == null && upCased != c) {
                answer = new StringBuilder(s.length());
                answer.append(s.subSequence(0, i));
            }
            if (answer == null) continue;
            answer.append(upCased);
        }
        CharSequence charSequence = answer == null ? s : answer;
        if (charSequence == null) {
            StringUtilRt.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    @Contract(pure=true)
    public static char toUpperCase(char a) {
        if (a < 'a') {
            return a;
        }
        if (a <= 'z') {
            return (char)(a + -32);
        }
        return Character.toUpperCase(a);
    }

    @Contract(pure=true)
    public static char toLowerCase(char a) {
        if (a < 'A' || a >= 'a' && a <= 'z') {
            return a;
        }
        if (a <= 'Z') {
            return (char)(a + 32);
        }
        return Character.toLowerCase(a);
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text) {
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(2);
        }
        String string = StringUtilRt.convertLineSeparators(text, false);
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text, boolean keepCarriageReturn) {
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(4);
        }
        String string = StringUtilRt.convertLineSeparators(text, "\n", null, keepCarriageReturn);
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator) {
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(6);
        }
        if (newSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(7);
        }
        String string = StringUtilRt.convertLineSeparators(text, newSeparator, null);
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence convertLineSeparators(@NotNull CharSequence text, @NotNull String newSeparator) {
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(9);
        }
        if (newSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(10);
        }
        CharSequence charSequence = StringUtilRt.unifyLineSeparators(text, newSeparator, null, false);
        if (charSequence == null) {
            StringUtilRt.$$$reportNull$$$0(11);
        }
        return charSequence;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator, @Nullable int[] offsetsToKeep) {
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(12);
        }
        if (newSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(13);
        }
        String string = StringUtilRt.convertLineSeparators(text, newSeparator, offsetsToKeep, false);
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator, @Nullable int[] offsetsToKeep, boolean keepCarriageReturn) {
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(15);
        }
        if (newSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(16);
        }
        String string = StringUtilRt.unifyLineSeparators(text, newSeparator, offsetsToKeep, keepCarriageReturn).toString();
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private static CharSequence unifyLineSeparators(@NotNull CharSequence text, @NotNull String newSeparator, @Nullable int[] offsetsToKeep, boolean keepCarriageReturn) {
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(18);
        }
        if (newSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(19);
        }
        StringBuilder buffer = null;
        int intactLength = 0;
        boolean newSeparatorIsSlashN = "\n".equals(newSeparator);
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                if (!newSeparatorIsSlashN) {
                    if (buffer == null) {
                        buffer = new StringBuilder(text.length());
                        buffer.append(text, 0, intactLength);
                    }
                    buffer.append(newSeparator);
                    StringUtilRt.shiftOffsets(offsetsToKeep, buffer.length(), 1, newSeparator.length());
                    continue;
                }
                if (buffer == null) {
                    ++intactLength;
                    continue;
                }
                buffer.append(c);
                continue;
            }
            if (c == '\r') {
                boolean followedByLineFeed;
                boolean bl = followedByLineFeed = i < text.length() - 1 && text.charAt(i + 1) == '\n';
                if (!followedByLineFeed && keepCarriageReturn) {
                    if (buffer == null) {
                        ++intactLength;
                        continue;
                    }
                    buffer.append(c);
                    continue;
                }
                if (buffer == null) {
                    buffer = new StringBuilder(text.length());
                    buffer.append(text, 0, intactLength);
                }
                buffer.append(newSeparator);
                if (followedByLineFeed) {
                    ++i;
                    StringUtilRt.shiftOffsets(offsetsToKeep, buffer.length(), 2, newSeparator.length());
                    continue;
                }
                StringUtilRt.shiftOffsets(offsetsToKeep, buffer.length(), 1, newSeparator.length());
                continue;
            }
            if (buffer == null) {
                ++intactLength;
                continue;
            }
            buffer.append(c);
        }
        CharSequence charSequence = buffer == null ? text : buffer;
        if (charSequence == null) {
            StringUtilRt.$$$reportNull$$$0(20);
        }
        return charSequence;
    }

    private static void shiftOffsets(int[] offsets, int changeOffset, int oldLength, int newLength) {
        if (offsets == null) {
            return;
        }
        int shift = newLength - oldLength;
        if (shift == 0) {
            return;
        }
        for (int i = 0; i < offsets.length; ++i) {
            int offset = offsets[i];
            if (offset < changeOffset + oldLength) continue;
            int n = i;
            offsets[n] = offsets[n] + shift;
        }
    }

    @Contract(pure=true)
    public static int parseInt(@Nullable String string, int defaultValue) {
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Contract(pure=true)
    public static long parseLong(@Nullable String string, long defaultValue) {
        if (string != null) {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Contract(pure=true)
    public static double parseDouble(@Nullable String string, double defaultValue) {
        if (string != null) {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Contract(pure=true)
    static <E extends Enum<E>> E parseEnum(@NotNull String string, E defaultValue, @NotNull Class<E> clazz) {
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(21);
        }
        if (clazz == null) {
            StringUtilRt.$$$reportNull$$$0(22);
        }
        try {
            return Enum.valueOf(clazz, string);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull Class aClass) {
        if (aClass == null) {
            StringUtilRt.$$$reportNull$$$0(23);
        }
        String string = StringUtilRt.getShortName(aClass.getName());
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName) {
        if (fqName == null) {
            StringUtilRt.$$$reportNull$$$0(25);
        }
        String string = StringUtilRt.getShortName(fqName, '.');
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName, char separator) {
        int lastPointIdx;
        if (fqName == null) {
            StringUtilRt.$$$reportNull$$$0(27);
        }
        if ((lastPointIdx = fqName.lastIndexOf(separator)) >= 0) {
            String string = fqName.substring(lastPointIdx + 1);
            if (string == null) {
                StringUtilRt.$$$reportNull$$$0(28);
            }
            return string;
        }
        String string = fqName;
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return s != null && s.length() != 0 && s.charAt(s.length() - 1) == suffix;
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NotNull String str, @NotNull String prefix) {
        int prefixLength;
        int stringLength;
        if (str == null) {
            StringUtilRt.$$$reportNull$$$0(30);
        }
        if (prefix == null) {
            StringUtilRt.$$$reportNull$$$0(31);
        }
        return (stringLength = str.length()) >= (prefixLength = prefix.length()) && str.regionMatches(true, 0, prefix, 0, prefixLength);
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NotNull CharSequence text, @NotNull CharSequence suffix) {
        int l2;
        int l1;
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(32);
        }
        if (suffix == null) {
            StringUtilRt.$$$reportNull$$$0(33);
        }
        if ((l1 = text.length()) < (l2 = suffix.length())) {
            return false;
        }
        for (int i = l1 - 1; i >= l1 - l2; --i) {
            if (StringUtilRt.charsEqualIgnoreCase(text.charAt(i), suffix.charAt(i + l2 - l1))) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int lastIndexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            StringUtilRt.$$$reportNull$$$0(34);
        }
        start = Math.max(start, 0);
        for (int i = Math.min(end, s.length()) - 1; i >= start; --i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable CharSequence s) {
        if (StringUtilRt.isEmpty(s)) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s) {
        String string = StringUtilRt.notNullize(s, "");
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s, @NotNull String defaultValue) {
        if (defaultValue == null) {
            StringUtilRt.$$$reportNull$$$0(36);
        }
        String string = s == null ? defaultValue : s;
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(37);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> splitHonorQuotes(@NotNull String s, char separator) {
        if (s == null) {
            StringUtilRt.$$$reportNull$$$0(38);
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder(s.length());
        boolean inQuotes = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == separator && !inQuotes) {
                if (builder.length() <= 0) continue;
                result.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            if (!(c != '\"' && c != '\'' || i > 0 && s.charAt(i - 1) == '\\')) {
                inQuotes = !inQuotes;
            }
            builder.append(c);
        }
        if (builder.length() > 0) {
            result.add(builder.toString());
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            StringUtilRt.$$$reportNull$$$0(39);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static String formatFileSize(long fileSize) {
        String string = StringUtilRt.formatFileSize(fileSize, " ");
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(40);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    @Contract(pure=true)
    public static String formatFileSize(long fileSize, @NotNull String string) {
        void unitSeparator;
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(41);
        }
        if (fileSize < 0L) {
            throw new IllegalArgumentException("Invalid value: " + fileSize);
        }
        if (fileSize == 0L) {
            String string2 = '0' + (String)unitSeparator + 'B';
            if (string2 == null) {
                StringUtilRt.$$$reportNull$$$0(42);
            }
            return string2;
        }
        int rank = (int)((Math.log10(fileSize) + 2.1714778384307465E-6) / 3.0);
        double value = (double)fileSize / Math.pow(1000.0, rank);
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB", "PB", "EB"};
        String string3 = new DecimalFormat("0.##").format(value) + (String)unitSeparator + units[rank];
        if (string3 == null) {
            StringUtilRt.$$$reportNull$$$0(43);
        }
        return string3;
    }

    @Contract(pure=true)
    public static boolean isQuotedString(@NotNull String s) {
        if (s == null) {
            StringUtilRt.$$$reportNull$$$0(44);
        }
        return s.length() > 1 && (s.charAt(0) == '\'' || s.charAt(0) == '\"') && s.charAt(0) == s.charAt(s.length() - 1);
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteString(@NotNull String s) {
        if (s == null) {
            StringUtilRt.$$$reportNull$$$0(45);
        }
        String string = StringUtilRt.isQuotedString(s) ? s.substring(1, s.length() - 1) : s;
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(46);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteString(@NotNull String s, char quotationChar) {
        if (s == null) {
            StringUtilRt.$$$reportNull$$$0(47);
        }
        boolean quoted = s.length() > 1 && quotationChar == s.charAt(0) && quotationChar == s.charAt(s.length() - 1);
        String string = quoted ? s.substring(1, s.length() - 1) : s;
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(48);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/StringUtilRt";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitSeparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/StringUtilRt";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toUpperCase";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineSeparators";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "unifyLineSeparators";
                break;
            }
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 35: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "splitHonorQuotes";
                break;
            }
            case 40: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFileSize";
                break;
            }
            case 46: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toUpperCase";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 48: {
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparators";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "unifyLineSeparators";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseEnum";
                break;
            }
            case 23: 
            case 25: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "startsWithIgnoreCase";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "endsWithIgnoreCase";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "notNullize";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "splitHonorQuotes";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "formatFileSize";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedString";
                break;
            }
            case 45: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "unquoteString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 46: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

