/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class ArgsPushNode
extends Node {
    private Node firstNode;
    private Node secondNode;

    public ArgsPushNode(SourcePosition position, Node firstNode, Node secondNode) {
        super(position);
        assert (firstNode != null) : "ArgsPushNode.first == null";
        assert (secondNode != null) : "ArgsPushNode.second == null";
        this.firstNode = this.adopt(firstNode);
        this.secondNode = this.adopt(secondNode);
    }

    public boolean isSame(Node node) {
        if (!super.isSame(node)) {
            return false;
        }
        ArgsPushNode other = (ArgsPushNode)node;
        return this.getFirstNode().isSame(other.getFirstNode()) && this.getSecondNode().isSame(other.getSecondNode());
    }

    public NodeType getNodeType() {
        return NodeType.ARGSPUSHNODE;
    }

    public Object accept(NodeVisitor visitor) {
        return visitor.visitArgsPushNode(this);
    }

    public Node getFirstNode() {
        return this.firstNode;
    }

    public Node getSecondNode() {
        return this.secondNode;
    }
}

