/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.LogConfig;
import com.github.dockerjava.api.model.LxcConf;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.RestartPolicy;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.ValueTransfer;
import com.intellij.docker.agent.cli.CliParserBase;
import com.intellij.docker.agent.cli.DockerRunCliParserBase;
import com.intellij.docker.agent.fix.FixedBindParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Function;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;

public class DockerRunCliParser
extends DockerRunCliParserBase<CreateContainerCmd> {
    public void parse(CreateContainerCmd cmd, String[] optionsLine) throws ApiTaskException {
        try {
            super.doParse((Object)cmd, optionsLine);
        }
        catch (CliParserBase.IllegalOptionException | ParseException e) {
            throw new ApiTaskException((Exception)e);
        }
    }

    protected CliParserBase.SingleValueHandler<CreateContainerCmd> hostname(Option option) {
        return new CliParserBase.EachValueHandler(option, CreateContainerCmd::withHostName);
    }

    protected CliParserBase.SingleValueHandler<CreateContainerCmd> user(Option option) {
        return new CliParserBase.EachValueHandler(option, CreateContainerCmd::withUser);
    }

    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> memory(Option option) {
        return new CliParserBase.MemoryOptionHandler(option, CreateContainerCmd::withMemory);
    }

    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> memorySwap(Option option) {
        return new CliParserBase.MemoryOptionHandler(option, CreateContainerCmd::withMemorySwap);
    }

    protected CliParserBase.IntegerOptionHandler<CreateContainerCmd> memorySwappiness(Option option) {
        return new CliParserBase.IntegerOptionHandler(option, (cmd, intValue) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withMemorySwappiness(intValue));
    }

    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> shmSize(Option option) {
        return new CliParserBase.MemoryOptionHandler(option, (cmd, size) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withShmSize(size));
    }

    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> kernelMemory(Option option) {
        return new CliParserBase.MemoryOptionHandler(option, (cmd, size) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withKernelMemory(size));
    }

    protected CliParserBase.MemoryOptionHandler<CreateContainerCmd> memoryReservation(Option option) {
        return new CliParserBase.MemoryOptionHandler(option, (cmd, size) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withMemoryReservation(size));
    }

    protected CliParserBase.SingleValueHandler<CreateContainerCmd> cpusetCpus(Option option) {
        return new CliParserBase.EachValueHandler(option, CreateContainerCmd::withCpusetCpus);
    }

    protected CliParserBase.IntegerOptionHandler<CreateContainerCmd> cpuShares(Option option) {
        return new CliParserBase.IntegerOptionHandler(option, CreateContainerCmd::withCpuShares);
    }

    protected CliParserBase.IntegerOptionHandler<CreateContainerCmd> cpuPeriod(Option option) {
        return new CliParserBase.IntegerOptionHandler(option, CreateContainerCmd::withCpuPeriod);
    }

    protected CliParserBase.IntegerOptionHandler<CreateContainerCmd> cpuQuota(Option option) {
        return new CliParserBase.IntegerOptionHandler(option, (cmd, quota) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withCpuQuota(quota));
    }

    protected CliParserBase.SingleValueHandler<CreateContainerCmd> cpusetMems(Option option) {
        return new CliParserBase.EachValueHandler(option, CreateContainerCmd::withCpusetMems);
    }

    protected CliParserBase.DoubleOptionHandler<CreateContainerCmd> cpus(Option option) {
        return new CliParserBase.DoubleOptionHandler(option, (cmd, ratio) -> {
            if (ratio > 1.0 || ratio < 0.0) {
                throw new CliParserBase.IllegalOptionException("'--cpus' value should be between 0 and 1");
            }
            int DEFAULT_PERIOD = 100000;
            DockerRunCliParser.findOrCreateHostConfig(cmd).withCpuPeriod(Integer.valueOf(100000)).withCpuQuota(Integer.valueOf((int)(ratio * 100000.0)));
        });
    }

    protected CliParserBase.IntegerOptionHandler<CreateContainerCmd> blkioWeight(Option option) {
        return new CliParserBase.IntegerOptionHandler(option, CreateContainerCmd::withBlkioWeight);
    }

    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> oomKillDisable(Option option) {
        return new CliParserBase.BooleanOptionHandlerImpl(option, CreateContainerCmd::withOomKillDisable);
    }

    protected DockerRunCliParserBase.AttachOptionHandler<CreateContainerCmd> attach(Option option) {
        return new DockerRunCliParserBase.AttachOptionHandler(option, CreateContainerCmd::withAttachStdin, CreateContainerCmd::withAttachStdout, CreateContainerCmd::withAttachStderr);
    }

    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> detach(Option option) {
        return new CliParserBase.BooleanOptionHandler<CreateContainerCmd>(option){

            protected void handleBooleanValue(boolean value) {
                if (value) {
                    ((CreateContainerCmd)this.getCmd()).withAttachStdin(Boolean.valueOf(false)).withAttachStdout(Boolean.valueOf(false)).withAttachStderr(Boolean.valueOf(false));
                }
            }
        };
    }

    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> tty(Option option) {
        return new CliParserBase.BooleanOptionHandlerImpl(option, CreateContainerCmd::withTty);
    }

    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> interactive(Option option) {
        return new CliParserBase.BooleanOptionHandler<CreateContainerCmd>(option){

            protected void handleBooleanValue(boolean value) {
                ((CreateContainerCmd)this.getCmd()).withStdinOpen(Boolean.valueOf(value));
                ((CreateContainerCmd)this.getCmd()).withAttachStdin(Boolean.valueOf(value));
            }
        };
    }

    protected CliParserBase.ListHandler<CreateContainerCmd> env(Option option) {
        return new CliParserBase.MappedListHandler(option, String.class, DockerRunCliParser::appendSystemValueIfFound, DockerRunCliParser::appendToCmdEnvironment);
    }

    protected DockerRunCliParserBase.EnvFileListHandler envFile(Option option) {
        return new DockerRunCliParserBase.EnvFileListHandler(option){

            protected void handleEnvFile(String optionValue, File file) {
                String[] envVars;
                try {
                    envVars = (String[])Files.lines(file.toPath()).map(String::trim).filter(text -> !text.isEmpty() && !text.startsWith("#")).map(x$0 -> DockerRunCliParser.appendSystemValueIfFound(x$0)).toArray(String[]::new);
                }
                catch (IOException e) {
                    throw new CliParserBase.IllegalOptionException("Error reading env-file " + optionValue);
                }
                DockerRunCliParser.appendToCmdEnvironment((CreateContainerCmd)this.getCmd(), envVars);
            }
        };
    }

    private static String appendSystemValueIfFound(String varDeclaration) {
        String localSystemValue;
        if (!varDeclaration.contains("=") && (localSystemValue = System.getProperty(varDeclaration)) != null && !localSystemValue.isEmpty()) {
            varDeclaration = varDeclaration + "=" + localSystemValue;
        }
        return varDeclaration;
    }

    private static void appendToCmdEnvironment(CreateContainerCmd cmd, String ... env) {
        new ValueTransfer.CombiningArrayTransfer(String.class, Function.identity(), CreateContainerCmd::getEnv, CreateContainerCmd::withEnv).transferFromTo(env, cmd);
    }

    protected CliParserBase.SingleValueHandler<CreateContainerCmd> entrypoint(Option option) {
        return new CliParserBase.EachValueHandler(option, (rec$, xva$0) -> ((CreateContainerCmd)rec$).withEntrypoint(new String[]{xva$0}));
    }

    protected CliParserBase.SingleValueHandler<CreateContainerCmd> workingDir(Option option) {
        return new CliParserBase.EachValueHandler(option, CreateContainerCmd::withWorkingDir);
    }

    protected CliParserBase.ListHandler<CreateContainerCmd> expose(Option option) {
        return new CliParserBase.MappedListHandler(option, ExposedPort.class, ExposedPort::parse, CreateContainerCmd::withExposedPorts);
    }

    protected CliParserBase.StringListHandler<CreateContainerCmd> addHost(Option option) {
        return new CliParserBase.StringListHandler(option, CreateContainerCmd::withExtraHosts);
    }

    protected CliParserBase.LabelListHandler<CreateContainerCmd> label(Option option) {
        return new CliParserBase.LabelListHandlerImpl(option, CreateContainerCmd::getLabels, CreateContainerCmd::withLabels);
    }

    protected CliParserBase.ListHandler<CreateContainerCmd> securityOpt(Option option) {
        return new CliParserBase.StringListHandler(option, (cmd, values) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withSecurityOpts(new ArrayList<String>(Arrays.asList(values))));
    }

    protected CliParserBase.ListHandler<CreateContainerCmd> volume(Option option) {
        return new CliParserBase.ListHandler<CreateContainerCmd>(option){

            protected void handleValueList(String[] values) {
                ArrayList<Volume> volumes = new ArrayList<Volume>();
                ArrayList<Bind> binds = new ArrayList<Bind>();
                for (String value : values) {
                    if (!value.contains(":")) {
                        volumes.add(new Volume(value));
                        continue;
                    }
                    binds.add(FixedBindParser.parse(value));
                }
                if (!volumes.isEmpty()) {
                    ((CreateContainerCmd)this.getCmd()).withVolumes(volumes);
                }
                if (!binds.isEmpty()) {
                    ((CreateContainerCmd)this.getCmd()).withBinds(binds);
                }
            }
        };
    }

    protected DockerRunCliParserBase.LinkOptionHandler<CreateContainerCmd, ?> link(Option option) {
        return new DockerRunCliParserBase.LinkOptionHandler<CreateContainerCmd, Link>(option, CreateContainerCmd::withLinks){

            protected Link createLink(String name, String alias) {
                return new Link(name, alias);
            }
        };
    }

    protected CliParserBase.ListHandler<CreateContainerCmd> lxcConf(Option option) {
        return new CliParserBase.MappedListHandler(option, LxcConf.class, source -> {
            String[] parts = source.split("=", 2);
            if (parts.length == 2) {
                return new LxcConf(parts[0].trim(), parts[1].trim());
            }
            throw new CliParserBase.IllegalOptionException(option, source);
        }, CreateContainerCmd::withLxcConf);
    }

    protected CliParserBase.SingleValueHandler<CreateContainerCmd> logDriver(Option option) {
        return new CliParserBase.SingleValueHandler<CreateContainerCmd>(option){

            protected void handleEachValue(String value) {
                for (LogConfig.LoggingType loggingType : LogConfig.LoggingType.values()) {
                    if (!loggingType.getType().equals(value)) continue;
                    DockerRunCliParser.getOrCreateLogConfig((CreateContainerCmd)this.getCmd()).setType(loggingType);
                    return;
                }
                throw new CliParserBase.IllegalOptionException(this.getOption(), value);
            }
        };
    }

    protected CliParserBase.ListHandler<CreateContainerCmd> logOpt(Option option) {
        return new CliParserBase.ListHandler<CreateContainerCmd>(option){

            protected void handleValueList(String[] values) {
                for (String value : values) {
                    String[] parts;
                    LogConfig logConfig = DockerRunCliParser.getOrCreateLogConfig((CreateContainerCmd)this.getCmd());
                    HashMap<String, String> logOptions = logConfig.getConfig();
                    if (logOptions == null) {
                        logOptions = new HashMap<String, String>();
                        logConfig.setConfig(logOptions);
                    }
                    if ((parts = value.split("=", 2)).length != 2) {
                        throw new CliParserBase.IllegalOptionException(this.getOption(), value);
                    }
                    logOptions.put(parts[0].trim(), parts[1].trim());
                }
            }
        };
    }

    protected CliParserBase.SingleValueHandler<CreateContainerCmd> macAddress(Option option) {
        return new CliParserBase.EachValueHandler(option, CreateContainerCmd::withMacAddress);
    }

    protected DockerRunCliParserBase.PortBindingOptionHandler<CreateContainerCmd, ?> publish(Option option) {
        return new DockerRunCliParserBase.PortBindingOptionHandler(option, PortBinding.class, PortBinding::parse, CreateContainerCmd::withPortBindings);
    }

    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> publishAll(Option option) {
        return new CliParserBase.BooleanOptionHandlerImpl(option, CreateContainerCmd::withPublishAllPorts);
    }

    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> privileged(Option option) {
        return new CliParserBase.BooleanOptionHandlerImpl(option, CreateContainerCmd::withPrivileged);
    }

    protected CliParserBase.StringListHandler<CreateContainerCmd> dns(Option option) {
        return new CliParserBase.StringListHandler(option, CreateContainerCmd::withDns);
    }

    protected CliParserBase.StringListHandler<CreateContainerCmd> dnsSearch(Option option) {
        return new CliParserBase.StringListHandler(option, CreateContainerCmd::withDnsSearch);
    }

    protected CliParserBase.MappedListHandler<CreateContainerCmd, ?> volumesFrom(Option option) {
        return new CliParserBase.MappedListHandler(option, VolumesFrom.class, VolumesFrom::parse, CreateContainerCmd::withVolumesFrom);
    }

    protected CliParserBase.SingleValueHandler<CreateContainerCmd> cidfile(Option option) {
        return new CliParserBase.EachValueHandler(option, CreateContainerCmd::withContainerIDFile);
    }

    protected CliParserBase.MappedListHandler<CreateContainerCmd, Capability> capAdd(Option option) {
        return new CliParserBase.MappedListHandler(option, Capability.class, Capability::valueOf, CreateContainerCmd::withCapAdd);
    }

    protected CliParserBase.MappedListHandler<CreateContainerCmd, ?> capDrop(Option option) {
        return new CliParserBase.MappedListHandler(option, Capability.class, Capability::valueOf, CreateContainerCmd::withCapDrop);
    }

    protected CliParserBase.SingleValueHandler<CreateContainerCmd> restart(Option option) {
        return new CliParserBase.EachValueHandler(option, (cmd, restart) -> cmd.withRestartPolicy(RestartPolicy.parse((String)restart)));
    }

    protected CliParserBase.SingleValueHandler<CreateContainerCmd> network(Option option) {
        return new CliParserBase.SingleValueHandler<CreateContainerCmd>(option){

            protected void handleEachValue(String value) {
                if ("none".equalsIgnoreCase(value)) {
                    ((CreateContainerCmd)this.getCmd()).withNetworkDisabled(Boolean.valueOf(true));
                } else {
                    ((CreateContainerCmd)this.getCmd()).withNetworkMode(value);
                }
            }
        };
    }

    protected CliParserBase.ListHandler<CreateContainerCmd> networkAlias(Option option) {
        return new CliParserBase.StringListHandler(option, CreateContainerCmd::withAliases);
    }

    protected CliParserBase.SingleValueHandler<CreateContainerCmd> ip(Option option) {
        return new CliParserBase.EachValueHandler(option, CreateContainerCmd::withIpv4Address);
    }

    protected CliParserBase.SingleValueHandler<CreateContainerCmd> ip6(Option option) {
        return new CliParserBase.EachValueHandler(option, CreateContainerCmd::withIpv6Address);
    }

    protected CliParserBase.MappedListHandler<CreateContainerCmd, Device> device(Option option) {
        return new CliParserBase.MappedListHandler(option, Device.class, Device::parse, CreateContainerCmd::withDevices);
    }

    protected CliParserBase.SingleValueHandler<CreateContainerCmd> runtime(Option option) {
        return new CliParserBase.EachValueHandler(option, (cmd, value) -> DockerRunCliParser.findOrCreateHostConfig(cmd).withRuntime(value));
    }

    protected CliParserBase.BooleanOptionHandler<CreateContainerCmd> rm(Option option) {
        return new CliParserBase.BooleanOptionHandler<CreateContainerCmd>(option){

            protected void handleBooleanValue(boolean value) {
                DockerRunCliParser.findOrCreateHostConfig((CreateContainerCmd)this.getCmd()).withAutoRemove(Boolean.valueOf(value));
            }
        };
    }

    private static LogConfig getOrCreateLogConfig(CreateContainerCmd cmd) {
        LogConfig result = cmd.getLogConfig();
        if (result == null) {
            result = new LogConfig();
            cmd.withLogConfig(result);
        }
        return result;
    }

    @NotNull
    private static HostConfig findOrCreateHostConfig(CreateContainerCmd cmd) {
        HostConfig result = cmd.getHostConfig();
        if (result == null) {
            result = new HostConfig();
            cmd.withHostConfig(result);
        }
        HostConfig hostConfig = result;
        if (hostConfig == null) {
            DockerRunCliParser.$$$reportNull$$$0(0);
        }
        return hostConfig;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/agent/DockerRunCliParser", "findOrCreateHostConfig"));
    }
}

