/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateSession;
import org.jetbrains.dekaf.jdbc.MssqlIntermediateSession;
import org.jetbrains.dekaf.util.Version;

public class MssqlIntermediateFacade
extends JdbcIntermediateFacade {
    private static final String CONNECTION_INFO_QUERY = "select db_name(), schema_name(), original_login(), @@version";

    public MssqlIntermediateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, @NotNull Driver driver, int connectionsLimit, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        super(connectionString, connectionProperties, driver, connectionsLimit, exceptionRecognizer);
    }

    public MssqlIntermediateFacade(@NotNull DataSource dataSource, int connectionsLimit, boolean ownConnections, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        super(dataSource, connectionsLimit, ownConnections, exceptionRecognizer);
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        return Mssql.RDBMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionInfo obtainConnectionInfoNatively() {
        JdbcIntermediateSession session = this.openSession();
        try {
            String driverVersionStr;
            String serverVersionStr;
            String rdbmsName;
            String[] env = session.queryOneRow(CONNECTION_INFO_QUERY, 4, String.class);
            if (env == null) {
                env = new String[]{null, null, null, null};
            }
            try {
                DatabaseMetaData md = session.getConnection().getMetaData();
                if (env[3] != null && env[3].contains("Azure")) {
                    rdbmsName = "Azure";
                } else {
                    rdbmsName = md.getDatabaseProductName();
                    if (rdbmsName == null) {
                        rdbmsName = session.getConnection().getClass().getName();
                    }
                }
                serverVersionStr = md.getDatabaseProductVersion();
                driverVersionStr = md.getDriverVersion();
            }
            catch (SQLException sqle) {
                throw this.getExceptionRecognizer().recognizeException(sqle, "getting versions using JDBC metadata");
            }
            Version serverVersion = MssqlIntermediateFacade.extractVersion(serverVersionStr, SIMPLE_VERSION_PATTERN, 1);
            Version driverVersion = MssqlIntermediateFacade.extractVersion(driverVersionStr, SIMPLE_VERSION_PATTERN, 1);
            ConnectionInfo connectionInfo = new ConnectionInfo(rdbmsName, env[0], env[1], env[2], serverVersion, driverVersion);
            return connectionInfo;
        }
        finally {
            session.close();
        }
    }

    @Override
    @NotNull
    protected MssqlIntermediateSession instantiateSession(@NotNull Connection connection, boolean ownConnection) {
        return new MssqlIntermediateSession(this, this.myExceptionRecognizer, connection, ownConnection);
    }
}

