/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba.calendar.ui.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class CalendarNumberOfWeekPanel
extends JPanel {
    public static final String PROPERTY_NAME_BASE_DATE = "baseDate";
    public static final String PROPERTY_NAME_LOCALE = "locale";
    public static final String PROPERTY_NAME_ZONE = "zone";
    private Color backgroundColorActive = UIManager.getColor("activeCaption");
    private Color backgroundColorInactive = UIManager.getColor("inactiveCaption");
    private Date baseDate;
    private Locale locale;
    private TimeZone zone;
    private JLabel[] labels = new JLabel[6];

    public CalendarNumberOfWeekPanel(Date baseDate, Locale locale, TimeZone timeZone) {
        this.baseDate = baseDate == null ? new Date() : baseDate;
        this.locale = locale;
        this.zone = timeZone;
        this.setLayout(new GridLayout(6, 1, 2, 2));
        for (int i = 0; i < 6; ++i) {
            JLabel l;
            this.labels[i] = l = new JLabel();
            this.add(l);
        }
        this.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
        this.reflectBaseDate();
    }

    public void setBaseDate(Date baseDate) {
        this.baseDate = baseDate;
        this.reflectBaseDate();
    }

    private void reflectBaseDate() {
        Calendar calendar = this.getCalendar(this.baseDate);
        calendar.set(5, 1);
        int skipBefore = calendar.get(7) - calendar.getFirstDayOfWeek();
        if (skipBefore < 0) {
            skipBefore = 7 + skipBefore;
        }
        int activeDays = calendar.getActualMaximum(5);
        int numActiveWeeks = (activeDays + skipBefore) / 7;
        if ((activeDays + skipBefore) % 7 > 0) {
            ++numActiveWeeks;
        }
        int startWeek = calendar.get(3);
        for (int i = 0; i < 6; ++i) {
            this.labels[i].setText(startWeek > 0 && numActiveWeeks > 0 ? String.valueOf(startWeek) : "");
            this.labels[i].setForeground(this.isEnabled() ? UIManager.getColor("controlText") : UIManager.getColor("textInactiveText"));
            ++startWeek;
            --numActiveWeeks;
        }
        this.setBackground(this.isEnabled() ? this.backgroundColorActive : this.backgroundColorInactive);
    }

    private Calendar getCalendar(Date date) {
        Calendar c = Calendar.getInstance(this.zone, this.locale);
        c.setTime(date);
        return c;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.reflectBaseDate();
    }

    public void setZone(TimeZone zone) {
        this.zone = zone;
        this.reflectBaseDate();
    }

    public void paint(Graphics g) {
        FontMetrics fm = g.getFontMetrics(this.labels[0].getFont());
        Dimension dimension = new Dimension(fm.stringWidth("00") + 8, 1);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        super.paint(g);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.reflectBaseDate();
    }
}

