/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.meta.model.YamlEnumType;
import org.jetbrains.yaml.psi.YAMLQuotedText;
import org.jetbrains.yaml.psi.YAMLScalar;

@ApiStatus.Experimental
public class YamlBooleanType
extends YamlEnumType {
    public static YamlBooleanType getSharedInstance() {
        return StandardYamlBoolean.SHARED;
    }

    public YamlBooleanType(@NotNull String name) {
        if (name == null) {
            YamlBooleanType.$$$reportNull$$$0(0);
        }
        super(name);
    }

    @Override
    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        if (scalarValue == null) {
            YamlBooleanType.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            YamlBooleanType.$$$reportNull$$$0(2);
        }
        if (scalarValue instanceof YAMLQuotedText) {
            holder.registerProblem((PsiElement)scalarValue, YAMLBundle.message("YamlBooleanType.validation.error.quoted.value", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            return;
        }
        super.validateScalarValue(scalarValue, holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scalarValue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/yaml/meta/model/YamlBooleanType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "validateScalarValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class LiteralBuilder {
        private final Set<String> myResult = new LinkedHashSet<String>();

        public LiteralBuilder withAllCasesOf(String ... literals) {
            if (literals == null) {
                LiteralBuilder.$$$reportNull$$$0(0);
            }
            for (String next : literals) {
                if (next == null) continue;
                this.withLiteral(next, LiteralBuilder::lower, LiteralBuilder::CAPS, LiteralBuilder::First);
            }
            return this;
        }

        public LiteralBuilder withLiteral(@NotNull String literal, Function<String, String> ... capitalizations) {
            if (literal == null) {
                LiteralBuilder.$$$reportNull$$$0(1);
            }
            if (capitalizations.length == 0) {
                this.myResult.add(literal);
            } else {
                for (Function<String, String> next : capitalizations) {
                    this.myResult.add(next.apply(literal));
                }
            }
            return this;
        }

        public String[] toArray() {
            return ArrayUtil.toStringArray(this.myResult);
        }

        @NotNull
        protected static String lower(@NotNull String text) {
            if (text == null) {
                LiteralBuilder.$$$reportNull$$$0(2);
            }
            String string = text.toLowerCase(Locale.ENGLISH);
            if (string == null) {
                LiteralBuilder.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        protected static String CAPS(@NotNull String text) {
            if (text == null) {
                LiteralBuilder.$$$reportNull$$$0(4);
            }
            String string = text.toUpperCase(Locale.ENGLISH);
            if (string == null) {
                LiteralBuilder.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        protected static String First(@NotNull String text) {
            if (text == null) {
                LiteralBuilder.$$$reportNull$$$0(6);
            }
            String string = StringUtil.toTitleCase((String)text);
            if (string == null) {
                LiteralBuilder.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literals";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literal";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/yaml/meta/model/YamlBooleanType$LiteralBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/yaml/meta/model/YamlBooleanType$LiteralBuilder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "lower";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "CAPS";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "First";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "withAllCasesOf";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "withLiteral";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "lower";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "CAPS";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "First";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class StandardYamlBoolean
    extends YamlBooleanType {
        private static final StandardYamlBoolean SHARED = new StandardYamlBoolean();

        StandardYamlBoolean() {
            super("yaml:boolean");
            this.setDisplayName("boolean");
            this.withLiterals("true", "false");
            this.withHiddenLiterals(new LiteralBuilder().withLiteral("true", LiteralBuilder::CAPS, LiteralBuilder::First).withLiteral("false", LiteralBuilder::CAPS, LiteralBuilder::First).withAllCasesOf("on", "off", "yes", "no").toArray());
        }
    }
}

