/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubstitutionDescriptorImpl
implements SqlCloseBlockProcessorImpl.SubstitutionDescriptor {
    private final IElementType[] myHier;
    protected final String myPrepend;
    protected final String myAppend;
    private final int myTailLevel;
    private final TailCheck[] myTailChecks;

    public SubstitutionDescriptorImpl(IElementType[] hier, String prepend, String append, int level, TailCheck ... tailChecks) {
        this.myHier = hier;
        this.myPrepend = prepend;
        this.myAppend = append;
        this.myTailLevel = level;
        this.myTailChecks = tailChecks;
    }

    @Override
    public boolean isExprRoot(@NotNull List<PsiElement> path) {
        if (path == null) {
            SubstitutionDescriptorImpl.$$$reportNull$$$0(0);
        }
        PsiElement el = (PsiElement)ContainerUtil.getLastItem(path);
        for (int i2 = this.myTailLevel; i2 < this.myHier.length; ++i2) {
            if (el == null || el.getNode() == null || el.getNode().getElementType() != this.myHier[i2]) {
                return false;
            }
            el = el.getParent();
        }
        return true;
    }

    @Override
    @Nullable
    public PsiElement getExprRoot(@NotNull PsiElement trigger) {
        if (trigger == null) {
            SubstitutionDescriptorImpl.$$$reportNull$$$0(1);
        }
        PsiElement el = trigger;
        PsiElement res2 = null;
        for (int i2 = 0; i2 < this.myHier.length; ++i2) {
            if (el == null || el.getNode() == null || el.getNode().getElementType() != this.myHier[i2]) {
                return null;
            }
            if (i2 == this.myTailLevel) {
                res2 = el;
            }
            el = el.getParent();
        }
        return res2;
    }

    private static boolean check(@NotNull List<PsiElement> path, final @NotNull TailCheck check) {
        if (path == null) {
            SubstitutionDescriptorImpl.$$$reportNull$$$0(2);
        }
        if (check == null) {
            SubstitutionDescriptorImpl.$$$reportNull$$$0(3);
        }
        return new Object(){
            int tailIdx;
            {
                this.tailIdx = check.size() - 1;
            }

            boolean visit(PsiElement el, int depth) {
                block4: {
                    boolean opt;
                    if (StringUtil.isEmptyOrSpaces((String)el.getText())) {
                        return true;
                    }
                    if (depth != check.depth(this.tailIdx)) {
                        for (el = el.getLastChild(); el != null && this.tailIdx >= 0; el = el.getPrevSibling()) {
                            if (this.visit(el, depth + 1)) continue;
                            return false;
                        }
                        return true;
                    }
                    do {
                        Object[] expected = check.get(this.tailIdx);
                        opt = check.isOpt(this.tailIdx);
                        boolean matched = expected.length == 0 || el.getNode() != null && ArrayUtil.contains((Object)el.getNode().getElementType(), (Object[])expected);
                        --this.tailIdx;
                        if (matched) break block4;
                    } while (opt);
                    return false;
                }
                return true;
            }

            boolean getResult(PsiElement root2) {
                return this.visit(root2, 0) && this.tailIdx < 0;
            }
        }.getResult((PsiElement)ContainerUtil.getLastItem(path));
    }

    @Override
    public boolean needsSubstitution(@NotNull List<PsiElement> path) {
        if (path == null) {
            SubstitutionDescriptorImpl.$$$reportNull$$$0(4);
        }
        for (TailCheck myTailCheck : this.myTailChecks) {
            if (!SubstitutionDescriptorImpl.check(path, myTailCheck)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Pair<String, String> getSubstitution(@NotNull List<PsiElement> path) {
        if (path == null) {
            SubstitutionDescriptorImpl.$$$reportNull$$$0(5);
        }
        Pair pair = Pair.create((Object)this.myPrepend, (Object)this.myAppend);
        if (pair == null) {
            SubstitutionDescriptorImpl.$$$reportNull$$$0(6);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trigger";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "check";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/editor/SubstitutionDescriptorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/editor/SubstitutionDescriptorImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isExprRoot";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getExprRoot";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "needsSubstitution";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitution";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DelimiterAware
    extends SubstitutionDescriptorImpl {
        public DelimiterAware(IElementType[] hier, String prepend, String append, int level, TailCheck ... tailChecks) {
            super(hier, prepend, append, level, tailChecks);
        }

        @Override
        @NotNull
        public Pair<String, String> getSubstitution(@NotNull List<PsiElement> path) {
            String delim;
            if (path == null) {
                DelimiterAware.$$$reportNull$$$0(0);
            }
            if (DbSqlUtil.delimiterNeedsSpacing(delim = DbSqlUtil.getDelimiterAt(path.isEmpty() ? null : path.get(0).getContainingFile(), path.isEmpty() ? 0 : path.get(0).getTextOffset()))) {
                delim = " " + delim;
            }
            Pair pair = Pair.create((Object)this.myPrepend, (Object)(this.myAppend + delim));
            if (pair == null) {
                DelimiterAware.$$$reportNull$$$0(1);
            }
            return pair;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/editor/SubstitutionDescriptorImpl$DelimiterAware";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/editor/SubstitutionDescriptorImpl$DelimiterAware";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubstitution";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSubstitution";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class TailCheckBuilder {
        private final List<IElementType[]> myTail = ContainerUtil.newArrayList();
        private final List<Integer> myItemDepths = ContainerUtil.newArrayList();
        private final List<Boolean> myMask = ContainerUtil.newArrayList();
        private int myWidth = 0;

        public TailCheckBuilder add(int depth, boolean mand, IElementType ... elementTypes) {
            this.myTail.add(elementTypes);
            this.myMask.add(mand);
            this.myItemDepths.add(depth);
            this.myWidth = Math.max(this.myWidth, elementTypes.length);
            return this;
        }

        public TailCheckBuilder add(boolean mand, IElementType ... elementTypes) {
            return this.add(1, mand, elementTypes);
        }

        public TailCheckBuilder man(IElementType ... elementTypes) {
            return this.add(true, elementTypes);
        }

        public TailCheckBuilder opt(IElementType ... elementTypes) {
            return this.add(false, elementTypes);
        }

        public TailCheck build() {
            int[] depths = new int[this.myItemDepths.size()];
            boolean[] mask = new boolean[this.myMask.size()];
            for (int i2 = 0; i2 < depths.length; ++i2) {
                depths[i2] = this.myItemDepths.get(i2);
                mask[i2] = this.myMask.get(i2);
            }
            return TailCheck.from((IElementType[][])this.myTail.toArray((T[])new IElementType[this.myTail.size()][]), depths, mask);
        }
    }

    public static class TailCheck {
        private final IElementType[][] myTail;
        private int[] myItemDepths;
        private boolean[] myMask;

        private TailCheck(@NotNull IElementType[][] tail) {
            if (tail == null) {
                TailCheck.$$$reportNull$$$0(0);
            }
            this.myTail = tail;
        }

        public static TailCheck tail(IElementType ... tail) {
            if (tail == null) {
                TailCheck.$$$reportNull$$$0(1);
            }
            IElementType[][] res2 = new IElementType[tail.length][];
            for (int i2 = 0; i2 < res2.length; ++i2) {
                res2[i2] = new IElementType[]{tail[i2]};
            }
            return new TailCheck(res2);
        }

        private static TailCheck from(IElementType[][] tail, int[] depths, boolean[] mask) {
            TailCheck res2 = new TailCheck(tail);
            res2.myMask = mask;
            res2.myItemDepths = depths;
            return res2;
        }

        public TailCheck mask(boolean ... mand) {
            if (mand == null) {
                TailCheck.$$$reportNull$$$0(2);
            }
            this.myMask = mand;
            return this;
        }

        public boolean isOpt(int i2) {
            return this.myMask != null && this.myMask.length > i2 && !this.myMask[i2];
        }

        public int depth(int i2) {
            return this.myItemDepths != null && this.myItemDepths.length > i2 ? this.myItemDepths[i2] : 1;
        }

        @NotNull
        public IElementType[] get(int i2) {
            IElementType[] iElementTypeArray = this.myTail[i2];
            if (iElementTypeArray == null) {
                TailCheck.$$$reportNull$$$0(3);
            }
            return iElementTypeArray;
        }

        public int size() {
            return this.myTail.length;
        }

        public static TailCheckBuilder builder() {
            return new TailCheckBuilder();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tail";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mand";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/editor/SubstitutionDescriptorImpl$TailCheck";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/editor/SubstitutionDescriptorImpl$TailCheck";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "tail";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "mask";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

