/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.csv;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.CsvFormatParser;
import com.intellij.database.datagrid.CsvLexer;
import com.intellij.database.datagrid.StreamCsvFormatParser;
import com.intellij.database.dbimport.ImportIndicatorUpdater;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.database.remote.dbimport.OffsetBatchRecords;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntLongHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.DoubleAdder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvInput
implements ReaderTask.Input {
    private final ThrowableComputable<InputStream, IOException> myStream;
    private final Charset myCharset;
    private final long mySizeInBytes;
    private final double myBytesPerChar;
    private final ParserChooser myChooser;
    private BufferedReader myReader;
    private CsvInputParser myParser;

    public CsvInput(@NotNull ThrowableComputable<InputStream, IOException> stream, @NotNull Charset charset, @NotNull ImportInfo info, int charCountToRead, long bytes) {
        if (stream == null) {
            CsvInput.$$$reportNull$$$0(0);
        }
        if (charset == null) {
            CsvInput.$$$reportNull$$$0(1);
        }
        if (info == null) {
            CsvInput.$$$reportNull$$$0(2);
        }
        this.myStream = stream;
        this.myBytesPerChar = charset.newEncoder().averageBytesPerChar();
        this.myCharset = charset;
        this.myChooser = new ParserChooser((CsvFormat)ObjectUtils.assertNotNull((Object)info.getFormat()), charCountToRead);
        this.mySizeInBytes = bytes;
    }

    @Override
    @Nullable
    public ReaderTask.Result read() throws InterruptedException, IOException {
        if (this.myReader == null) {
            this.myReader = new BufferedReader(new InputStreamReader((InputStream)this.myStream.compute(), this.myCharset));
        }
        if (this.myParser == null) {
            this.myParser = this.myChooser.create(this.myReader);
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        StreamCsvFormatParser.CsvParserResult result2 = this.myParser.parse(this.myReader);
        if (result2 == null) {
            return null;
        }
        List<StreamCsvFormatParser.Token[]> tokens = result2.getRecords();
        return new ReaderTask.ResultImpl(CsvInput.createBatch(tokens, (double)result2.getCharacters() * this.myBytesPerChar), result2.getErrors());
    }

    @Override
    @NotNull
    public ImportIndicatorUpdater getIndicatorUpdater(@NotNull ProgressIndicator indicator, @NotNull DoubleAdder adder, @NotNull ImportInfo info) {
        if (indicator == null) {
            CsvInput.$$$reportNull$$$0(3);
        }
        if (adder == null) {
            CsvInput.$$$reportNull$$$0(4);
        }
        if (info == null) {
            CsvInput.$$$reportNull$$$0(5);
        }
        ImportIndicatorUpdater importIndicatorUpdater = new ImportIndicatorUpdater(indicator, adder, info){

            @Override
            @Nullable
            public String calculateSpeed(long timeSpent) {
                long size = Math.round(this.myCurrentSize / (double)timeSpent);
                return size == 0L ? null : String.format("%s/s", StringUtil.formatFileSize((long)size));
            }
        };
        if (importIndicatorUpdater == null) {
            CsvInput.$$$reportNull$$$0(6);
        }
        return importIndicatorUpdater;
    }

    @Override
    public void calculateSize(@NotNull Consumer<Double> callback) {
        if (callback == null) {
            CsvInput.$$$reportNull$$$0(7);
        }
        callback.consume((Object)this.mySizeInBytes);
    }

    @Override
    public void close() {
        if (this.myReader == null) {
            return;
        }
        try {
            this.myReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    private static BatchRecords createBatch(@NotNull List<StreamCsvFormatParser.Token[]> tokens, double size) {
        if (tokens == null) {
            CsvInput.$$$reportNull$$$0(8);
        }
        ArrayList objects = ContainerUtil.newArrayList();
        TIntLongHashMap lines = new TIntLongHashMap();
        TIntLongHashMap offsets = new TIntLongHashMap();
        for (Object[] objectArray : tokens) {
            StreamCsvFormatParser.Token first = (StreamCsvFormatParser.Token)ArrayUtil.getFirstElement((Object[])objectArray);
            long lineNumber = ((StreamCsvFormatParser.Token)ObjectUtils.assertNotNull((Object)first)).getLine();
            long charNumber = ((StreamCsvFormatParser.Token)ObjectUtils.assertNotNull((Object)first)).getOffset();
            lines.put(objects.size(), lineNumber);
            offsets.put(objects.size(), charNumber);
            objects.add(ContainerUtil.map((Object[])objectArray, StreamCsvFormatParser.Token::getValue, (Object[])ArrayUtil.EMPTY_STRING_ARRAY));
        }
        MyRecords myRecords = new MyRecords(objects, lines, offsets, tokens, size);
        if (myRecords == null) {
            CsvInput.$$$reportNull$$$0(9);
        }
        return myRecords;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adder";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/csv/CsvInput";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/csv/CsvInput";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndicatorUpdater";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createBatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIndicatorUpdater";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calculateSize";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createBatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyFormatParser
    implements CsvInputParser {
        private final StreamCsvFormatParser myParser;

        private MyFormatParser(@NotNull CsvFormat format, int maxChars) {
            if (format == null) {
                MyFormatParser.$$$reportNull$$$0(0);
            }
            this.myParser = new StreamCsvFormatParser(format, maxChars);
        }

        @Override
        @Nullable
        public StreamCsvFormatParser.CsvParserResult parse(@NotNull Reader reader) throws IOException {
            if (reader == null) {
                MyFormatParser.$$$reportNull$$$0(1);
            }
            return this.myParser.parse(reader);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reader";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dbimport/csv/CsvInput$MyFormatParser";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parse";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyOneLineParser
    implements CsvInputParser {
        private boolean myEnd;

        private MyOneLineParser() {
        }

        @Override
        @Nullable
        public StreamCsvFormatParser.CsvParserResult parse(@NotNull Reader reader) throws IOException {
            if (reader == null) {
                MyOneLineParser.$$$reportNull$$$0(0);
            }
            if (this.myEnd) {
                return null;
            }
            this.myEnd = true;
            char[] buffer = new char[0x500000];
            int count2 = reader.read(buffer);
            if (count2 == -1) {
                return null;
            }
            String string = String.valueOf(buffer, 0, count2);
            int length = string.length();
            StreamCsvFormatParser.Token token = new StreamCsvFormatParser.Token(string, false, CsvLexer.TokenType.VALUE, 0L, length);
            StreamCsvFormatParser.Token[] tokens = new StreamCsvFormatParser.Token[]{token};
            List<StreamCsvFormatParser.Token[]> list = Collections.singletonList(tokens);
            return new StreamCsvFormatParser.CsvParserResult(tokens, list, MyOneLineParser.getError(reader, string.substring(0, Math.min(string.length(), 10000))), length);
        }

        @NotNull
        private static List<ErrorRecord> getError(@NotNull Reader r, @NotNull String text2) throws IOException {
            int value;
            if (r == null) {
                MyOneLineParser.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                MyOneLineParser.$$$reportNull$$$0(2);
            }
            if ((value = r.read()) == -1) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    MyOneLineParser.$$$reportNull$$$0(3);
                }
                return list;
            }
            StreamCsvFormatParser.MaxCharactersReachedException exception = new StreamCsvFormatParser.MaxCharactersReachedException(text2);
            OffsetBatchRecords.OffsetRecord record = new OffsetBatchRecords.OffsetRecord((Exception)exception, 0L, 0L);
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])new ErrorRecord[]{record});
            if (arrayList == null) {
                MyOneLineParser.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reader";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/csv/CsvInput$MyOneLineParser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/csv/CsvInput$MyOneLineParser";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getError";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "parse";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getError";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ParserChooser {
        private final CsvFormat myFormat;
        private final int myMaxChars;

        private ParserChooser(@NotNull CsvFormat format, int chars) {
            if (format == null) {
                ParserChooser.$$$reportNull$$$0(0);
            }
            this.myFormat = format;
            this.myMaxChars = chars;
        }

        @NotNull
        CsvInputParser create(@NotNull Reader reader) throws IOException {
            String line;
            CsvFormatParser parser;
            CsvDocumentDataHookUp.CsvMarkup markup;
            if (reader == null) {
                ParserChooser.$$$reportNull$$$0(1);
            }
            CsvInputParser csvInputParser = (markup = (parser = new CsvFormatParser(this.myFormat)).parse(line = CsvLexer.readAhead(reader, 10000))) == null ? new MyOneLineParser() : new MyFormatParser(this.myFormat, this.myMaxChars);
            if (csvInputParser == null) {
                ParserChooser.$$$reportNull$$$0(2);
            }
            return csvInputParser;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reader";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/csv/CsvInput$ParserChooser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/csv/CsvInput$ParserChooser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface CsvInputParser {
        @Nullable
        public StreamCsvFormatParser.CsvParserResult parse(@NotNull Reader var1) throws IOException;
    }

    private static class MyRecords
    extends OffsetBatchRecords {
        private final List<StreamCsvFormatParser.Token[]> myTokens;

        MyRecords(@NotNull List<Object[]> records, @NotNull TIntLongHashMap lines, @NotNull TIntLongHashMap startOffsets, @NotNull List<StreamCsvFormatParser.Token[]> tokens, double size) {
            if (records == null) {
                MyRecords.$$$reportNull$$$0(0);
            }
            if (lines == null) {
                MyRecords.$$$reportNull$$$0(1);
            }
            if (startOffsets == null) {
                MyRecords.$$$reportNull$$$0(2);
            }
            if (tokens == null) {
                MyRecords.$$$reportNull$$$0(3);
            }
            super(records, lines, startOffsets, size);
            this.myTokens = tokens;
        }

        @NotNull
        public ErrorRecord getErrorRecord(@NotNull Exception e, int idx) {
            if (e == null) {
                MyRecords.$$$reportNull$$$0(4);
            }
            if (!(e instanceof ImportInfo.ConversionException)) {
                ErrorRecord errorRecord = super.getErrorRecord(e, idx);
                if (errorRecord == null) {
                    MyRecords.$$$reportNull$$$0(5);
                }
                return errorRecord;
            }
            int tokenIndex = ((ImportInfo.ConversionException)e).getIndex();
            StreamCsvFormatParser.Token[] tokens = this.myTokens.get(idx);
            StreamCsvFormatParser.Token token = tokens[tokenIndex];
            OffsetBatchRecords.OffsetRecord offsetRecord = new OffsetBatchRecords.OffsetRecord(e, this.getLineNumber(idx), token.getOffset());
            if (offsetRecord == null) {
                MyRecords.$$$reportNull$$$0(6);
            }
            return offsetRecord;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "records";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lines";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startOffsets";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tokens";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/csv/CsvInput$MyRecords";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/csv/CsvInput$MyRecords";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorRecord";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrorRecord";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

